/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.spi.ItemId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IdURICache {
    private static Logger log = LoggerFactory.getLogger((Class)IdURICache.class);
    private final String workspaceUri;
    private Map idToUriCache = new HashMap();
    private Map uriToIdCache = new HashMap();

    IdURICache(String workspaceUri) {
        this.workspaceUri = workspaceUri;
    }

    public ItemId getItemId(String uri) {
        return (ItemId)this.uriToIdCache.get(IdURICache.getCleanUri(uri));
    }

    public String getUri(ItemId itemId) {
        return (String)this.idToUriCache.get(itemId);
    }

    public boolean containsUri(String uri) {
        return this.uriToIdCache.containsKey(IdURICache.getCleanUri(uri));
    }

    public boolean containsItemId(ItemId itemId) {
        return this.idToUriCache.containsKey(itemId);
    }

    public void add(String uri, ItemId itemId) {
        if (!uri.startsWith(this.workspaceUri)) {
            throw new IllegalArgumentException("Workspace missmatch.");
        }
        String cleanUri = IdURICache.getCleanUri(uri);
        this.uriToIdCache.put(cleanUri, itemId);
        this.idToUriCache.put(itemId, cleanUri);
        log.debug("Added: ItemId = " + itemId + " URI = " + cleanUri);
    }

    public void remove(String uri) {
        String cleanUri = IdURICache.getCleanUri(uri);
        Object itemId = this.uriToIdCache.remove(cleanUri);
        if (itemId != null) {
            this.idToUriCache.remove(itemId);
        }
        log.debug("Removed: ItemId = " + itemId + " URI = " + cleanUri);
    }

    public void remove(ItemId itemId) {
        Object uri = this.idToUriCache.remove(itemId);
        if (uri != null) {
            this.uriToIdCache.remove(uri);
        }
        log.debug("Removed: ItemId = " + itemId + " URI = " + uri);
    }

    private static String getCleanUri(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }
}

