/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LockInfoImpl
implements LockInfo {
    private static Logger log = LoggerFactory.getLogger((Class)LockInfoImpl.class);
    private final ActiveLock activeLock;
    private final NodeId nodeId;

    public LockInfoImpl(ActiveLock activeLock, NodeId nodeId) {
        this.activeLock = activeLock;
        this.nodeId = nodeId;
    }

    ActiveLock getActiveLock() {
        return this.activeLock;
    }

    public String getLockToken() {
        return this.isSessionScoped() ? null : this.activeLock.getToken();
    }

    public String getOwner() {
        return this.activeLock.getOwner();
    }

    public boolean isDeep() {
        return this.activeLock.isDeep();
    }

    public boolean isSessionScoped() {
        return this.activeLock.getScope() == ItemResourceConstants.EXCLUSIVE_SESSION;
    }

    public long getSecondsRemaining() {
        long timeout = this.activeLock.getTimeout();
        return timeout == Integer.MAX_VALUE ? Long.MAX_VALUE : timeout / 1000L;
    }

    public boolean isLockOwner() {
        return this.activeLock.getToken() != null;
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }
}

