/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import javax.jcr.RepositoryException;
import javax.jcr.version.OnParentVersionAction;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeConstants;
import org.w3c.dom.Element;

public abstract class QItemDefinitionImpl
implements QItemDefinition,
NodeTypeConstants {
    public static final Name ANY_NAME = NameFactoryImpl.getInstance().create("", "*");
    private final Name name;
    private final Name declaringNodeType;
    private final boolean autoCreated;
    private final int onParentVersion;
    private final boolean writeProtected;
    private final boolean mandatory;
    protected int hashCode = 0;

    QItemDefinitionImpl(Name declaringNodeType, Element itemDefElement, NamePathResolver resolver) throws RepositoryException {
        try {
            String nAttr;
            String attr = itemDefElement.getAttribute("declaringNodeType");
            if (attr != null) {
                Name dnt = resolver.getQName(attr);
                if (declaringNodeType != null && !declaringNodeType.equals(dnt)) {
                    throw new RepositoryException("Declaring nodetype mismatch: In element = '" + dnt + "', Declaring nodetype = '" + declaringNodeType + "'");
                }
                this.declaringNodeType = dnt;
            } else {
                this.declaringNodeType = declaringNodeType;
            }
            this.name = itemDefElement.hasAttribute("name") ? ((nAttr = itemDefElement.getAttribute("name")).length() > 0 ? (this.isAnyName(nAttr) ? ANY_NAME : resolver.getQName(nAttr)) : NameConstants.ROOT) : ANY_NAME;
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.autoCreated = itemDefElement.hasAttribute("autoCreated") ? Boolean.valueOf(itemDefElement.getAttribute("autoCreated")) : false;
        this.mandatory = itemDefElement.hasAttribute("mandatory") ? Boolean.valueOf(itemDefElement.getAttribute("mandatory")) : false;
        this.writeProtected = itemDefElement.hasAttribute("protected") ? Boolean.valueOf(itemDefElement.getAttribute("protected")) : false;
        this.onParentVersion = itemDefElement.hasAttribute("onParentVersion") ? OnParentVersionAction.valueFromName((String)itemDefElement.getAttribute("onParentVersion")) : 1;
    }

    public Name getDeclaringNodeType() {
        return this.declaringNodeType;
    }

    public Name getName() {
        return this.name;
    }

    public boolean isAutoCreated() {
        return this.autoCreated;
    }

    public int getOnParentVersion() {
        return this.onParentVersion;
    }

    public boolean isProtected() {
        return this.writeProtected;
    }

    public boolean isMandatory() {
        return this.mandatory;
    }

    public boolean definesResidual() {
        return this.name.equals(ANY_NAME);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QItemDefinition) {
            QItemDefinition other = (QItemDefinition)obj;
            return (this.declaringNodeType == null ? other.getDeclaringNodeType() == null : this.declaringNodeType.equals(other.getDeclaringNodeType())) && (this.name == null ? other.getName() == null : this.name.equals(other.getName())) && this.autoCreated == other.isAutoCreated() && this.onParentVersion == other.getOnParentVersion() && this.writeProtected == other.isProtected() && this.mandatory == other.isMandatory();
        }
        return false;
    }

    public abstract int hashCode();

    private boolean isAnyName(String nameAttribute) {
        return ANY_NAME.getLocalName().equals(nameAttribute);
    }
}

