/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Arrays;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.QItemDefinitionImpl;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QPropertyDefinitionImpl
extends QItemDefinitionImpl
implements QPropertyDefinition {
    private final int requiredType;
    private final String[] valueConstraints;
    private final QValue[] defaultValues;
    private final boolean multiple;

    QPropertyDefinitionImpl(Name declaringNodeType, Element pdefElement, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        super(declaringNodeType, pdefElement, resolver);
        Object qValue;
        ElementIterator it;
        this.requiredType = pdefElement.hasAttribute("requiredType") ? PropertyType.valueFromName((String)pdefElement.getAttribute("requiredType")) : 0;
        this.multiple = pdefElement.hasAttribute("multiple") ? Boolean.valueOf(pdefElement.getAttribute("multiple")) : false;
        Element child = DomUtil.getChildElement((Node)pdefElement, (String)"defaultValues", null);
        if (child == null) {
            this.defaultValues = null;
        } else {
            ArrayList<QValue> vs = new ArrayList<QValue>();
            it = DomUtil.getChildren((Element)child, (String)"defaultValue", null);
            while (it.hasNext()) {
                String jcrVal = DomUtil.getText((Element)it.nextElement());
                if (jcrVal == null) {
                    jcrVal = "";
                }
                if (this.requiredType == 2) {
                    Value v = new ValueFactoryQImpl(qValueFactory, resolver).createValue(jcrVal, this.requiredType);
                    qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                } else {
                    qValue = ValueFormat.getQValue((String)jcrVal, (int)this.requiredType, (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                }
                vs.add((QValue)qValue);
            }
            this.defaultValues = vs.toArray(new QValue[vs.size()]);
        }
        child = DomUtil.getChildElement((Node)pdefElement, (String)"valueConstraints", null);
        if (child == null) {
            this.valueConstraints = new String[0];
        } else {
            ArrayList<QValue> vc = new ArrayList<QValue>();
            it = DomUtil.getChildren((Element)child, (String)"valueConstraint", null);
            while (it.hasNext()) {
                int constType = this.requiredType == 9 ? 7 : this.requiredType;
                qValue = DomUtil.getText((Element)it.nextElement());
                if (constType == 7 || constType == 8) {
                    qValue = ValueFormat.getQValue((String)qValue, (int)constType, (NamePathResolver)resolver, (QValueFactory)qValueFactory).getString();
                }
                vc.add((QValue)qValue);
            }
            this.valueConstraints = vc.toArray(new String[vc.size()]);
        }
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public String[] getValueConstraints() {
        return this.valueConstraints;
    }

    public QValue[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean definesNode() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QPropertyDefinition) {
            QPropertyDefinition other = (QPropertyDefinition)obj;
            return super.equals(obj) && this.requiredType == other.getRequiredType() && Arrays.equals(this.valueConstraints, other.getValueConstraints()) && Arrays.equals(this.defaultValues, other.getDefaultValues()) && this.multiple == other.isMultiple();
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDeclaringNodeType().toString());
            sb.append('/');
            if (this.definesResidual()) {
                sb.append('*');
            } else {
                sb.append(this.getName().toString());
            }
            sb.append('/');
            sb.append(this.getRequiredType());
            sb.append('/');
            sb.append(this.isMultiple() ? 1 : 0);
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }
}

