/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.URIResolver;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.jcr.search.SearchResultProperty;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryInfoImpl
implements QueryInfo {
    private static final Logger log = LoggerFactory.getLogger((Class)QueryInfoImpl.class);
    private static final double UNDEFINED_SCORE = -1.0;
    private final Name[] columnNames;
    private int scoreIndex = -1;
    private final Map results = new LinkedHashMap();

    public QueryInfoImpl(MultiStatus ms, SessionInfo sessionInfo, URIResolver uriResolver, NamePathResolver resolver, ValueFactory valueFactory, QValueFactory qValueFactory) throws RepositoryException {
        int i;
        String responseDescription = ms.getResponseDescription();
        if (responseDescription != null) {
            String[] cn = responseDescription.split(" ");
            this.columnNames = new Name[cn.length];
            for (i = 0; i < cn.length; ++i) {
                String jcrColumnNames = ISO9075.decode((String)cn[i]);
                try {
                    this.columnNames[i] = resolver.getQName(jcrColumnNames);
                    if (!NameConstants.JCR_SCORE.equals(this.columnNames[i])) continue;
                    this.scoreIndex = i;
                    continue;
                }
                catch (NameException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        } else {
            throw new RepositoryException("Missing column infos: Unable to build QueryInfo object.");
        }
        MultiStatusResponse[] responses = ms.getResponses();
        for (i = 0; i < responses.length; ++i) {
            MultiStatusResponse response = responses[i];
            String href = response.getHref();
            DavPropertySet okSet = response.getProperties(200);
            DavProperty davProp = okSet.get(SearchResultProperty.SEARCH_RESULT_PROPERTY);
            SearchResultProperty resultProp = new SearchResultProperty(davProp, valueFactory);
            Value[] values = resultProp.getValues();
            QValue[] qValues = new QValue[values.length];
            for (int j = 0; j < values.length; ++j) {
                try {
                    qValues[j] = values[j] == null ? null : ValueFormat.getQValue((Value)values[j], (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                    continue;
                }
                catch (RepositoryException e) {
                    log.error("Malformed value: " + values[j].toString());
                }
            }
            NodeId nodeId = uriResolver.getNodeId(href, sessionInfo);
            this.results.put(nodeId, qValues);
        }
    }

    public RangeIterator getRows() {
        return new QueryResultRowIterator();
    }

    public Name[] getColumnNames() {
        return this.columnNames;
    }

    private class QueryResultRowIterator
    implements RangeIterator {
        private final Iterator keyIterator;
        private long pos = 0L;

        private QueryResultRowIterator() {
            this.keyIterator = QueryInfoImpl.this.results.keySet().iterator();
        }

        private QueryResultRow nextQueryResultRow() {
            final NodeId nId = (NodeId)this.keyIterator.next();
            final QValue[] qValues = (QValue[])QueryInfoImpl.this.results.get(nId);
            ++this.pos;
            return new QueryResultRow(){

                public NodeId getNodeId() {
                    return nId;
                }

                public double getScore() {
                    if (QueryInfoImpl.this.scoreIndex != -1 && qValues[QueryInfoImpl.this.scoreIndex] != null) {
                        try {
                            return Double.parseDouble(qValues[QueryInfoImpl.this.scoreIndex].getString());
                        }
                        catch (RepositoryException e) {
                            log.error("Error while building query score", (Throwable)e);
                            return -1.0;
                        }
                    }
                    log.error("Cannot determined jcr:score from query results.");
                    return -1.0;
                }

                public QValue[] getValues() {
                    return qValues;
                }
            };
        }

        public void skip(long skipNum) {
            while (skipNum-- > 0L) {
                this.nextQueryResultRow();
            }
        }

        public long getSize() {
            return QueryInfoImpl.this.results.size();
        }

        public long getPosition() {
            return this.pos;
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove not implemented");
        }

        public boolean hasNext() {
            return this.keyIterator.hasNext();
        }

        public Object next() {
            return this.nextQueryResultRow();
        }
    }
}

