/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.HashSet;
import java.util.Set;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2dav.CredentialsWrapper;

public class SessionInfoImpl
implements SessionInfo {
    private final CredentialsWrapper credentials;
    private final String workspaceName;
    private final Set lockTokens = new HashSet();
    private final Set sessionScopedTokens = new HashSet();
    private String lastBatchId;
    private NamePathResolver resolver;

    SessionInfoImpl(CredentialsWrapper creds, String workspaceName) {
        this.credentials = creds;
        this.workspaceName = workspaceName;
    }

    public String getUserID() {
        return this.credentials.getUserId();
    }

    public String getWorkspaceName() {
        return this.workspaceName;
    }

    public String[] getLockTokens() {
        return this.lockTokens.toArray(new String[this.lockTokens.size()]);
    }

    public void addLockToken(String lockToken) {
        this.lockTokens.add(lockToken);
    }

    public void removeLockToken(String lockToken) {
        this.lockTokens.remove(lockToken);
    }

    CredentialsWrapper getCredentials() {
        return this.credentials;
    }

    String getLastBatchId() {
        return this.lastBatchId;
    }

    void setLastBatchId(String batchId) {
        this.lastBatchId = batchId;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    void setNamePathResolver(NamePathResolver resolver) {
        this.resolver = resolver;
    }

    String[] getAllLockTokens() {
        HashSet s = new HashSet(this.lockTokens);
        s.addAll(this.sessionScopedTokens);
        return s.toArray(new String[s.size()]);
    }

    void addLockToken(String token, boolean sessionScoped) {
        if (sessionScoped) {
            this.sessionScopedTokens.add(token);
        } else {
            this.lockTokens.add(token);
        }
    }

    void removeLockToken(String token, boolean sessionScoped) {
        if (sessionScoped) {
            this.sessionScopedTokens.remove(token);
        } else {
            this.lockTokens.remove(token);
        }
    }
}

