/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi2dav.QItemDefinitionImpl;
import org.apache.jackrabbit.spi2dav.QNodeDefinitionImpl;
import org.apache.jackrabbit.spi2dav.QPropertyDefinitionImpl;
import org.apache.jackrabbit.webdav.jcr.nodetype.NodeTypeConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QNodeTypeDefinitionImpl
implements QNodeTypeDefinition,
NodeTypeConstants {
    private static Logger log = LoggerFactory.getLogger((Class)QNodeTypeDefinitionImpl.class);
    private final Name name;
    private final Name[] supertypes;
    private final boolean mixin;
    private final boolean orderableChildNodes;
    private final Name primaryItemName;
    private final QPropertyDefinition[] propDefs;
    private final QNodeDefinition[] nodeDefs;
    private Set dependencies;

    public QNodeTypeDefinitionImpl(Element ntdElement, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        try {
            this.name = ntdElement.hasAttribute("name") ? resolver.getQName(ntdElement.getAttribute("name")) : null;
            this.primaryItemName = ntdElement.hasAttribute("primaryItemName") ? resolver.getQName(ntdElement.getAttribute("primaryItemName")) : null;
            Element child = DomUtil.getChildElement((Node)ntdElement, (String)"supertypes", null);
            if (child != null) {
                ElementIterator stIter = DomUtil.getChildren((Element)child, (String)"supertype", null);
                ArrayList<Name> qNames = new ArrayList<Name>();
                while (stIter.hasNext()) {
                    Name st = resolver.getQName(DomUtil.getTextTrim((Element)stIter.nextElement()));
                    qNames.add(st);
                }
                this.supertypes = qNames.toArray(new Name[qNames.size()]);
            } else {
                this.supertypes = Name.EMPTY_ARRAY;
            }
            this.mixin = ntdElement.hasAttribute("isMixin") ? Boolean.valueOf(ntdElement.getAttribute("isMixin")) : false;
            this.orderableChildNodes = ntdElement.hasAttribute("hasOrderableChildNodes") ? Boolean.valueOf(ntdElement.getAttribute("hasOrderableChildNodes")) : false;
            ElementIterator it = DomUtil.getChildren((Element)ntdElement, (String)"childNodeDefinition", null);
            ArrayList<QItemDefinitionImpl> itemDefs = new ArrayList<QItemDefinitionImpl>();
            while (it.hasNext()) {
                itemDefs.add(new QNodeDefinitionImpl(this.name, it.nextElement(), resolver));
            }
            this.nodeDefs = itemDefs.toArray(new QNodeDefinition[itemDefs.size()]);
            it = DomUtil.getChildren((Element)ntdElement, (String)"propertyDefinition", null);
            itemDefs = new ArrayList();
            while (it.hasNext()) {
                itemDefs.add(new QPropertyDefinitionImpl(this.name, it.nextElement(), resolver, qValueFactory));
            }
            this.propDefs = itemDefs.toArray(new QPropertyDefinition[itemDefs.size()]);
        }
        catch (NameException e) {
            log.error(e.getMessage());
            throw new RepositoryException((Throwable)e);
        }
    }

    public Name getName() {
        return this.name;
    }

    public Name[] getSupertypes() {
        if (this.supertypes.length > 0 || this.isMixin() || NameConstants.NT_BASE.equals(this.getName())) {
            return this.supertypes;
        }
        return new Name[]{NameConstants.NT_BASE};
    }

    public Name[] getSupportedMixinTypes() {
        return null;
    }

    public boolean isMixin() {
        return this.mixin;
    }

    public boolean hasOrderableChildNodes() {
        return this.orderableChildNodes;
    }

    public Name getPrimaryItemName() {
        return this.primaryItemName;
    }

    public QPropertyDefinition[] getPropertyDefs() {
        return this.propDefs;
    }

    public QNodeDefinition[] getChildNodeDefs() {
        return this.nodeDefs;
    }

    public Collection getDependencies() {
        if (this.dependencies == null) {
            int i;
            this.dependencies = new HashSet();
            for (i = 0; i < this.supertypes.length; ++i) {
                this.dependencies.add(this.supertypes[i]);
            }
            for (i = 0; i < this.nodeDefs.length; ++i) {
                Name ntName = this.nodeDefs[i].getDefaultPrimaryType();
                if (ntName != null && !this.name.equals(ntName)) {
                    this.dependencies.add(ntName);
                }
                Name[] ntNames = this.nodeDefs[i].getRequiredPrimaryTypes();
                for (int j = 0; j < ntNames.length; ++j) {
                    if (ntNames[j] == null || this.name.equals(ntNames[j])) continue;
                    this.dependencies.add(ntNames[j]);
                }
            }
            for (i = 0; i < this.propDefs.length; ++i) {
                String[] ca;
                if (this.propDefs[i].getRequiredType() != 9 || (ca = this.propDefs[i].getValueConstraints()) == null) continue;
                for (int j = 0; j < ca.length; ++j) {
                    Name ntName = NameFactoryImpl.getInstance().create(ca[j]);
                    if (this.name.equals(ntName)) continue;
                    this.dependencies.add(ntName);
                }
            }
        }
        return this.dependencies;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QNodeTypeDefinition) {
            QNodeTypeDefinition other = (QNodeTypeDefinition)obj;
            return (this.name == null ? other.getName() == null : this.name.equals(other.getName())) && (this.primaryItemName == null ? other.getPrimaryItemName() == null : this.primaryItemName.equals(other.getPrimaryItemName())) && Arrays.equals(this.supertypes, other.getSupertypes()) && this.mixin == other.isMixin() && this.orderableChildNodes == other.hasOrderableChildNodes() && Arrays.equals(this.propDefs, other.getPropertyDefs()) && Arrays.equals(this.nodeDefs, other.getChildNodeDefs());
        }
        return false;
    }

    public int hashCode() {
        return 0;
    }
}

