/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.jcr.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

class ValueLoader {
    private final HttpClient client;

    ValueLoader(HttpClient client) {
        this.client = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadBinary(String uri, int index, Target target) throws RepositoryException, IOException {
        block4: {
            GetMethod method = new GetMethod(uri);
            try {
                int statusCode = this.client.executeMethod((HttpMethod)method);
                if (statusCode == 200) {
                    target.setStream(method.getResponseBodyAsStream());
                    break block4;
                }
                throw ExceptionConverter.generate(new DavException(statusCode, "Unable to load binary. Status line = " + method.getStatusLine().toString()));
            }
            finally {
                method.releaseConnection();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    int loadType(String uri) throws RepositoryException, IOException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(ItemResourceConstants.JCR_TYPE);
        PropFindMethod method = null;
        try {
            method = new PropFindMethod(uri, nameSet, 0);
            this.client.executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length != 1) throw new ItemNotFoundException("Internal error. Cannot retrieve property type at " + uri);
            DavPropertySet props = responses[0].getProperties(200);
            DavProperty type = props.get(ItemResourceConstants.JCR_TYPE);
            if (type != null) {
                int n = PropertyType.valueFromName((String)type.getValue().toString());
                return n;
            }
            try {
                throw new RepositoryException("Internal error. Cannot retrieve property type at " + uri);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    static interface Target {
        public void setStream(InputStream var1) throws IOException;
    }
}

