/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl
extends org.apache.jackrabbit.spi.commons.EventImpl
implements ObservationConstants {
    private static Logger log = LoggerFactory.getLogger(EventImpl.class);
    private static final NameFactory N_FACTORY = NameFactoryImpl.getInstance();

    public EventImpl(ItemId eventId, Path eventPath, NodeId parentId, int eventType, Element eventElement, NamePathResolver resolver, QValueFactory qvFactory) {
        super(EventImpl.getSpiEventType(eventType), eventPath, eventId, parentId, null, null, DomUtil.getChildTextTrim((Element)eventElement, (String)"eventuserid", (Namespace)NAMESPACE), DomUtil.getChildTextTrim((Element)eventElement, (String)"eventuserdata", (Namespace)NAMESPACE), Long.parseLong(DomUtil.getChildTextTrim((Element)eventElement, (String)"eventdate", (Namespace)NAMESPACE)), EventImpl.getEventInfo(DomUtil.getChildElement((Node)eventElement, (String)"eventinfo", (Namespace)NAMESPACE), resolver, qvFactory));
    }

    private static int getSpiEventType(int jcrEventType) {
        switch (jcrEventType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 16: {
                return 16;
            }
            case 8: {
                return 8;
            }
            case 32: {
                return 32;
            }
            case 64: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Invalid event type: " + jcrEventType);
    }

    private static Map<Name, QValue> getEventInfo(Element infoElement, NamePathResolver resolver, QValueFactory qvFactory) {
        if (infoElement == null) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Name, QValue> info = new HashMap<Name, QValue>();
        ElementIterator it = DomUtil.getChildren((Element)infoElement);
        while (it.hasNext()) {
            Element el = it.nextElement();
            String uri = el.getNamespaceURI();
            String localName = el.getLocalName();
            String value = DomUtil.getTextTrim((Element)el);
            try {
                Name n = N_FACTORY.create(uri, localName);
                QValue qv = null;
                if (value != null) {
                    qv = ValueFormat.getQValue((String)value, (int)8, (NamePathResolver)resolver, (QValueFactory)qvFactory);
                }
                info.put(n, qv);
            }
            catch (RepositoryException e) {
                log.error("Internal Error: ", (Object)e.getMessage());
            }
        }
        return info;
    }
}

