/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueConstraint;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.nodetype.constraint.ValueConstraint;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.QItemDefinitionImpl;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QPropertyDefinitionImpl
extends QItemDefinitionImpl
implements QPropertyDefinition {
    private final int requiredType;
    private final QValueConstraint[] valueConstraints;
    private final QValue[] defaultValues;
    private final boolean multiple;
    private final String[] availableQueryOperators;
    private final boolean fullTextSearcheable;
    private final boolean queryOrderable;

    QPropertyDefinitionImpl(Name declaringNodeType, Element pdefElement, NamePathResolver resolver, QValueFactory qValueFactory) throws RepositoryException {
        super(declaringNodeType, pdefElement, resolver);
        ElementIterator it;
        this.requiredType = pdefElement.hasAttribute("requiredType") ? PropertyType.valueFromName((String)pdefElement.getAttribute("requiredType")) : 0;
        this.multiple = pdefElement.hasAttribute("multiple") ? Boolean.valueOf(pdefElement.getAttribute("multiple")) : false;
        this.fullTextSearcheable = pdefElement.hasAttribute("fullTextSearchable") ? Boolean.valueOf(pdefElement.getAttribute("fullTextSearchable")) : false;
        this.queryOrderable = pdefElement.hasAttribute("queryOrderable") ? Boolean.valueOf(pdefElement.getAttribute("queryOrderable")) : false;
        Element child = DomUtil.getChildElement((Node)pdefElement, (String)"defaultValues", null);
        if (child == null) {
            this.defaultValues = null;
        } else {
            ArrayList<QValue> vs = new ArrayList<QValue>();
            it = DomUtil.getChildren((Element)child, (String)"defaultValue", null);
            while (it.hasNext()) {
                QValue qValue;
                String jcrVal = DomUtil.getText((Element)it.nextElement());
                if (jcrVal == null) {
                    jcrVal = "";
                }
                if (this.requiredType == 2) {
                    Value v = new ValueFactoryQImpl(qValueFactory, resolver).createValue(jcrVal, this.requiredType);
                    qValue = ValueFormat.getQValue((Value)v, (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                } else {
                    qValue = ValueFormat.getQValue((String)jcrVal, (int)this.requiredType, (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                }
                vs.add(qValue);
            }
            this.defaultValues = vs.toArray(new QValue[vs.size()]);
        }
        child = DomUtil.getChildElement((Node)pdefElement, (String)"valueConstraints", null);
        if (child == null) {
            this.valueConstraints = QValueConstraint.EMPTY_ARRAY;
        } else {
            ArrayList<ValueConstraint> vc = new ArrayList<ValueConstraint>();
            it = DomUtil.getChildren((Element)child, (String)"valueConstraint", null);
            while (it.hasNext()) {
                String qValue = DomUtil.getText((Element)it.nextElement());
                vc.add(ValueConstraint.create((int)this.requiredType, (String)qValue, (NamePathResolver)resolver));
            }
            this.valueConstraints = vc.toArray(new QValueConstraint[vc.size()]);
        }
        child = DomUtil.getChildElement((Node)pdefElement, (String)"availableQueryOperators", null);
        if (child == null) {
            this.availableQueryOperators = new String[0];
        } else {
            ArrayList<String> names = new ArrayList<String>();
            it = DomUtil.getChildren((Element)child, (String)"availableQueryOperator", null);
            while (it.hasNext()) {
                String str = DomUtil.getText((Element)it.nextElement());
                names.add(str);
            }
            this.availableQueryOperators = names.toArray(new String[names.size()]);
        }
    }

    public int getRequiredType() {
        return this.requiredType;
    }

    public QValueConstraint[] getValueConstraints() {
        return this.valueConstraints;
    }

    public QValue[] getDefaultValues() {
        return this.defaultValues;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public String[] getAvailableQueryOperators() {
        return this.availableQueryOperators;
    }

    public boolean isFullTextSearchable() {
        return this.fullTextSearcheable;
    }

    public boolean isQueryOrderable() {
        return this.queryOrderable;
    }

    public boolean definesNode() {
        return false;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof QPropertyDefinition) {
            QPropertyDefinition other = (QPropertyDefinition)obj;
            return super.equals(obj) && this.requiredType == other.getRequiredType() && this.multiple == other.isMultiple() && this.fullTextSearcheable == other.isFullTextSearchable() && this.queryOrderable == other.isQueryOrderable() && Arrays.equals(this.valueConstraints, other.getValueConstraints()) && Arrays.equals(this.defaultValues, other.getDefaultValues()) && Arrays.equals(this.availableQueryOperators, other.getAvailableQueryOperators());
        }
        return false;
    }

    public int hashCode() {
        if (this.hashCode == 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getDeclaringNodeType().toString());
            sb.append('/');
            if (this.definesResidual()) {
                sb.append('*');
            } else {
                sb.append(this.getName().toString());
            }
            sb.append('/');
            sb.append(this.requiredType);
            sb.append('/');
            sb.append(this.multiple ? 1 : 0);
            sb.append('/');
            sb.append(this.fullTextSearcheable ? 1 : 0);
            sb.append('/');
            sb.append(this.queryOrderable ? 1 : 0);
            sb.append('/');
            HashSet<String> s = new HashSet<String>(this.availableQueryOperators.length);
            for (int i = 0; i < this.availableQueryOperators.length; ++i) {
                s.add(this.availableQueryOperators[i]);
            }
            sb.append(((Object)s).toString());
            this.hashCode = sb.toString().hashCode();
        }
        return this.hashCode;
    }
}

