/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2davex.ChildInfoImpl;
import org.apache.jackrabbit.spi2davex.NodeInfoImpl;
import org.apache.jackrabbit.spi2davex.PropertyInfoImpl;
import org.apache.jackrabbit.spi2davex.QValueFactoryImpl;
import org.apache.jackrabbit.util.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ItemInfoJsonHandler
implements JsonHandler {
    private static Logger log = LoggerFactory.getLogger(ItemInfoJsonHandler.class);
    private static final int SPECIAL_JSON_PAIR = Integer.MAX_VALUE;
    private final List itemInfos;
    private final NamePathResolver resolver;
    private final String rootURI;
    private final QValueFactoryImpl vFactory;
    private final PathFactory pFactory;
    private final IdFactory idFactory;
    private Name name;
    private int propertyType;
    private int index = 1;
    private Stack nodeInfos = new Stack();
    private PropertyInfoImpl mvPropInfo;

    ItemInfoJsonHandler(NamePathResolver resolver, NodeInfo nInfo, String rootURI, QValueFactoryImpl vFactory, PathFactory pFactory, IdFactory idFactory) {
        this.resolver = resolver;
        this.rootURI = rootURI;
        this.vFactory = vFactory;
        this.pFactory = pFactory;
        this.idFactory = idFactory;
        this.itemInfos = new ArrayList();
        this.itemInfos.add(nInfo);
        this.nodeInfos.push(nInfo);
    }

    public void object() throws IOException {
        if (this.name != null) {
            try {
                NodeInfoImpl current = this.getCurrentNodeInfo();
                Path relPath = this.pFactory.create(this.name, this.index);
                NodeId id = this.idFactory.createNodeId(current.getId(), relPath);
                Path currentPath = current.getPath();
                Path p = this.pFactory.create(currentPath, relPath, true);
                NodeInfoImpl nInfo = new NodeInfoImpl(id, p);
                this.nodeInfos.push(nInfo);
                this.itemInfos.add(nInfo);
            }
            catch (RepositoryException e) {
                throw new IOException(e.getMessage());
            }
        }
    }

    public void endObject() throws IOException {
        try {
            NodeInfoImpl nInfo = (NodeInfoImpl)this.nodeInfos.pop();
            NodeInfoImpl parent = this.getCurrentNodeInfo();
            if (parent != null) {
                if (nInfo.getPath().getAncestor(1).equals(parent.getPath())) {
                    ChildInfoImpl ci = new ChildInfoImpl(nInfo.getName(), nInfo.getUniqueID(), nInfo.getIndex());
                    parent.addChildInfo(ci);
                } else {
                    log.debug("NodeInfo '" + nInfo.getPath() + "' out of hierarchy. Parent path = " + parent.getPath());
                }
            }
            if (!nInfo.isCompleted()) {
                log.debug("Incomplete NodeInfo '" + nInfo.getPath() + "' -> Only present as ChildInfo with its parent.");
                this.itemInfos.remove(nInfo);
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void array() throws IOException {
        try {
            this.mvPropInfo = this.createPropertyInfo(null, true);
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void endArray() throws IOException {
        try {
            if (this.propertyType == 0 && this.mvPropInfo.numberOfValues() == 0) {
                int type = this.vFactory.retrieveType(this.getValueURI());
                this.mvPropInfo.setType(type);
            }
            this.mvPropInfo.checkCompleted();
            this.getCurrentNodeInfo().addPropertyInfo(this.mvPropInfo, this.idFactory);
            this.mvPropInfo = null;
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void key(String key) throws IOException {
        try {
            if (key.equals("::NodeIteratorSize")) {
                this.propertyType = Integer.MAX_VALUE;
            } else if (key.startsWith(":")) {
                this.name = this.resolver.getQName(key.substring(1));
                this.propertyType = 2;
                this.index = 1;
            } else if (key.endsWith("]")) {
                int pos = key.lastIndexOf(91);
                this.name = this.resolver.getQName(key.substring(0, pos));
                this.propertyType = 0;
                this.index = Integer.parseInt(key.substring(pos + 1, key.length() - 1));
            } else {
                Name previousName = this.name;
                this.name = this.resolver.getQName(key);
                this.propertyType = this.guessPropertyType(this.name, previousName);
                this.index = 1;
            }
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(String value) throws IOException {
        try {
            QValue v;
            switch (this.propertyType) {
                case 0x7FFFFFFF: {
                    return;
                }
                case 2: {
                    this.propertyType = PropertyType.valueFromName((String)value);
                    return;
                }
                case 0: {
                    v = this.vFactory.create(value, 1);
                    break;
                }
                case 7: {
                    v = this.vFactory.create(this.resolver.getQName(value));
                    break;
                }
                case 8: {
                    v = this.vFactory.create(this.resolver.getQPath(value));
                    break;
                }
                default: {
                    v = this.vFactory.create(value, this.propertyType);
                }
            }
            this.value(v);
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(boolean value) throws IOException {
        if (this.propertyType == Integer.MAX_VALUE) {
            return;
        }
        try {
            this.value(this.vFactory.create(value));
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(long value) throws IOException {
        if (this.propertyType == Integer.MAX_VALUE) {
            NodeInfoImpl parent = this.getCurrentNodeInfo();
            if (parent != null) {
                parent.setNumberOfChildNodes(value);
            }
            return;
        }
        try {
            QValue v;
            if (this.propertyType == 2) {
                int indx = this.mvPropInfo == null ? -1 : this.mvPropInfo.numberOfValues();
                v = this.vFactory.create(value, this.getValueURI(), indx);
            } else {
                v = this.vFactory.create(value);
            }
            this.value(v);
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void value(double value) throws IOException {
        if (this.propertyType == Integer.MAX_VALUE) {
            return;
        }
        try {
            this.value(this.vFactory.create(value));
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    private void value(QValue value) throws RepositoryException {
        if (this.mvPropInfo == null) {
            this.createPropertyInfo(value, false);
        } else {
            this.mvPropInfo.addValue(value);
        }
    }

    Iterator getItemInfos() {
        return Collections.unmodifiableList(this.itemInfos).iterator();
    }

    private NodeInfoImpl getCurrentNodeInfo() {
        return this.nodeInfos.isEmpty() ? (NodeInfoImpl)null : (NodeInfoImpl)this.nodeInfos.peek();
    }

    private PropertyInfoImpl createPropertyInfo(QValue value, boolean isMultiValued) throws RepositoryException {
        PropertyInfoImpl pInfo;
        NodeInfoImpl parent = this.getCurrentNodeInfo();
        Path p = this.pFactory.create(parent.getPath(), this.name, true);
        PropertyId id = this.idFactory.createPropertyId(parent.getId(), this.name);
        if (isMultiValued) {
            pInfo = new PropertyInfoImpl(id, p, this.propertyType);
        } else {
            pInfo = new PropertyInfoImpl(id, p, this.propertyType, value);
            parent.addPropertyInfo(pInfo, this.idFactory);
        }
        this.itemInfos.add(pInfo);
        return pInfo;
    }

    private String getValueURI() throws RepositoryException {
        Path propertyPath = this.mvPropInfo == null ? this.pFactory.create(this.getCurrentNodeInfo().getPath(), this.name, true) : this.mvPropInfo.getPath();
        StringBuffer sb = new StringBuffer(this.rootURI);
        sb.append(Text.escapePath((String)this.resolver.getJCRPath(propertyPath)));
        return sb.toString();
    }

    private int guessPropertyType(Name name, Name previousName) {
        if (name.equals(previousName)) {
            return this.propertyType;
        }
        return 0;
    }
}

