/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.params.HttpMethodParams;
import org.apache.commons.httpclient.util.EncodingUtil;
import org.apache.jackrabbit.webdav.client.methods.DavMethodBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PostMethod
extends DavMethodBase {
    private static Logger log = LoggerFactory.getLogger(PostMethod.class);
    public static final String FORM_URL_ENCODED_CONTENT_TYPE = "application/x-www-form-urlencoded; charset=utf-8";
    private List params = new ArrayList();

    public PostMethod(String uri) {
        super(uri);
        HttpMethodParams params = this.getParams();
        params.setContentCharset("UTF-8");
    }

    protected boolean isSuccess(int statusCode) {
        return statusCode == 200 || statusCode == 204 || statusCode == 201;
    }

    public String getName() {
        return "POST";
    }

    protected boolean hasRequestContent() {
        if (!this.params.isEmpty()) {
            return true;
        }
        return super.hasRequestContent();
    }

    protected void clearRequestBody() {
        log.debug("enter PostMethod.clearRequestBody()");
        this.params.clear();
        super.clearRequestBody();
    }

    protected RequestEntity generateRequestEntity() {
        if (!this.params.isEmpty()) {
            NameValuePair[] mvps = this.params.toArray(new NameValuePair[this.params.size()]);
            String content = EncodingUtil.formUrlEncode((NameValuePair[])mvps, (String)this.getRequestCharSet());
            ByteArrayRequestEntity entity = new ByteArrayRequestEntity(EncodingUtil.getAsciiBytes((String)content), FORM_URL_ENCODED_CONTENT_TYPE);
            return entity;
        }
        return super.generateRequestEntity();
    }

    public void addParameter(String paramName, String paramValue) throws IllegalArgumentException {
        log.debug("enter PostMethod.addParameter(String, String)");
        if (paramName == null || paramValue == null) {
            throw new IllegalArgumentException("Arguments to addParameter(String, String) cannot be null");
        }
        super.clearRequestBody();
        this.params.add(new NameValuePair(paramName, paramValue));
    }
}

