/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi2davex.ItemInfoImpl;
import org.apache.jackrabbit.spi2davex.PropertyInfoImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInfoImpl
extends ItemInfoImpl
implements NodeInfo {
    private NodeId id;
    private String uniqueID;
    private Name primaryNodeTypeName;
    private Name[] mixinNodeTypeNames = new Name[0];
    private final Set<PropertyInfo> propertyInfos = new LinkedHashSet<PropertyInfo>();
    private Set<ChildInfo> childInfos = null;

    public NodeInfoImpl(NodeId id, Path path) throws RepositoryException {
        super(path, true);
        this.id = id;
    }

    public NodeId getId() {
        return this.id;
    }

    public int getIndex() {
        return this.getPath().getNameElement().getNormalizedIndex();
    }

    public Name getNodetype() {
        return this.primaryNodeTypeName;
    }

    public Name[] getMixins() {
        return this.mixinNodeTypeNames;
    }

    public PropertyId[] getReferences() {
        return new PropertyId[0];
    }

    public Iterator<PropertyId> getPropertyIds() {
        ArrayList<PropertyId> l = new ArrayList<PropertyId>();
        for (PropertyInfo propertyInfo : this.propertyInfos) {
            l.add(propertyInfo.getId());
        }
        return l.iterator();
    }

    public Iterator<ChildInfo> getChildInfos() {
        return this.childInfos == null ? null : this.childInfos.iterator();
    }

    void addPropertyInfo(PropertyInfoImpl propInfo, IdFactory idFactory) throws RepositoryException {
        this.propertyInfos.add(propInfo);
        Name pn = propInfo.getId().getName();
        if (NameConstants.JCR_UUID.equals(pn)) {
            this.uniqueID = propInfo.getValues()[0].getString();
            this.id = idFactory.createNodeId(this.uniqueID);
        } else if (NameConstants.JCR_PRIMARYTYPE.equals(pn)) {
            this.primaryNodeTypeName = propInfo.getValues()[0].getName();
        } else if (NameConstants.JCR_MIXINTYPES.equals(pn)) {
            QValue[] vs = propInfo.getValues();
            Name[] mixins = new Name[vs.length];
            for (int i = 0; i < vs.length; ++i) {
                mixins[i] = vs[i].getName();
            }
            this.mixinNodeTypeNames = mixins;
        }
    }

    void resolveUUID(IdFactory idFactory) {
        if (this.uniqueID != null) {
            for (PropertyInfo o : this.propertyInfos) {
                PropertyInfoImpl propInfo = (PropertyInfoImpl)o;
                propInfo.setId(idFactory.createPropertyId(this.id, propInfo.getName()));
            }
        }
    }

    void addChildInfo(ChildInfo childInfo) {
        if (this.childInfos == null) {
            this.childInfos = new LinkedHashSet<ChildInfo>();
        }
        this.childInfos.add(childInfo);
    }

    void setNumberOfChildNodes(long numberOfChildNodes) {
        if (numberOfChildNodes == 0L) {
            this.childInfos = Collections.emptySet();
        }
    }

    boolean isCompleted() {
        return this.id != null && this.primaryNodeTypeName != null && !this.propertyInfos.isEmpty();
    }

    void checkCompleted() throws RepositoryException {
        if (!this.isCompleted()) {
            throw new RepositoryException("Incomplete NodeInfo");
        }
    }

    String getUniqueID() {
        return this.uniqueID;
    }
}

