/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi2davex.ItemInfoImpl;

public class PropertyInfoImpl
extends ItemInfoImpl
implements PropertyInfo {
    private final boolean isMultiValued;
    private PropertyId id;
    private int propertyType;
    private List<QValue> values = new ArrayList<QValue>();

    public PropertyInfoImpl(PropertyId id, Path path, int propertyType, QValue singleValue) throws RepositoryException {
        super(path, false);
        this.id = id;
        this.propertyType = propertyType;
        this.isMultiValued = false;
        this.values.add(singleValue);
    }

    public PropertyInfoImpl(PropertyId id, Path path, int propertyType) throws RepositoryException {
        super(path, false);
        this.id = id;
        this.propertyType = propertyType;
        this.isMultiValued = true;
    }

    public PropertyId getId() {
        return this.id;
    }

    public int getType() {
        if (this.propertyType == 0) {
            this.propertyType = this.getValues()[0].getType();
        }
        return this.propertyType;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public QValue[] getValues() {
        return this.values.toArray(new QValue[this.values.size()]);
    }

    int numberOfValues() {
        return this.values.size();
    }

    void setId(PropertyId id) {
        this.id = id;
    }

    void addValue(QValue value) throws RepositoryException {
        if (this.values == null) {
            this.values = new ArrayList<QValue>();
        } else if (!this.isMultiValued && !this.values.isEmpty()) {
            throw new RepositoryException("Attempt to add multiple values to a single valued PropertyInfo");
        }
        this.values.add(value);
    }

    void setType(int propertyType) {
        this.propertyType = propertyType;
    }

    void checkCompleted() throws RepositoryException {
        if (this.id == null) {
            throw new RepositoryException("Incomplete PropertyInfo: id missing.");
        }
        if (this.values.size() == 0 && this.propertyType == 0) {
            throw new RepositoryException("Incomplete PropertyInfo: missing type of multivalued property.");
        }
    }
}

