/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.commons.webdav.JcrValueType;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2davex.BinaryPart;
import org.apache.jackrabbit.spi2davex.BinaryPartSource;
import org.apache.jackrabbit.spi2davex.StringPart;

final class Utils {
    private static final String DEFAULT_CHARSET = "UTF-8";

    private Utils() {
    }

    static String getJsonKey(String str) {
        return JsonUtil.getJsonString((String)str) + ":";
    }

    static String getJsonString(QValue value) throws RepositoryException {
        String str;
        switch (value.getType()) {
            case 1: {
                str = JsonUtil.getJsonString((String)value.getString());
                break;
            }
            case 3: 
            case 6: {
                str = value.getString();
                break;
            }
            case 4: {
                double d = value.getDouble();
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    str = null;
                    break;
                }
                str = value.getString();
                if (str.indexOf(46) != -1) break;
                str = str + ".0";
                break;
            }
            default: {
                str = null;
            }
        }
        return str;
    }

    static void addPart(String paramName, String value, List<Part> parts) {
        parts.add((Part)new StringPart(paramName, value, DEFAULT_CHARSET));
    }

    static void addPart(String paramName, QValue value, NamePathResolver resolver, List<Part> parts) throws RepositoryException {
        Object part;
        switch (value.getType()) {
            case 2: {
                part = new BinaryPart(paramName, new BinaryPartSource(value), JcrValueType.contentTypeFromType((int)2), DEFAULT_CHARSET);
                break;
            }
            case 7: {
                part = new StringPart(paramName, resolver.getJCRName(value.getName()), DEFAULT_CHARSET);
                break;
            }
            case 8: {
                part = new StringPart(paramName, resolver.getJCRPath(value.getPath()), DEFAULT_CHARSET);
                break;
            }
            default: {
                part = new StringPart(paramName, value.getString(), DEFAULT_CHARSET);
            }
        }
        String ctype = JcrValueType.contentTypeFromType((int)value.getType());
        ((PartBase)part).setContentType(ctype);
        parts.add((Part)part);
    }

    static void removeParts(String paramName, List<Part> parts) {
        Iterator<Part> it = parts.iterator();
        while (it.hasNext()) {
            Part part = it.next();
            if (!part.getName().equals(paramName)) continue;
            it.remove();
        }
    }
}

