/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.message.BasicNameValuePair;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.commons.json.JsonParser;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.commons.webdav.ValueUtil;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Tree;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.identifier.IdFactoryImpl;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.tree.AbstractTree;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.spi2davex.BatchReadConfig;
import org.apache.jackrabbit.spi2davex.HttpPost;
import org.apache.jackrabbit.spi2davex.ItemInfoJsonHandler;
import org.apache.jackrabbit.spi2davex.NodeInfoImpl;
import org.apache.jackrabbit.spi2davex.PropertyInfoImpl;
import org.apache.jackrabbit.spi2davex.QValueFactoryImpl;
import org.apache.jackrabbit.spi2davex.Utils;
import org.apache.jackrabbit.spi2davex.ValueLoader;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.HttpPropfind;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RepositoryServiceImpl
extends org.apache.jackrabbit.spi2dav.RepositoryServiceImpl {
    private static Logger log = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final String PARAM_DIFF = ":diff";
    private static final String PARAM_COPY = ":copy";
    private static final String PARAM_CLONE = ":clone";
    private static final char SYMBOL_ADD_NODE = '+';
    private static final char SYMBOL_MOVE = '>';
    private static final char SYMBOL_REMOVE = '-';
    private static final char SYMBOL_SET_PROPERTY = '^';
    private static final String ORDER_POSITION_LAST = "#last";
    private static final String ORDER_POSITION_BEFORE = "#before";
    private static final DavPropertyName JCR_TYPE = DavPropertyName.create((String)"type", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyName JCR_LENGTH = DavPropertyName.create((String)"length", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyName JCR_LENGTHS = DavPropertyName.create((String)"lengths", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyName JCR_GET_STRING = DavPropertyName.create((String)"getstring", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyNameSet LAZY_PROPERTY_NAME_SET = new DavPropertyNameSet(){
        {
            this.add(JCR_TYPE);
            this.add(JCR_LENGTH);
            this.add(JCR_LENGTHS);
            this.add(JCR_GET_STRING);
        }
    };
    private final String jcrServerURI;
    private final String defaultWorkspaceName;
    private final BatchReadConfig batchReadConfig;
    private final Map<SessionInfo, QValueFactoryImpl> qvFactories = new HashMap<SessionInfo, QValueFactoryImpl>();

    public RepositoryServiceImpl(String jcrServerURI, BatchReadConfig batchReadConfig) throws RepositoryException {
        this(jcrServerURI, null, batchReadConfig, 5000);
    }

    public RepositoryServiceImpl(String jcrServerURI, String defaultWorkspaceName, BatchReadConfig batchReadConfig, int itemInfoCacheSize) throws RepositoryException {
        this(jcrServerURI, defaultWorkspaceName, batchReadConfig, itemInfoCacheSize, 20);
    }

    public RepositoryServiceImpl(String jcrServerURI, String defaultWorkspaceName, BatchReadConfig batchReadConfig, int itemInfoCacheSize, int maximumHttpConnections) throws RepositoryException {
        super(jcrServerURI, IdFactoryImpl.getInstance(), NameFactoryImpl.getInstance(), PathFactoryImpl.getInstance(), (QValueFactory)new QValueFactoryImpl(), itemInfoCacheSize, maximumHttpConnections);
        try {
            URI repositoryUri = RepositoryServiceImpl.computeRepositoryUri(jcrServerURI);
            this.jcrServerURI = repositoryUri.toString();
        }
        catch (URISyntaxException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.defaultWorkspaceName = defaultWorkspaceName;
        this.batchReadConfig = batchReadConfig == null ? new BatchReadConfig(){

            @Override
            public int getDepth(Path path, PathResolver resolver) {
                return 0;
            }
        } : batchReadConfig;
    }

    private Path getPath(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        return this.getPath(itemId, sessionInfo, sessionInfo.getWorkspaceName());
    }

    private Path getPath(ItemId itemId, SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        if (itemId.denotesNode()) {
            String jcrPath;
            String rootUri;
            Path p = itemId.getPath();
            String uid = itemId.getUniqueID();
            if (uid == null) {
                return p;
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            String uri = super.getItemUri(itemId, sessionInfo, workspaceName);
            if (uri.startsWith(rootUri = this.getRootURI(sessionInfo))) {
                jcrPath = uri.substring(rootUri.length());
            } else {
                log.warn("ItemURI " + uri + " doesn't start with rootURI (" + rootUri + ").");
                String rootSegment = Text.escapePath((String)"/jcr:root");
                jcrPath = uri.substring(uri.indexOf(rootSegment) + rootSegment.length());
            }
            jcrPath = Text.unescape((String)jcrPath);
            return resolver.getQPath(jcrPath);
        }
        PropertyId pId = (PropertyId)itemId;
        Path parentPath = this.getPath((ItemId)pId.getParentId(), sessionInfo, workspaceName);
        return this.getPathFactory().create(parentPath, pId.getName(), true);
    }

    private String getURI(Path path, SessionInfo sessionInfo) throws RepositoryException {
        StringBuilder sb = new StringBuilder(this.getRootURI(sessionInfo));
        String jcrPath = this.getNamePathResolver(sessionInfo).getJCRPath(path);
        sb.append(Text.escapePath((String)jcrPath));
        return sb.toString();
    }

    private String getURI(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        Path p = this.getPath(itemId, sessionInfo);
        if (p == null) {
            return super.getItemUri(itemId, sessionInfo);
        }
        return this.getURI(p, sessionInfo);
    }

    private String getRootURI(SessionInfo sessionInfo) {
        StringBuilder sb = new StringBuilder(this.getWorkspaceURI(sessionInfo));
        sb.append(Text.escapePath((String)"/jcr:root"));
        return sb.toString();
    }

    private String getWorkspaceURI(SessionInfo sessionInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.jcrServerURI);
        sb.append(Text.escape((String)sessionInfo.getWorkspaceName()));
        return sb.toString();
    }

    private QValueFactoryImpl getQValueFactory(SessionInfo sessionInfo) throws RepositoryException {
        QValueFactoryImpl qv;
        if (this.qvFactories.containsKey(sessionInfo)) {
            qv = this.qvFactories.get(sessionInfo);
        } else {
            ValueLoader loader = new ValueLoader(this.getClient(sessionInfo), this.getContext(sessionInfo));
            qv = new QValueFactoryImpl(this.getNamePathResolver(sessionInfo), loader);
            this.qvFactories.put(sessionInfo, qv);
        }
        return qv;
    }

    @Override
    public SessionInfo obtain(Credentials credentials, String workspaceName) throws RepositoryException {
        String wspName = workspaceName == null ? this.defaultWorkspaceName : workspaceName;
        return super.obtain(credentials, wspName);
    }

    @Override
    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        String wspName = workspaceName == null ? this.defaultWorkspaceName : workspaceName;
        return super.obtain(sessionInfo, wspName);
    }

    @Override
    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        super.dispose(sessionInfo);
        this.qvFactories.remove(sessionInfo);
    }

    @Override
    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        if (!itemId.denotesNode()) {
            PropertyInfo propertyInfo = this.getPropertyInfo(sessionInfo, (PropertyId)itemId);
            return Iterators.singleton((Object)propertyInfo);
        }
        NodeId nodeId = (NodeId)itemId;
        Path path = this.getPath(itemId, sessionInfo);
        String uri = this.getURI(path, sessionInfo);
        int depth = this.batchReadConfig.getDepth(path, (PathResolver)this.getNamePathResolver(sessionInfo));
        HttpGet request = new HttpGet(uri + "." + depth + ".json");
        HttpResponse response = null;
        try {
            response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode == 200) {
                HttpEntity entity = response.getEntity();
                if (entity.getContentLength() == 0L) {
                    throw new ItemNotFoundException("No such item " + nodeId);
                }
                NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
                NodeInfoImpl nInfo = new NodeInfoImpl(nodeId, path);
                ItemInfoJsonHandler handler = new ItemInfoJsonHandler(resolver, nInfo, this.getRootURI(sessionInfo), this.getQValueFactory(sessionInfo), this.getPathFactory(), this.getIdFactory());
                JsonParser ps = new JsonParser((JsonHandler)handler);
                ps.parse(entity.getContent(), ContentType.get((HttpEntity)entity).getCharset().name());
                Iterator<? extends ItemInfo> it = handler.getItemInfos();
                if (!it.hasNext()) {
                    throw new ItemNotFoundException("No such node " + uri);
                }
                Iterator<? extends ItemInfo> iterator = handler.getItemInfos();
                return iterator;
            }
            try {
                throw ExceptionConverter.generate(new DavException(statusCode, "Unable to retrieve NodeInfo for " + uri), (HttpRequestBase)request);
            }
            catch (IOException e) {
                log.error("Internal error while retrieving NodeInfo for " + uri + ".", (Throwable)e);
                throw new RepositoryException(e.getMessage(), (Throwable)e);
            }
        }
        finally {
            request.releaseConnection();
        }
    }

    @Override
    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        Path p = this.getPath((ItemId)propertyId, sessionInfo);
        String uri = this.getURI(p, sessionInfo);
        HttpPropfind request = null;
        try {
            request = new HttpPropfind(uri, LAZY_PROPERTY_NAME_SET, 0);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            MultiStatusResponse[] mresponses = request.getResponseBodyAsMultiStatus(response).getResponses();
            if (mresponses.length != 1) {
                throw new ItemNotFoundException("Unable to retrieve the PropertyInfo. No such property " + uri);
            }
            MultiStatusResponse mresponse = mresponses[0];
            DavPropertySet props = mresponse.getProperties(200);
            int propertyType = PropertyType.valueFromName((String)props.get(JCR_TYPE).getValue().toString());
            if (propertyType == 2) {
                DavProperty lengthsProp = props.get(JCR_LENGTHS);
                if (lengthsProp != null) {
                    long[] lengths = ValueUtil.lengthsFromXml((Object)lengthsProp.getValue());
                    QValue[] qValues = new QValue[lengths.length];
                    for (int i = 0; i < lengths.length; ++i) {
                        qValues[i] = this.getQValueFactory(sessionInfo).create(lengths[i], uri, i);
                    }
                    PropertyInfoImpl i = new PropertyInfoImpl(propertyId, p, propertyType, qValues);
                    return i;
                }
                long length = Long.parseLong(props.get(JCR_LENGTH).getValue().toString());
                QValue qValue = this.getQValueFactory(sessionInfo).create(length, uri, -1);
                PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, p, propertyType, qValue);
                return propertyInfoImpl;
            }
            if (props.contains(JCR_GET_STRING)) {
                Object v = props.get(JCR_GET_STRING).getValue();
                String str = v == null ? "" : v.toString();
                QValue qValue = ValueFormat.getQValue((String)str, (int)propertyType, (NamePathResolver)this.getNamePathResolver(sessionInfo), (QValueFactory)this.getQValueFactory(sessionInfo));
                PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, p, propertyType, qValue);
                return propertyInfoImpl;
            }
            PropertyInfo propertyInfo = super.getPropertyInfo(sessionInfo, propertyId);
            return propertyInfo;
        }
        catch (IOException e) {
            log.error("Internal error while retrieving ItemInfo for " + uri + ".", (Throwable)e);
            throw new RepositoryException(e.getMessage(), (Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        return new BatchImpl(itemId, sessionInfo);
    }

    @Override
    public void submit(Batch batch) throws RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation.");
        }
        BatchImpl batchImpl = (BatchImpl)batch;
        try {
            if (!batchImpl.isEmpty()) {
                batchImpl.start();
            }
        }
        finally {
            batchImpl.dispose();
        }
    }

    @Override
    public Tree createTree(SessionInfo sessionInfo, Batch batch, Name nodeName, Name primaryTypeName, String uniqueId) throws RepositoryException {
        return new JsonTree(sessionInfo, nodeName, primaryTypeName, uniqueId, this.getNamePathResolver(sessionInfo));
    }

    @Override
    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        if (srcWorkspaceName.equals(sessionInfo.getWorkspaceName())) {
            super.copy(sessionInfo, srcWorkspaceName, srcNodeId, destParentNodeId, destName);
            return;
        }
        HttpPost request = null;
        try {
            request = new HttpPost(this.getWorkspaceURI(sessionInfo));
            request.setHeader("Referer", request.getURI().toASCIIString());
            RepositoryServiceImpl.addIfHeader(sessionInfo, (HttpUriRequest)request);
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            StringBuilder args = new StringBuilder();
            args.append(srcWorkspaceName);
            args.append(",");
            args.append(resolver.getJCRPath(this.getPath((ItemId)srcNodeId, sessionInfo, srcWorkspaceName)));
            args.append(",");
            String destParentPath = resolver.getJCRPath(this.getPath((ItemId)destParentNodeId, sessionInfo));
            String destPath = destParentPath.endsWith("/") ? destParentPath + resolver.getJCRName(destName) : destParentPath + "/" + resolver.getJCRName(destName);
            args.append(destPath);
            List<BasicNameValuePair> nvps = Collections.singletonList(new BasicNameValuePair(PARAM_COPY, args.toString()));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, Charset.forName("UTF-8"));
            request.setEntity((HttpEntity)entity);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, request);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    @Override
    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws RepositoryException {
        HttpPost request = null;
        try {
            request = new HttpPost(this.getWorkspaceURI(sessionInfo));
            request.setHeader("Referer", request.getURI().toASCIIString());
            RepositoryServiceImpl.addIfHeader(sessionInfo, (HttpUriRequest)request);
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            StringBuilder args = new StringBuilder();
            args.append(srcWorkspaceName);
            args.append(",");
            args.append(resolver.getJCRPath(this.getPath((ItemId)srcNodeId, sessionInfo, srcWorkspaceName)));
            args.append(",");
            String destParentPath = resolver.getJCRPath(this.getPath((ItemId)destParentNodeId, sessionInfo));
            String destPath = destParentPath.endsWith("/") ? destParentPath + resolver.getJCRName(destName) : destParentPath + "/" + resolver.getJCRName(destName);
            args.append(destPath);
            args.append(",");
            args.append(Boolean.toString(removeExisting));
            List<BasicNameValuePair> nvps = Collections.singletonList(new BasicNameValuePair(PARAM_CLONE, args.toString()));
            UrlEncodedFormEntity entity = new UrlEncodedFormEntity(nvps, Charset.forName("UTF-8"));
            request.setEntity((HttpEntity)entity);
            HttpResponse response = this.executeRequest(sessionInfo, (HttpUriRequest)request);
            request.checkSuccess(response);
            if (removeExisting) {
                this.clearItemUriCache(sessionInfo);
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, request);
        }
        finally {
            if (request != null) {
                request.releaseConnection();
            }
        }
    }

    private static void addIfHeader(SessionInfo sInfo, HttpUriRequest request) {
        try {
            RepositoryServiceImpl.initMethod(request, sInfo, true);
        }
        catch (RepositoryException e) {
            log.error("Unable to retrieve lock tokens: omitted from request header.");
        }
    }

    class JsonTree
    extends AbstractTree {
        private final StringBuilder properties;
        private final List<FormBodyPart> parts;
        private final List<QValue> binaries;
        private final SessionInfo sessionInfo;

        JsonTree(SessionInfo sessionInfo, Name nodeName, Name ntName, String uniqueId, NamePathResolver resolver) {
            super(nodeName, ntName, uniqueId, resolver);
            this.properties = new StringBuilder();
            this.parts = new ArrayList<FormBodyPart>();
            this.binaries = new ArrayList<QValue>();
            this.sessionInfo = sessionInfo;
        }

        protected Tree createChild(Name name, Name primaryTypeName, String uniqueId) {
            return new JsonTree(this.sessionInfo, name, primaryTypeName, uniqueId, this.getResolver());
        }

        public void addProperty(NodeId parentId, Name propertyName, int propertyType, QValue value) throws RepositoryException {
            this.properties.append(',');
            this.properties.append(Utils.getJsonKey(this.getResolver().getJCRName(propertyName)));
            String valueStr = Utils.getJsonString(value);
            if (valueStr == null) {
                String jcrPropPath = this.createPath(parentId, propertyName);
                Utils.addPart(jcrPropPath, value, this.getResolver(), this.parts, this.binaries);
            } else {
                this.properties.append(valueStr);
            }
        }

        public void addProperty(NodeId parentId, Name propertyName, int propertyType, QValue[] values) throws RepositoryException {
            String name = this.getResolver().getJCRName(propertyName);
            this.properties.append(',');
            this.properties.append(Utils.getJsonKey(name));
            int index = 0;
            this.properties.append('[');
            for (QValue value : values) {
                String valueStr = Utils.getJsonString(value);
                if (valueStr == null) {
                    String jcrPropPath = this.createPath(parentId, propertyName);
                    Utils.addPart(jcrPropPath, value, this.getResolver(), this.parts, this.binaries);
                    continue;
                }
                String delim = index++ == 0 ? "" : ",";
                this.properties.append(delim).append('\"').append(valueStr).append('\"');
            }
            this.properties.append(']');
        }

        private String createPath(NodeId parentId, Name propertyName) throws RepositoryException {
            Path propPath = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), propertyName, true);
            return this.getResolver().getJCRPath(propPath);
        }

        String toJsonString(List<FormBodyPart> batchParts, List<QValue> bins) throws RepositoryException {
            batchParts.addAll(this.parts);
            bins.addAll(this.binaries);
            for (Tree child : this.getChildren()) {
                batchParts.addAll(((JsonTree)child).getParts());
                bins.addAll(((JsonTree)child).getBinaries());
            }
            StringBuilder json = new StringBuilder();
            this.createJsonNodeFragment(json, this, true);
            return json.toString();
        }

        private String createJsonNodeFragment(StringBuilder json, JsonTree tree, boolean start) throws RepositoryException {
            if (!start) {
                json.append(',');
                json.append(Utils.getJsonKey(this.getResolver().getJCRName(tree.getName())));
            }
            json.append('{');
            json.append(Utils.getJsonKey("jcr:primaryType"));
            json.append(JsonUtil.getJsonString((String)this.getResolver().getJCRName(tree.getPrimaryTypeName())));
            String uuid = tree.getUniqueId();
            if (uuid != null) {
                json.append(',');
                json.append(Utils.getJsonKey("jcr:uuid"));
                json.append(JsonUtil.getJsonString((String)uuid));
            }
            json.append((CharSequence)tree.getProperties());
            for (Tree child : tree.getChildren()) {
                this.createJsonNodeFragment(json, (JsonTree)child, false);
            }
            json.append('}');
            return json.toString();
        }

        private StringBuilder getProperties() {
            return this.properties;
        }

        private List<FormBodyPart> getParts() {
            return this.parts;
        }

        private List<QValue> getBinaries() {
            return this.binaries;
        }
    }

    private class BatchImpl
    implements Batch {
        private final ItemId targetId;
        private final SessionInfo sessionInfo;
        private final List<FormBodyPart> parts;
        private final List<QValue> binaries;
        private final List<String> diff;
        private final Map<Path, Path> removed = new HashMap<Path, Path>();
        private HttpPost request;
        private boolean isConsumed;
        private boolean clear;

        private BatchImpl(ItemId targetId, SessionInfo sessionInfo) {
            this.targetId = targetId;
            this.sessionInfo = sessionInfo;
            this.parts = new ArrayList<FormBodyPart>();
            this.binaries = new ArrayList<QValue>();
            this.diff = new ArrayList<String>();
        }

        private void start() throws RepositoryException {
            this.checkConsumed();
            this.request.setHeader("Referer", this.request.getURI().toASCIIString());
            RepositoryServiceImpl.addIfHeader(this.sessionInfo, (HttpUriRequest)this.request);
            StringBuilder buf = new StringBuilder();
            Iterator<String> it = this.diff.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append("\r");
            }
            Utils.addPart(RepositoryServiceImpl.PARAM_DIFF, buf.toString(), this.parts);
            MultipartEntityBuilder b = MultipartEntityBuilder.create();
            for (FormBodyPart p : this.parts) {
                b.addPart(p.getName(), p.getBody());
            }
            this.request.setEntity(b.build());
            HttpClient client = RepositoryServiceImpl.this.getClient(this.sessionInfo);
            try {
                HttpResponse response = client.execute((HttpUriRequest)this.request, RepositoryServiceImpl.this.getContext(this.sessionInfo));
                this.request.checkSuccess(response);
                if (this.clear) {
                    RepositoryServiceImpl.super.clearItemUriCache(this.sessionInfo);
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e, (HttpRequestBase)this.request);
            }
            finally {
                this.request.releaseConnection();
            }
        }

        private void dispose() {
            this.request = null;
            this.isConsumed = true;
            for (QValue bin : this.binaries) {
                if (!(bin instanceof ValueLoader.Target)) continue;
                ((ValueLoader.Target)bin).reset();
            }
        }

        private void checkConsumed() {
            if (this.isConsumed) {
                throw new IllegalStateException("Batch has already been consumed.");
            }
        }

        private boolean isEmpty() {
            return this.request == null;
        }

        private void assertMethod() throws RepositoryException {
            if (this.request == null) {
                String uri = RepositoryServiceImpl.this.getURI(this.targetId, this.sessionInfo);
                this.request = new HttpPost(uri);
                String[] locktokens = this.sessionInfo.getLockTokens();
                if (locktokens != null && locktokens.length > 0) {
                    IfHeader ifH = new IfHeader(locktokens);
                    this.request.setHeader(ifH.getHeaderName(), ifH.getHeaderValue());
                }
            }
        }

        public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
            this.assertMethod();
            NamePathResolver resolver = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo);
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), nodeName, true);
            String jcrPath = resolver.getJCRPath(p);
            StringWriter wr = new StringWriter();
            wr.write(123);
            wr.write(Utils.getJsonKey("jcr:primaryType"));
            wr.write(JsonUtil.getJsonString((String)RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRName(nodetypeName)));
            if (uuid != null) {
                wr.write(44);
                wr.write(Utils.getJsonKey("jcr:uuid"));
                wr.write(JsonUtil.getJsonString((String)uuid));
            }
            wr.write(125);
            this.appendDiff('+', jcrPath, wr.toString());
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), propertyName, true);
            this.setProperty(p, value, false);
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), propertyName, true);
            this.setProperty(p, values, false);
        }

        public void setValue(PropertyId propertyId, QValue value) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPath((ItemId)propertyId, this.sessionInfo);
            this.setProperty(p, value, true);
        }

        public void setValue(PropertyId propertyId, QValue[] values) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPath((ItemId)propertyId, this.sessionInfo);
            this.setProperty(p, values, true);
        }

        public void remove(ItemId itemId) throws RepositoryException {
            this.assertMethod();
            Path rmPath = RepositoryServiceImpl.this.getPath(itemId, this.sessionInfo);
            if (itemId.denotesNode()) {
                rmPath = this.calcRemovePath(rmPath);
            }
            String rmJcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(rmPath);
            this.appendDiff('-', rmJcrPath, null);
            if (itemId.getPath() == null) {
                this.clear = true;
            }
        }

        public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
            this.assertMethod();
            String srcPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(RepositoryServiceImpl.this.getPath((ItemId)srcNodeId, this.sessionInfo));
            StringBuilder val = new StringBuilder();
            if (beforeNodeId != null) {
                Path beforePath = RepositoryServiceImpl.this.getPath((ItemId)beforeNodeId, this.sessionInfo);
                String beforeJcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(beforePath);
                val.append(Text.getName((String)beforeJcrPath));
                val.append(RepositoryServiceImpl.ORDER_POSITION_BEFORE);
            } else {
                val.append(RepositoryServiceImpl.ORDER_POSITION_LAST);
            }
            this.appendDiff('>', srcPath, val.toString());
            if (srcNodeId.getPath() == null || beforeNodeId != null && beforeNodeId.getPath() == null) {
                this.clear = true;
            }
        }

        public void setMixins(NodeId nodeId, Name[] mixinNodeTypeNames) throws RepositoryException {
            this.assertMethod();
            QValue[] vs = new QValue[mixinNodeTypeNames.length];
            for (int i = 0; i < mixinNodeTypeNames.length; ++i) {
                vs[i] = RepositoryServiceImpl.this.getQValueFactory(this.sessionInfo).create(mixinNodeTypeNames[i]);
            }
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)nodeId, this.sessionInfo), NameConstants.JCR_MIXINTYPES, true);
            this.setProperty(p, vs, true);
        }

        public void setPrimaryType(NodeId nodeId, Name primaryNodeTypeName) throws RepositoryException {
            this.assertMethod();
            QValue v = RepositoryServiceImpl.this.getQValueFactory(this.sessionInfo).create(primaryNodeTypeName);
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)nodeId, this.sessionInfo), NameConstants.JCR_PRIMARYTYPE, true);
            this.setProperty(p, v, true);
        }

        public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
            this.assertMethod();
            String srcPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(RepositoryServiceImpl.this.getPath((ItemId)srcNodeId, this.sessionInfo));
            Path destPath = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)destParentNodeId, this.sessionInfo), destName, true);
            String destJcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(destPath);
            this.appendDiff('>', srcPath, destJcrPath);
            this.clear = true;
        }

        public void setTree(NodeId parentId, Tree contentTree) throws RepositoryException {
            this.assertMethod();
            if (!(contentTree instanceof JsonTree)) {
                throw new RepositoryException("Invalid Tree implementation : " + contentTree.getClass().getName());
            }
            Path normalizedPath = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), contentTree.getName(), true);
            String jcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(normalizedPath);
            this.appendDiff('+', jcrPath, ((JsonTree)contentTree).toJsonString(this.parts, this.binaries));
        }

        private void appendDiff(char symbol, String targetPath, String value) {
            StringBuilder bf = new StringBuilder();
            bf.append(symbol).append(targetPath).append(" : ");
            if (value != null) {
                bf.append(value);
            }
            this.diff.add(bf.toString());
        }

        private void setProperty(Path propPath, QValue value, boolean clearPrevious) throws RepositoryException {
            NamePathResolver resolver = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo);
            String jcrPropPath = resolver.getJCRPath(propPath);
            if (clearPrevious) {
                this.clearPreviousSetProperty(jcrPropPath);
            }
            String strValue = Utils.getJsonString(value);
            this.appendDiff('^', jcrPropPath, strValue);
            if (strValue == null) {
                Utils.addPart(jcrPropPath, value, resolver, this.parts, this.binaries);
            }
        }

        private void setProperty(Path propPath, QValue[] values, boolean clearPrevious) throws RepositoryException {
            NamePathResolver resolver = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo);
            String jcrPropPath = resolver.getJCRPath(propPath);
            if (clearPrevious) {
                this.clearPreviousSetProperty(jcrPropPath);
            }
            StringBuilder strVal = new StringBuilder("[");
            for (int i = 0; i < values.length; ++i) {
                String str = Utils.getJsonString(values[i]);
                if (str == null) {
                    Utils.addPart(jcrPropPath, values[i], resolver, this.parts, this.binaries);
                    continue;
                }
                String delim = i == 0 ? "" : ",";
                strVal.append(delim).append(str);
            }
            strVal.append("]");
            this.appendDiff('^', jcrPropPath, strVal.toString());
        }

        private void clearPreviousSetProperty(String jcrPropPath) {
            String key = '^' + jcrPropPath + " : ";
            Iterator<String> it = this.diff.iterator();
            while (it.hasNext()) {
                String entry = it.next();
                if (!entry.startsWith(key)) continue;
                it.remove();
                Utils.removeParts(jcrPropPath, this.parts);
                return;
            }
        }

        private Path calcRemovePath(Path removedNodePath) throws RepositoryException {
            this.removed.put(removedNodePath, removedNodePath);
            Name name = removedNodePath.getName();
            int index = removedNodePath.getNormalizedIndex();
            if (index > 1) {
                Path.Element[] elems = removedNodePath.getElements();
                PathBuilder pb = new PathBuilder();
                for (int i = 0; i <= elems.length - 2; ++i) {
                    pb.addLast(elems[i]);
                }
                Path parent = pb.getPath();
                while (index > 0) {
                    Path siblingP = RepositoryServiceImpl.this.getPathFactory().create(parent, name, --index, true);
                    if (!this.removed.containsKey(siblingP)) continue;
                    siblingP = this.removed.get(siblingP);
                    this.removed.put(removedNodePath, siblingP);
                    return siblingP;
                }
            }
            return removedNodePath;
        }
    }
}

