/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.io.IOException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.commons.webdav.ValueUtil;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.ItemInfoImpl;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertySet;

public class PropertyInfoImpl
extends ItemInfoImpl
implements PropertyInfo {
    private final PropertyId id;
    private int type;
    private boolean isMultiValued;
    private QValue[] values;

    public PropertyInfoImpl(PropertyId id, Path path, int type, boolean isMultiValued, QValue[] values) {
        super(path);
        this.id = id;
        this.type = type;
        this.isMultiValued = isMultiValued;
        this.values = values;
    }

    public PropertyInfoImpl(PropertyId id, DavPropertySet propSet, NamePathResolver resolver, ValueFactory valueFactory, QValueFactory qValueFactory) throws RepositoryException, IOException, NameException {
        super(propSet, resolver);
        this.id = id;
        String typeName = propSet.get("type", ItemResourceConstants.NAMESPACE).getValue().toString();
        this.type = PropertyType.valueFromName((String)typeName);
        DavProperty prop = propSet.get("value", ItemResourceConstants.NAMESPACE);
        if (prop != null) {
            Value[] jcrValues = ValueUtil.valuesFromXml((Object)prop.getValue(), (int)this.type, (ValueFactory)valueFactory);
            if (jcrValues == null || jcrValues.length == 0) {
                this.values = QValue.EMPTY_ARRAY;
            } else {
                QValue qv = this.type == 2 ? qValueFactory.create(jcrValues[0].getStream()) : ValueFormat.getQValue((Value)jcrValues[0], (NamePathResolver)resolver, (QValueFactory)qValueFactory);
                this.values = new QValue[]{qv};
            }
        } else {
            this.isMultiValued = true;
            prop = propSet.get("values", ItemResourceConstants.NAMESPACE);
            if (prop == null) {
                throw new RepositoryException("Item with id " + id.toString() + " doesn't represent a valid property.");
            }
            Value[] jcrValues = ValueUtil.valuesFromXml((Object)prop.getValue(), (int)this.type, (ValueFactory)valueFactory);
            this.values = new QValue[jcrValues.length];
            for (int i = 0; i < jcrValues.length; ++i) {
                this.values[i] = this.type == 2 ? qValueFactory.create(jcrValues[i].getStream()) : ValueFormat.getQValue((Value)jcrValues[i], (NamePathResolver)resolver, (QValueFactory)qValueFactory);
            }
        }
    }

    public boolean denotesNode() {
        return false;
    }

    public PropertyId getId() {
        return this.id;
    }

    public int getType() {
        return this.type;
    }

    public boolean isMultiValued() {
        return this.isMultiValued;
    }

    public QValue[] getValues() {
        return this.values;
    }
}

