/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.FormBodyPart;
import org.apache.http.entity.mime.FormBodyPartBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.InputStreamBody;
import org.apache.http.entity.mime.content.StringBody;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.commons.webdav.JcrValueType;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;

final class Utils {
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final ContentType DEFAULT_TYPE = ContentType.create((String)"text/plain", (String)"UTF-8");

    private Utils() {
    }

    static String getJsonKey(String str) {
        return JsonUtil.getJsonString((String)str) + ":";
    }

    static String getJsonString(QValue value) throws RepositoryException {
        Object str;
        switch (value.getType()) {
            case 1: {
                str = JsonUtil.getJsonString((String)value.getString());
                break;
            }
            case 3: 
            case 6: {
                str = value.getString();
                break;
            }
            case 4: {
                double d = value.getDouble();
                if (Double.isNaN(d) || Double.isInfinite(d)) {
                    str = null;
                    break;
                }
                str = value.getString();
                if (((String)str).indexOf(46) != -1) break;
                str = (String)str + ".0";
                break;
            }
            default: {
                str = null;
            }
        }
        return str;
    }

    static void addPart(String paramName, String value, List<FormBodyPart> parts) {
        parts.add(FormBodyPartBuilder.create().setName(paramName).setBody((ContentBody)new StringBody(value, DEFAULT_TYPE)).build());
    }

    static void addPart(String paramName, QValue value, NamePathResolver resolver, List<FormBodyPart> parts, List<QValue> binaries) throws RepositoryException {
        FormBodyPart part;
        FormBodyPartBuilder builder = FormBodyPartBuilder.create().setName(paramName);
        ContentType ctype = ContentType.create((String)JcrValueType.contentTypeFromType((int)value.getType()), (String)DEFAULT_CHARSET);
        switch (value.getType()) {
            case 2: {
                binaries.add(value);
                part = builder.setBody((ContentBody)new InputStreamBody(value.getStream(), ctype, paramName)).build();
                break;
            }
            case 7: {
                part = builder.setBody((ContentBody)new StringBody(resolver.getJCRName(value.getName()), ctype)).build();
                break;
            }
            case 8: {
                part = builder.setBody((ContentBody)new StringBody(resolver.getJCRPath(value.getPath()), ctype)).build();
                break;
            }
            default: {
                part = builder.setBody((ContentBody)new StringBody(value.getString(), ctype)).build();
            }
        }
        parts.add(part);
    }

    static void removeParts(String paramName, List<FormBodyPart> parts) {
        Iterator<FormBodyPart> it = parts.iterator();
        while (it.hasNext()) {
            FormBodyPart part = it.next();
            if (!part.getName().equals(paramName)) continue;
            it.remove();
            if (!(part.getBody() instanceof InputStreamBody)) continue;
            try {
                ((InputStreamBody)part.getBody()).getInputStream().close();
            }
            catch (IOException iOException) {}
        }
    }
}

