/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.HashMap;
import java.util.Map;
import org.apache.jackrabbit.spi.ItemId;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IdURICache {
    private static Logger log = LoggerFactory.getLogger(IdURICache.class);
    private final String workspaceUri;
    private Map<ItemId, String> idToUriCache = new HashMap<ItemId, String>();
    private Map<String, ItemId> uriToIdCache = new HashMap<String, ItemId>();

    IdURICache(String workspaceUri) {
        this.workspaceUri = workspaceUri;
    }

    public ItemId getItemId(String uri) {
        return this.uriToIdCache.get(IdURICache.getCleanUri(uri));
    }

    public String getUri(ItemId itemId) {
        return this.idToUriCache.get(itemId);
    }

    public boolean containsUri(String uri) {
        return this.uriToIdCache.containsKey(IdURICache.getCleanUri(uri));
    }

    public boolean containsItemId(ItemId itemId) {
        return this.idToUriCache.containsKey(itemId);
    }

    public void add(String uri, ItemId itemId) {
        if (!uri.startsWith(this.workspaceUri)) {
            throw new IllegalArgumentException("Workspace missmatch.");
        }
        String cleanUri = IdURICache.getCleanUri(uri);
        this.uriToIdCache.put(cleanUri, itemId);
        this.idToUriCache.put(itemId, cleanUri);
        log.debug("Added: ItemId = " + itemId + " URI = " + cleanUri);
    }

    public void remove(String uri) {
        String cleanUri = IdURICache.getCleanUri(uri);
        ItemId itemId = this.uriToIdCache.remove(cleanUri);
        if (itemId != null) {
            this.idToUriCache.remove(itemId);
        }
        log.debug("Removed: ItemId = " + itemId + " URI = " + cleanUri);
    }

    public void remove(ItemId itemId) {
        String uri = this.idToUriCache.remove(itemId);
        if (uri != null) {
            this.uriToIdCache.remove(uri);
        }
        log.debug("Removed: ItemId = " + itemId + " URI = " + uri);
    }

    public void clear() {
        this.idToUriCache.clear();
        this.uriToIdCache.clear();
    }

    private static String getCleanUri(String uri) {
        if (uri.endsWith("/")) {
            return uri.substring(0, uri.length() - 1);
        }
        return uri;
    }
}

