/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.InputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.methods.multipart.PartSource;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi2davex.ValueLoader;

public class BinaryPartSource
implements PartSource {
    private final QValue value;

    BinaryPartSource(QValue value) {
        this.value = value;
    }

    public long getLength() {
        try {
            return this.value.getLength();
        }
        catch (RepositoryException e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    public String getFileName() {
        return this.value.toString();
    }

    public InputStream createInputStream() throws IOException {
        try {
            return this.value.getStream();
        }
        catch (RepositoryException e) {
            throw new IOException(e.getMessage());
        }
    }

    public void dispose() {
        if (this.value instanceof ValueLoader.Target) {
            ((ValueLoader.Target)this.value).reset();
        }
    }
}

