/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Map;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.RepositoryServiceFactory;
import org.apache.jackrabbit.spi.commons.identifier.IdFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.QValueFactoryImpl;
import org.apache.jackrabbit.spi2dav.RepositoryServiceImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Spi2davRepositoryServiceFactory
implements RepositoryServiceFactory {
    public static final String PARAM_REPOSITORY_URI = "org.apache.jackrabbit.spi2dav.uri";
    public static final String PARAM_ID_FACTORY = "org.apache.jackrabbit.spi2dav.IdFactory";
    public static final String PARAM_NAME_FACTORY = "org.apache.jackrabbit.spi2dav.NameFactory";
    public static final String PARAM_PATH_FACTORY = "org.apache.jackrabbit.spi2dav.PathFactory";
    public static final String PARAM_QVALUE_FACTORY = "org.apache.jackrabbit.spi2dav.QValueFactory";
    public static final String PARAM_ITEMINFO_CACHE_SIZE = "org.apache.jackrabbit.spi2dav.ItemInfoCacheSize";
    public static final String PARAM_MAX_CONNECTIONS = "org.apache.jackrabbit.spi2dav.MaxConnections";

    public RepositoryService createRepositoryService(Map<?, ?> parameters) throws RepositoryException {
        if (parameters == null) {
            throw new RepositoryException("Parameter org.apache.jackrabbit.spi2dav.uri missing");
        }
        if (parameters.get(PARAM_REPOSITORY_URI) == null) {
            throw new RepositoryException("Parameter org.apache.jackrabbit.spi2dav.uri missing");
        }
        String uri = parameters.get(PARAM_REPOSITORY_URI).toString();
        Object param = parameters.get(PARAM_ID_FACTORY);
        IdFactory idFactory = param != null && param instanceof IdFactory ? (IdFactory)param : IdFactoryImpl.getInstance();
        param = parameters.get(PARAM_NAME_FACTORY);
        NameFactory nameFactory = param != null && param instanceof NameFactory ? (NameFactory)param : NameFactoryImpl.getInstance();
        param = parameters.get(PARAM_PATH_FACTORY);
        PathFactory pathFactory = param != null && param instanceof PathFactory ? (PathFactory)param : PathFactoryImpl.getInstance();
        param = parameters.get(PARAM_QVALUE_FACTORY);
        QValueFactory vFactory = param != null && param instanceof QValueFactory ? (QValueFactory)param : QValueFactoryImpl.getInstance();
        int itemInfoCacheSize = 5000;
        param = parameters.get(PARAM_ITEMINFO_CACHE_SIZE);
        if (param != null) {
            try {
                itemInfoCacheSize = Integer.parseInt(param.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        int maximumHttpConnections = 0;
        param = parameters.get(PARAM_MAX_CONNECTIONS);
        if (param != null) {
            try {
                maximumHttpConnections = Integer.parseInt(param.toString());
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
        }
        if (maximumHttpConnections > 0) {
            return new RepositoryServiceImpl(uri, idFactory, nameFactory, pathFactory, vFactory, itemInfoCacheSize, maximumHttpConnections);
        }
        return new RepositoryServiceImpl(uri, idFactory, nameFactory, pathFactory, vFactory, itemInfoCacheSize);
    }
}

