/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2davex;

import java.io.IOException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.jcr.Credentials;
import javax.jcr.ItemNotFoundException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.multipart.MultipartRequestEntity;
import org.apache.commons.httpclient.methods.multipart.Part;
import org.apache.commons.httpclient.methods.multipart.PartBase;
import org.apache.jackrabbit.commons.json.JsonHandler;
import org.apache.jackrabbit.commons.json.JsonParser;
import org.apache.jackrabbit.commons.json.JsonUtil;
import org.apache.jackrabbit.commons.webdav.JcrValueType;
import org.apache.jackrabbit.commons.webdav.ValueUtil;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.identifier.IdFactoryImpl;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.name.PathBuilder;
import org.apache.jackrabbit.spi.commons.name.PathFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.spi2davex.BatchReadConfig;
import org.apache.jackrabbit.spi2davex.BinaryPart;
import org.apache.jackrabbit.spi2davex.BinaryPartSource;
import org.apache.jackrabbit.spi2davex.GetMethod;
import org.apache.jackrabbit.spi2davex.ItemInfoJsonHandler;
import org.apache.jackrabbit.spi2davex.NodeInfoImpl;
import org.apache.jackrabbit.spi2davex.PostMethod;
import org.apache.jackrabbit.spi2davex.PropertyInfoImpl;
import org.apache.jackrabbit.spi2davex.QValueFactoryImpl;
import org.apache.jackrabbit.spi2davex.StringPart;
import org.apache.jackrabbit.spi2davex.ValueLoader;
import org.apache.jackrabbit.util.Text;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryServiceImpl
extends org.apache.jackrabbit.spi2dav.RepositoryServiceImpl {
    private static Logger log = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final String PARAM_DIFF = ":diff";
    private static final String PARAM_COPY = ":copy";
    private static final String PARAM_CLONE = ":clone";
    private static final char SYMBOL_ADD_NODE = '+';
    private static final char SYMBOL_MOVE = '>';
    private static final char SYMBOL_REMOVE = '-';
    private static final char SYMBOL_SET_PROPERTY = '^';
    private static final String ORDER_POSITION_LAST = "#last";
    private static final String ORDER_POSITION_BEFORE = "#before";
    private static final String DEFAULT_CHARSET = "UTF-8";
    private static final DavPropertyName JCR_TYPE = DavPropertyName.create((String)"type", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyName JCR_LENGTH = DavPropertyName.create((String)"length", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyName JCR_LENGTHS = DavPropertyName.create((String)"lengths", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyName JCR_GET_STRING = DavPropertyName.create((String)"getstring", (Namespace)ItemResourceConstants.NAMESPACE);
    private static final DavPropertyNameSet LAZY_PROPERTY_NAME_SET = new DavPropertyNameSet(){
        {
            this.add(JCR_TYPE);
            this.add(JCR_LENGTH);
            this.add(JCR_LENGTHS);
            this.add(JCR_GET_STRING);
        }
    };
    private final String jcrServerURI;
    private final String defaultWorkspaceName;
    private final BatchReadConfig batchReadConfig;
    private final Map<SessionInfo, QValueFactoryImpl> qvFactories = new HashMap<SessionInfo, QValueFactoryImpl>();

    public RepositoryServiceImpl(String jcrServerURI, BatchReadConfig batchReadConfig) throws RepositoryException {
        this(jcrServerURI, null, batchReadConfig, 5000);
    }

    public RepositoryServiceImpl(String jcrServerURI, String defaultWorkspaceName, BatchReadConfig batchReadConfig, int itemInfoCacheSize) throws RepositoryException {
        this(jcrServerURI, defaultWorkspaceName, batchReadConfig, itemInfoCacheSize, 20);
    }

    public RepositoryServiceImpl(String jcrServerURI, String defaultWorkspaceName, BatchReadConfig batchReadConfig, int itemInfoCacheSize, int maximumHttpConnections) throws RepositoryException {
        super(jcrServerURI, IdFactoryImpl.getInstance(), NameFactoryImpl.getInstance(), PathFactoryImpl.getInstance(), (QValueFactory)new QValueFactoryImpl(), itemInfoCacheSize, maximumHttpConnections);
        this.jcrServerURI = jcrServerURI.endsWith("/") ? jcrServerURI : jcrServerURI + "/";
        this.defaultWorkspaceName = defaultWorkspaceName;
        this.batchReadConfig = batchReadConfig == null ? new BatchReadConfig(){

            public int getDepth(Path path, PathResolver resolver) {
                return 0;
            }
        } : batchReadConfig;
    }

    private Path getPath(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        return this.getPath(itemId, sessionInfo, sessionInfo.getWorkspaceName());
    }

    private Path getPath(ItemId itemId, SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        if (itemId.denotesNode()) {
            String jcrPath;
            String rootUri;
            Path p = itemId.getPath();
            String uid = itemId.getUniqueID();
            if (uid == null) {
                return p;
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            String uri = super.getItemUri(itemId, sessionInfo, workspaceName);
            if (uri.startsWith(rootUri = this.getRootURI(sessionInfo))) {
                jcrPath = uri.substring(rootUri.length());
            } else {
                log.warn("ItemURI " + uri + " doesn't start with rootURI (" + rootUri + ").");
                String rootSegment = Text.escapePath((String)"/jcr:root");
                jcrPath = uri.substring(uri.indexOf(rootSegment) + rootSegment.length());
            }
            jcrPath = Text.unescape((String)jcrPath);
            return resolver.getQPath(jcrPath);
        }
        PropertyId pId = (PropertyId)itemId;
        Path parentPath = this.getPath((ItemId)pId.getParentId(), sessionInfo, workspaceName);
        return this.getPathFactory().create(parentPath, pId.getName(), true);
    }

    private String getURI(Path path, SessionInfo sessionInfo) throws RepositoryException {
        StringBuilder sb = new StringBuilder(this.getRootURI(sessionInfo));
        String jcrPath = this.getNamePathResolver(sessionInfo).getJCRPath(path);
        sb.append(Text.escapePath((String)jcrPath));
        return sb.toString();
    }

    private String getURI(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        Path p = this.getPath(itemId, sessionInfo);
        if (p == null) {
            return super.getItemUri(itemId, sessionInfo);
        }
        return this.getURI(p, sessionInfo);
    }

    private String getRootURI(SessionInfo sessionInfo) {
        StringBuilder sb = new StringBuilder(this.getWorkspaceURI(sessionInfo));
        sb.append(Text.escapePath((String)"/jcr:root"));
        return sb.toString();
    }

    private String getWorkspaceURI(SessionInfo sessionInfo) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.jcrServerURI);
        sb.append(Text.escape((String)sessionInfo.getWorkspaceName()));
        return sb.toString();
    }

    public QValueFactoryImpl getQValueFactory(SessionInfo sessionInfo) throws RepositoryException {
        QValueFactoryImpl qv;
        if (this.qvFactories.containsKey(sessionInfo)) {
            qv = this.qvFactories.get(sessionInfo);
        } else {
            ValueLoader loader = new ValueLoader(this.getClient(sessionInfo));
            qv = new QValueFactoryImpl(this.getNamePathResolver(sessionInfo), loader);
            this.qvFactories.put(sessionInfo, qv);
        }
        return qv;
    }

    @Override
    public SessionInfo obtain(Credentials credentials, String workspaceName) throws RepositoryException {
        String wspName = workspaceName == null ? this.defaultWorkspaceName : workspaceName;
        return super.obtain(credentials, wspName);
    }

    @Override
    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        String wspName = workspaceName == null ? this.defaultWorkspaceName : workspaceName;
        return super.obtain(sessionInfo, wspName);
    }

    @Override
    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        super.dispose(sessionInfo);
        this.qvFactories.remove(sessionInfo);
    }

    @Override
    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, ItemId itemId) throws ItemNotFoundException, RepositoryException {
        if (!itemId.denotesNode()) {
            PropertyInfo propertyInfo = this.getPropertyInfo(sessionInfo, (PropertyId)itemId);
            return Iterators.singleton((Object)propertyInfo);
        }
        NodeId nodeId = (NodeId)itemId;
        Path path = this.getPath(itemId, sessionInfo);
        String uri = this.getURI(path, sessionInfo);
        int depth = this.batchReadConfig.getDepth(path, (PathResolver)this.getNamePathResolver(sessionInfo));
        GetMethod method = new GetMethod(uri + "." + depth + ".json");
        try {
            int statusCode = this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            if (statusCode == 200) {
                if (method.getResponseContentLength() == 0L) {
                    throw new ItemNotFoundException("No such item " + nodeId);
                }
                NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
                NodeInfoImpl nInfo = new NodeInfoImpl(nodeId, path);
                ItemInfoJsonHandler handler = new ItemInfoJsonHandler(resolver, nInfo, this.getRootURI(sessionInfo), this.getQValueFactory(sessionInfo), this.getPathFactory(), this.getIdFactory());
                JsonParser ps = new JsonParser((JsonHandler)handler);
                ps.parse(method.getResponseBodyAsStream(), method.getResponseCharSet());
                Iterator<? extends ItemInfo> it = handler.getItemInfos();
                if (!it.hasNext()) {
                    throw new ItemNotFoundException("No such node " + uri);
                }
                Iterator<? extends ItemInfo> iterator = handler.getItemInfos();
                return iterator;
            }
            try {
                throw ExceptionConverter.generate(new DavException(statusCode, "Unable to retrieve NodeInfo for " + uri), (DavMethod)method);
            }
            catch (HttpException e) {
                throw ExceptionConverter.generate(new DavException(method.getStatusCode(), "Unable to retrieve NodeInfo for " + uri));
            }
            catch (IOException e) {
                log.error("Internal error while retrieving NodeInfo.", (Throwable)e);
                throw new RepositoryException(e.getMessage());
            }
        }
        finally {
            method.releaseConnection();
        }
    }

    @Override
    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        Path p = this.getPath((ItemId)propertyId, sessionInfo);
        String uri = this.getURI(p, sessionInfo);
        PropFindMethod method = null;
        try {
            method = new PropFindMethod(uri, LAZY_PROPERTY_NAME_SET, 0);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length != 1) {
                throw new ItemNotFoundException("Unable to retrieve the PropertyInfo. No such property " + uri);
            }
            MultiStatusResponse response = responses[0];
            DavPropertySet props = response.getProperties(200);
            int propertyType = PropertyType.valueFromName((String)props.get(JCR_TYPE).getValue().toString());
            if (propertyType == 2) {
                DavProperty lengthsProp = props.get(JCR_LENGTHS);
                if (lengthsProp != null) {
                    long[] lengths = ValueUtil.lengthsFromXml((Object)lengthsProp.getValue());
                    QValue[] qValues = new QValue[lengths.length];
                    for (int i = 0; i < lengths.length; ++i) {
                        qValues[i] = this.getQValueFactory(sessionInfo).create(lengths[i], uri, i);
                    }
                    PropertyInfoImpl i = new PropertyInfoImpl(propertyId, p, propertyType, qValues);
                    return i;
                }
                long length = Long.parseLong(props.get(JCR_LENGTH).getValue().toString());
                QValue qValue = this.getQValueFactory(sessionInfo).create(length, uri, -1);
                PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, p, propertyType, qValue);
                return propertyInfoImpl;
            }
            if (props.contains(JCR_GET_STRING)) {
                String str = props.get(JCR_GET_STRING).getValue().toString();
                QValue qValue = ValueFormat.getQValue((String)str, (int)propertyType, (NamePathResolver)this.getNamePathResolver(sessionInfo), (QValueFactory)this.getQValueFactory(sessionInfo));
                PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, p, propertyType, qValue);
                return propertyInfoImpl;
            }
            PropertyInfo propertyInfo = super.getPropertyInfo(sessionInfo, propertyId);
            return propertyInfo;
        }
        catch (IOException e) {
            log.error("Internal error while retrieving ItemInfo.", (Throwable)e);
            throw new RepositoryException(e.getMessage());
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        return new BatchImpl(itemId, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void submit(Batch batch) throws RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation.");
        }
        BatchImpl batchImpl = (BatchImpl)batch;
        try {
            if (!batchImpl.isEmpty()) {
                batchImpl.start();
            }
        }
        finally {
            batchImpl.dispose();
        }
    }

    @Override
    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        if (srcWorkspaceName.equals(sessionInfo.getWorkspaceName())) {
            super.copy(sessionInfo, srcWorkspaceName, srcNodeId, destParentNodeId, destName);
            return;
        }
        PostMethod method = null;
        try {
            method = new PostMethod(this.getWorkspaceURI(sessionInfo));
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            StringBuilder args = new StringBuilder();
            args.append(srcWorkspaceName);
            args.append(",");
            args.append(resolver.getJCRPath(this.getPath((ItemId)srcNodeId, sessionInfo, srcWorkspaceName)));
            args.append(",");
            String destParentPath = resolver.getJCRPath(this.getPath((ItemId)destParentNodeId, sessionInfo));
            String destPath = destParentPath.endsWith("/") ? destParentPath + resolver.getJCRName(destName) : destParentPath + "/" + resolver.getJCRName(destName);
            args.append(destPath);
            method.addParameter(PARAM_COPY, args.toString());
            RepositoryServiceImpl.addIfHeader(sessionInfo, (HttpMethod)method);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    @Override
    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws RepositoryException {
        PostMethod method = null;
        try {
            method = new PostMethod(this.getWorkspaceURI(sessionInfo));
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            StringBuilder args = new StringBuilder();
            args.append(srcWorkspaceName);
            args.append(",");
            args.append(resolver.getJCRPath(this.getPath((ItemId)srcNodeId, sessionInfo, srcWorkspaceName)));
            args.append(",");
            String destParentPath = resolver.getJCRPath(this.getPath((ItemId)destParentNodeId, sessionInfo));
            String destPath = destParentPath.endsWith("/") ? destParentPath + resolver.getJCRName(destName) : destParentPath + "/" + resolver.getJCRName(destName);
            args.append(destPath);
            args.append(",");
            args.append(Boolean.toString(removeExisting));
            method.addParameter(PARAM_CLONE, args.toString());
            RepositoryServiceImpl.addIfHeader(sessionInfo, (HttpMethod)method);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            if (removeExisting) {
                this.clearItemUriCache(sessionInfo);
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private static void addIfHeader(SessionInfo sInfo, HttpMethod method) {
        try {
            RepositoryServiceImpl.initMethod(method, sInfo, true);
        }
        catch (RepositoryException e) {
            log.error("Unable to retrieve lock tokens: omitted from request header.");
        }
    }

    private class BatchImpl
    implements Batch {
        private final ItemId targetId;
        private final SessionInfo sessionInfo;
        private final List<Part> parts;
        private final List<String> diff;
        private final Map<Path, Path> removed = new HashMap<Path, Path>();
        private PostMethod method;
        private boolean isConsumed;
        private boolean clear;

        private BatchImpl(ItemId targetId, SessionInfo sessionInfo) {
            this.targetId = targetId;
            this.sessionInfo = sessionInfo;
            this.parts = new ArrayList<Part>();
            this.diff = new ArrayList<String>();
        }

        private void start() throws RepositoryException {
            this.checkConsumed();
            RepositoryServiceImpl.addIfHeader(this.sessionInfo, (HttpMethod)this.method);
            StringBuilder buf = new StringBuilder();
            Iterator<String> it = this.diff.iterator();
            while (it.hasNext()) {
                buf.append(it.next());
                if (!it.hasNext()) continue;
                buf.append("\r");
            }
            if (this.parts.isEmpty()) {
                this.method.addParameter(RepositoryServiceImpl.PARAM_DIFF, buf.toString());
            } else {
                this.addPart(RepositoryServiceImpl.PARAM_DIFF, buf.toString());
                Part[] partArr = this.parts.toArray(new Part[this.parts.size()]);
                MultipartRequestEntity entity = new MultipartRequestEntity(partArr, this.method.getParams());
                this.method.setRequestEntity((RequestEntity)entity);
            }
            HttpClient client = RepositoryServiceImpl.this.getClient(this.sessionInfo);
            try {
                client.executeMethod((HttpMethod)this.method);
                this.method.checkSuccess();
                if (this.clear) {
                    RepositoryServiceImpl.super.clearItemUriCache(this.sessionInfo);
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e, (DavMethod)this.method);
            }
            finally {
                this.method.releaseConnection();
            }
        }

        private void dispose() {
            this.method = null;
            this.isConsumed = true;
            if (this.parts != null) {
                for (Part part : this.parts) {
                    if (!(part instanceof BinaryPart)) continue;
                    ((BinaryPart)part).dispose();
                }
            }
        }

        private void checkConsumed() {
            if (this.isConsumed) {
                throw new IllegalStateException("Batch has already been consumed.");
            }
        }

        private boolean isEmpty() {
            return this.method == null;
        }

        private void assertMethod() throws RepositoryException {
            if (this.method == null) {
                String uri = RepositoryServiceImpl.this.getURI(this.targetId, this.sessionInfo);
                this.method = new PostMethod(uri);
                String[] locktokens = this.sessionInfo.getLockTokens();
                if (locktokens != null && locktokens.length > 0) {
                    IfHeader ifH = new IfHeader(locktokens);
                    this.method.setRequestHeader(ifH.getHeaderName(), ifH.getHeaderValue());
                }
            }
        }

        public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
            this.assertMethod();
            NamePathResolver resolver = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo);
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), nodeName, true);
            String jcrPath = resolver.getJCRPath(p);
            StringWriter wr = new StringWriter();
            wr.write(123);
            wr.write(this.getJsonKey("jcr:primaryType"));
            wr.write(JsonUtil.getJsonString((String)RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRName(nodetypeName)));
            if (uuid != null) {
                wr.write(44);
                wr.write(this.getJsonKey("jcr:uuid"));
                wr.write(JsonUtil.getJsonString((String)uuid));
            }
            wr.write(125);
            this.appendDiff('+', jcrPath, wr.toString());
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), propertyName, true);
            this.setProperty(p, value, false);
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)parentId, this.sessionInfo), propertyName, true);
            this.setProperty(p, values, false);
        }

        public void setValue(PropertyId propertyId, QValue value) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPath((ItemId)propertyId, this.sessionInfo);
            this.setProperty(p, value, true);
        }

        public void setValue(PropertyId propertyId, QValue[] values) throws RepositoryException {
            this.assertMethod();
            Path p = RepositoryServiceImpl.this.getPath((ItemId)propertyId, this.sessionInfo);
            this.setProperty(p, values, true);
        }

        public void remove(ItemId itemId) throws RepositoryException {
            this.assertMethod();
            Path rmPath = RepositoryServiceImpl.this.getPath(itemId, this.sessionInfo);
            if (itemId.denotesNode()) {
                rmPath = this.calcRemovePath(rmPath);
            }
            String rmJcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(rmPath);
            this.appendDiff('-', rmJcrPath, null);
            if (itemId.getPath() == null) {
                this.clear = true;
            }
        }

        public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
            this.assertMethod();
            String srcPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(RepositoryServiceImpl.this.getPath((ItemId)srcNodeId, this.sessionInfo));
            StringBuilder val = new StringBuilder();
            if (beforeNodeId != null) {
                Path beforePath = RepositoryServiceImpl.this.getPath((ItemId)beforeNodeId, this.sessionInfo);
                String beforeJcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(beforePath);
                val.append(Text.getName((String)beforeJcrPath));
                val.append(RepositoryServiceImpl.ORDER_POSITION_BEFORE);
            } else {
                val.append(RepositoryServiceImpl.ORDER_POSITION_LAST);
            }
            this.appendDiff('>', srcPath, val.toString());
            if (srcNodeId.getPath() == null || beforeNodeId != null && beforeNodeId.getPath() == null) {
                this.clear = true;
            }
        }

        public void setMixins(NodeId nodeId, Name[] mixinNodeTypeNames) throws RepositoryException {
            this.assertMethod();
            QValue[] vs = new QValue[mixinNodeTypeNames.length];
            for (int i = 0; i < mixinNodeTypeNames.length; ++i) {
                vs[i] = RepositoryServiceImpl.this.getQValueFactory(this.sessionInfo).create(mixinNodeTypeNames[i]);
            }
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)nodeId, this.sessionInfo), NameConstants.JCR_MIXINTYPES, true);
            this.setProperty(p, vs, true);
        }

        public void setPrimaryType(NodeId nodeId, Name primaryNodeTypeName) throws RepositoryException {
            this.assertMethod();
            QValue v = RepositoryServiceImpl.this.getQValueFactory(this.sessionInfo).create(primaryNodeTypeName);
            Path p = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)nodeId, this.sessionInfo), NameConstants.JCR_PRIMARYTYPE, true);
            this.setProperty(p, v, true);
        }

        public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
            this.assertMethod();
            String srcPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(RepositoryServiceImpl.this.getPath((ItemId)srcNodeId, this.sessionInfo));
            Path destPath = RepositoryServiceImpl.this.getPathFactory().create(RepositoryServiceImpl.this.getPath((ItemId)destParentNodeId, this.sessionInfo), destName, true);
            String destJcrPath = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo).getJCRPath(destPath);
            this.appendDiff('>', srcPath, destJcrPath);
            this.clear = true;
        }

        private void appendDiff(char symbol, String targetPath, String value) {
            StringBuilder bf = new StringBuilder();
            bf.append(symbol).append(targetPath).append(" : ");
            if (value != null) {
                bf.append(value);
            }
            this.diff.add(bf.toString());
        }

        private void setProperty(Path propPath, QValue value, boolean clearPrevious) throws RepositoryException {
            NamePathResolver resolver = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo);
            String jcrPropPath = resolver.getJCRPath(propPath);
            if (clearPrevious) {
                this.clearPreviousSetProperty(jcrPropPath);
            }
            String strValue = this.getJsonString(value);
            this.appendDiff('^', jcrPropPath, strValue);
            if (strValue == null) {
                this.addPart(jcrPropPath, value, resolver);
            }
        }

        private void setProperty(Path propPath, QValue[] values, boolean clearPrevious) throws RepositoryException {
            NamePathResolver resolver = RepositoryServiceImpl.this.getNamePathResolver(this.sessionInfo);
            String jcrPropPath = resolver.getJCRPath(propPath);
            if (clearPrevious) {
                this.clearPreviousSetProperty(jcrPropPath);
            }
            StringBuilder strVal = new StringBuilder("[");
            for (int i = 0; i < values.length; ++i) {
                String str = this.getJsonString(values[i]);
                if (str == null) {
                    this.addPart(jcrPropPath, values[i], resolver);
                    continue;
                }
                String delim = i == 0 ? "" : ",";
                strVal.append(delim).append(str);
            }
            strVal.append("]");
            this.appendDiff('^', jcrPropPath, strVal.toString());
        }

        private void clearPreviousSetProperty(String jcrPropPath) {
            String key = '^' + jcrPropPath + " : ";
            Iterator<String> it = this.diff.iterator();
            while (it.hasNext()) {
                String entry = it.next();
                if (!entry.startsWith(key)) continue;
                it.remove();
                this.removeParts(jcrPropPath);
                return;
            }
        }

        private void addPart(String paramName, String value) {
            this.parts.add((Part)new StringPart(paramName, value, RepositoryServiceImpl.DEFAULT_CHARSET));
        }

        private void addPart(String paramName, QValue value, NamePathResolver resolver) throws RepositoryException {
            Object part;
            switch (value.getType()) {
                case 2: {
                    part = new BinaryPart(paramName, new BinaryPartSource(value), JcrValueType.contentTypeFromType((int)2), RepositoryServiceImpl.DEFAULT_CHARSET);
                    break;
                }
                case 7: {
                    part = new StringPart(paramName, resolver.getJCRName(value.getName()), RepositoryServiceImpl.DEFAULT_CHARSET);
                    break;
                }
                case 8: {
                    part = new StringPart(paramName, resolver.getJCRPath(value.getPath()), RepositoryServiceImpl.DEFAULT_CHARSET);
                    break;
                }
                default: {
                    part = new StringPart(paramName, value.getString(), RepositoryServiceImpl.DEFAULT_CHARSET);
                }
            }
            String ctype = JcrValueType.contentTypeFromType((int)value.getType());
            ((PartBase)part).setContentType(ctype);
            this.parts.add((Part)part);
        }

        private void removeParts(String paramName) {
            Iterator<Part> it = this.parts.iterator();
            while (it.hasNext()) {
                Part part = it.next();
                if (!part.getName().equals(paramName)) continue;
                it.remove();
            }
        }

        private String getJsonKey(String str) {
            return JsonUtil.getJsonString((String)str) + ":";
        }

        private String getJsonString(QValue value) throws RepositoryException {
            String str;
            switch (value.getType()) {
                case 1: {
                    str = JsonUtil.getJsonString((String)value.getString());
                    break;
                }
                case 3: 
                case 6: {
                    str = value.getString();
                    break;
                }
                case 4: {
                    str = value.getString();
                    if (str.indexOf(46) != -1) break;
                    str = str + ".0";
                    break;
                }
                default: {
                    str = null;
                }
            }
            return str;
        }

        private Path calcRemovePath(Path removedNodePath) throws RepositoryException {
            this.removed.put(removedNodePath, removedNodePath);
            Name name = removedNodePath.getName();
            int index = removedNodePath.getNormalizedIndex();
            if (index > 1) {
                Path.Element[] elems = removedNodePath.getElements();
                PathBuilder pb = new PathBuilder();
                for (int i = 0; i <= elems.length - 2; ++i) {
                    pb.addLast(elems[i]);
                }
                Path parent = pb.getPath();
                while (index > 0) {
                    Path siblingP = RepositoryServiceImpl.this.getPathFactory().create(parent, name, --index, true);
                    if (!this.removed.containsKey(siblingP)) continue;
                    siblingP = this.removed.get(siblingP);
                    this.removed.put(removedNodePath, siblingP);
                    return siblingP;
                }
            }
            return removedNodePath;
        }
    }
}

