/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.NamespaceException;
import javax.jcr.RepositoryException;
import javax.xml.namespace.QName;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EventImpl
extends org.apache.jackrabbit.spi.commons.EventImpl
implements ObservationConstants {
    private static Logger log = LoggerFactory.getLogger(EventImpl.class);
    private static final NameFactory N_FACTORY = NameFactoryImpl.getInstance();

    public EventImpl(ItemId eventId, Path eventPath, NodeId parentId, int eventType, String userId, Element eventElement, NamePathResolver resolver, QValueFactory qvFactory) throws NamespaceException, IllegalNameException {
        super(EventImpl.getSpiEventType(eventType), eventPath, eventId, parentId, EventImpl.getNameSafe(DomUtil.getChildTextTrim((Element)eventElement, (QName)N_EVENTPRIMARYNODETYPE), resolver), EventImpl.getNames(DomUtil.getChildren((Element)eventElement, (QName)N_EVENTMIXINNODETYPE), resolver), userId, DomUtil.getChildTextTrim((Element)eventElement, (QName)N_EVENTUSERDATA), Long.parseLong(DomUtil.getChildTextTrim((Element)eventElement, (QName)N_EVENTDATE)), EventImpl.getEventInfo(DomUtil.getChildElement((Node)eventElement, (QName)N_EVENTINFO), resolver, qvFactory));
    }

    private static int getSpiEventType(int jcrEventType) {
        switch (jcrEventType) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 4: {
                return 4;
            }
            case 16: {
                return 16;
            }
            case 8: {
                return 8;
            }
            case 32: {
                return 32;
            }
            case 64: {
                return 64;
            }
        }
        throw new IllegalArgumentException("Invalid event type: " + jcrEventType);
    }

    private static Map<Name, QValue> getEventInfo(Element infoElement, NamePathResolver resolver, QValueFactory qvFactory) {
        if (infoElement == null) {
            return Collections.emptyMap();
        }
        HashMap<Name, QValue> info = new HashMap<Name, QValue>();
        ElementIterator it = DomUtil.getChildren((Element)infoElement);
        while (it.hasNext()) {
            Element el = it.nextElement();
            String uri = el.getNamespaceURI();
            if (uri == null) {
                uri = Namespace.EMPTY_NAMESPACE.getURI();
            }
            String localName = el.getLocalName();
            String value = DomUtil.getTextTrim((Element)el);
            try {
                Name n = N_FACTORY.create(uri, localName);
                QValue qv = null;
                if (value != null) {
                    qv = ValueFormat.getQValue((String)value, (int)8, (NamePathResolver)resolver, (QValueFactory)qvFactory);
                }
                info.put(n, qv);
            }
            catch (RepositoryException e) {
                log.error("Internal Error: ", (Object)e.getMessage());
            }
        }
        return info;
    }

    private static Name getNameSafe(String name, NamePathResolver resolver) throws IllegalNameException, NamespaceException {
        if (name == null) {
            return null;
        }
        return resolver.getQName(name);
    }

    private static Name[] getNames(ElementIterator elements, NamePathResolver resolver) {
        List<Object> results = Collections.emptyList();
        while (elements.hasNext()) {
            String rawname = DomUtil.getText((Element)elements.nextElement());
            Name name = null;
            try {
                name = resolver.getQName(rawname);
                if (results.size() == 0) {
                    results = Collections.singletonList(name);
                    continue;
                }
                if (results.size() == 1) {
                    results = new ArrayList<Object>(results);
                    results.add(name);
                    continue;
                }
                results.add(name);
            }
            catch (Exception ex) {
                log.error("Exception converting name " + rawname, (Throwable)ex);
            }
        }
        return results.toArray(new Name[results.size()]);
    }
}

