/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Set;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LockInfoImpl
implements LockInfo {
    private static Logger log = LoggerFactory.getLogger(LockInfoImpl.class);
    private final ActiveLock activeLock;
    private final NodeId nodeId;
    private final Set<String> sessionLockTokens;

    public LockInfoImpl(ActiveLock activeLock, NodeId nodeId, Set<String> sessionLockTokens) {
        this.activeLock = activeLock;
        this.nodeId = nodeId;
        this.sessionLockTokens = sessionLockTokens;
    }

    ActiveLock getActiveLock() {
        return this.activeLock;
    }

    public String getLockToken() {
        return this.isSessionScoped() ? null : this.activeLock.getToken();
    }

    public String getOwner() {
        return this.activeLock.getOwner();
    }

    public boolean isDeep() {
        return this.activeLock.isDeep();
    }

    public boolean isSessionScoped() {
        return ItemResourceConstants.EXCLUSIVE_SESSION.equals((Object)this.activeLock.getScope());
    }

    public long getSecondsRemaining() {
        long timeout = this.activeLock.getTimeout();
        return timeout == Integer.MAX_VALUE ? Long.MAX_VALUE : timeout / 1000L;
    }

    public boolean isLockOwner() {
        String lt = this.activeLock.getToken();
        if (lt == null) {
            return false;
        }
        return this.sessionLockTokens.contains(lt);
    }

    public NodeId getNodeId() {
        return this.nodeId;
    }
}

