/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2dav.CredentialsWrapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionInfoImpl
extends org.apache.jackrabbit.spi.commons.SessionInfoImpl {
    private final CredentialsWrapper credentials;
    private final Set<String> sessionScopedTokens = new HashSet<String>();
    private final String sessionIdentifier = "urn:uuid:" + UUID.randomUUID();
    private String lastBatchId;
    private NamePathResolver resolver;

    SessionInfoImpl(CredentialsWrapper creds, String workspaceName) {
        this.credentials = creds;
        super.setWorkspacename(workspaceName);
    }

    public String getUserID() {
        return this.credentials.getUserId();
    }

    CredentialsWrapper getCredentials() {
        return this.credentials;
    }

    String getSessionIdentifier() {
        return this.sessionIdentifier;
    }

    String getLastBatchId() {
        return this.lastBatchId;
    }

    void setLastBatchId(String batchId) {
        this.lastBatchId = batchId;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    void setNamePathResolver(NamePathResolver resolver) {
        this.resolver = resolver;
    }

    Set<String> getAllLockTokens() {
        HashSet<String> s = new HashSet<String>(Arrays.asList(this.getLockTokens()));
        s.addAll(this.sessionScopedTokens);
        return Collections.unmodifiableSet(s);
    }

    void addLockToken(String token, boolean sessionScoped) {
        if (sessionScoped) {
            this.sessionScopedTokens.add(token);
        } else {
            super.addLockToken(token);
        }
    }

    void removeLockToken(String token, boolean sessionScoped) {
        if (sessionScoped) {
            this.sessionScopedTokens.remove(token);
        } else {
            super.removeLockToken(token);
        }
    }
}

