/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.List;
import javax.jcr.RangeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.commons.iterator.RangeIteratorAdapter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.QueryResultRow;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2dav.QueryResultRowImpl;
import org.apache.jackrabbit.util.ISO9075;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QueryInfoImpl
implements QueryInfo {
    private static final String COLUMNS = "Columns: ";
    private static final String SELECTORS = "Selectors: ";
    private final List<String> columnNames = new ArrayList<String>();
    private final List<String> selectorNames = new ArrayList<String>();
    private final List<QueryResultRow> results = new ArrayList<QueryResultRow>();

    public QueryInfoImpl(MultiStatus ms, IdFactory idFactory, NamePathResolver resolver, ValueFactory valueFactory, QValueFactory qValueFactory) throws RepositoryException {
        String responseDescription = ms.getResponseDescription();
        if (responseDescription == null) {
            throw new RepositoryException("Missing column infos: Unable to build QueryInfo object.");
        }
        if (responseDescription.startsWith(COLUMNS)) {
            for (String string : responseDescription.split("\n")) {
                if (string.startsWith(COLUMNS)) {
                    this.decode(string.substring(COLUMNS.length()), this.columnNames);
                    continue;
                }
                if (!string.startsWith(SELECTORS)) continue;
                this.decode(string.substring(SELECTORS.length()), this.selectorNames);
            }
        } else {
            this.decode(responseDescription, this.columnNames);
        }
        for (String string : ms.getResponses()) {
            this.results.add(new QueryResultRowImpl((MultiStatusResponse)string, this.getColumnNames(), resolver, qValueFactory, valueFactory, idFactory));
        }
    }

    private void decode(String string, List<String> list) {
        String[] parts = string.split(" ");
        for (int i = 0; i < parts.length; ++i) {
            list.add(ISO9075.decode((String)parts[i]));
        }
    }

    public RangeIterator getRows() {
        return new RangeIteratorAdapter(this.results);
    }

    public String[] getColumnNames() {
        return this.columnNames.toArray(new String[this.columnNames.size()]);
    }

    public String[] getSelectorNames() {
        return this.selectorNames.toArray(new String[this.selectorNames.size()]);
    }
}

