/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.commons.webdav.NodeTypeUtil;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi2dav.ItemInfoImpl;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeInfoImpl
extends ItemInfoImpl
implements NodeInfo {
    private static Logger log = LoggerFactory.getLogger(NodeInfoImpl.class);
    private final NodeId id;
    private final int index;
    private final Name primaryNodeTypeName;
    private final Name[] mixinNodeTypeNames;
    private final List<PropertyId> references = new ArrayList<PropertyId>();
    private final List<PropertyId> propertyIds = new ArrayList<PropertyId>();
    private List<ChildInfo> childInfos = null;

    public NodeInfoImpl(NodeId id, DavPropertySet propSet, NamePathResolver resolver) throws RepositoryException, NameException {
        super(propSet, resolver);
        this.id = id;
        DavProperty indexProp = propSet.get("index", ItemResourceConstants.NAMESPACE);
        this.index = indexProp != null && indexProp.getValue() != null ? Integer.parseInt(indexProp.getValue().toString()) : 1;
        try {
            Iterator it;
            DavProperty prop = propSet.get("primarynodetype", ItemResourceConstants.NAMESPACE);
            if (prop != null) {
                it = NodeTypeUtil.ntNamesFromXml((Object)prop.getValue()).iterator();
                if (!it.hasNext()) {
                    throw new RepositoryException("Missing primary nodetype for node " + id + ".");
                }
            } else {
                throw new RepositoryException("Missing primary nodetype for node " + id);
            }
            String jcrName = (String)it.next();
            this.primaryNodeTypeName = resolver.getQName(jcrName);
            prop = propSet.get("mixinnodetypes", ItemResourceConstants.NAMESPACE);
            if (prop != null) {
                Collection mixinNames = NodeTypeUtil.ntNamesFromXml((Object)prop.getValue());
                this.mixinNodeTypeNames = new Name[mixinNames.size()];
                int i = 0;
                for (String jcrName2 : mixinNames) {
                    this.mixinNodeTypeNames[i] = resolver.getQName(jcrName2);
                    ++i;
                }
            } else {
                this.mixinNodeTypeNames = Name.EMPTY_ARRAY;
            }
        }
        catch (NameException e) {
            throw new RepositoryException("Error while resolving nodetype names: " + e.getMessage());
        }
    }

    public boolean denotesNode() {
        return true;
    }

    public NodeId getId() {
        return this.id;
    }

    public int getIndex() {
        return this.index;
    }

    public Name getNodetype() {
        return this.primaryNodeTypeName;
    }

    public Name[] getMixins() {
        return this.mixinNodeTypeNames;
    }

    public PropertyId[] getReferences() {
        return this.references.toArray(new PropertyId[this.references.size()]);
    }

    public Iterator<PropertyId> getPropertyIds() {
        return this.propertyIds.iterator();
    }

    public Iterator<ChildInfo> getChildInfos() {
        return this.childInfos == null ? null : this.childInfos.iterator();
    }

    void addReference(PropertyId referenceId) {
        this.references.add(referenceId);
    }

    void addPropertyId(PropertyId childId) {
        this.propertyIds.add(childId);
    }

    void addChildInfo(ChildInfo childInfo) {
        if (this.childInfos == null) {
            this.childInfos = new ArrayList<ChildInfo>();
        }
        this.childInfos.add(childInfo);
    }
}

