/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2dav;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.jcr.AccessDeniedException;
import javax.jcr.Credentials;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemNotFoundException;
import javax.jcr.LoginException;
import javax.jcr.MergeException;
import javax.jcr.NamespaceException;
import javax.jcr.NoSuchWorkspaceException;
import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.InvalidNodeTypeDefinitionException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import javax.jcr.nodetype.NodeTypeExistsException;
import javax.jcr.query.InvalidQueryException;
import javax.jcr.version.VersionException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HostConfiguration;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.InputStreamRequestEntity;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.httpclient.methods.StringRequestEntity;
import org.apache.commons.httpclient.params.HttpConnectionManagerParams;
import org.apache.jackrabbit.commons.webdav.AtomFeedConstants;
import org.apache.jackrabbit.commons.webdav.EventUtil;
import org.apache.jackrabbit.commons.webdav.JcrValueType;
import org.apache.jackrabbit.commons.webdav.NodeTypeUtil;
import org.apache.jackrabbit.commons.webdav.ValueUtil;
import org.apache.jackrabbit.spi.Batch;
import org.apache.jackrabbit.spi.ChildInfo;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.ItemInfo;
import org.apache.jackrabbit.spi.ItemInfoCache;
import org.apache.jackrabbit.spi.LockInfo;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.NodeInfo;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.PropertyId;
import org.apache.jackrabbit.spi.PropertyInfo;
import org.apache.jackrabbit.spi.QItemDefinition;
import org.apache.jackrabbit.spi.QNodeDefinition;
import org.apache.jackrabbit.spi.QNodeTypeDefinition;
import org.apache.jackrabbit.spi.QPropertyDefinition;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.QValueFactory;
import org.apache.jackrabbit.spi.QueryInfo;
import org.apache.jackrabbit.spi.RepositoryService;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.ChildInfoImpl;
import org.apache.jackrabbit.spi.commons.EventBundleImpl;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi.commons.ItemInfoCacheImpl;
import org.apache.jackrabbit.spi.commons.conversion.IdentifierResolver;
import org.apache.jackrabbit.spi.commons.conversion.IllegalNameException;
import org.apache.jackrabbit.spi.commons.conversion.MalformedPathException;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.iterator.Iterators;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.namespace.AbstractNamespaceResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi.commons.nodetype.compact.CompactNodeTypeDefWriter;
import org.apache.jackrabbit.spi.commons.value.QValueValue;
import org.apache.jackrabbit.spi.commons.value.ValueFactoryQImpl;
import org.apache.jackrabbit.spi.commons.value.ValueFormat;
import org.apache.jackrabbit.spi2dav.CredentialsWrapper;
import org.apache.jackrabbit.spi2dav.DefinitionUtil;
import org.apache.jackrabbit.spi2dav.EventImpl;
import org.apache.jackrabbit.spi2dav.EventSubscriptionImpl;
import org.apache.jackrabbit.spi2dav.ExceptionConverter;
import org.apache.jackrabbit.spi2dav.ItemResourceConstants;
import org.apache.jackrabbit.spi2dav.LockInfoImpl;
import org.apache.jackrabbit.spi2dav.NodeInfoImpl;
import org.apache.jackrabbit.spi2dav.PropertyInfoImpl;
import org.apache.jackrabbit.spi2dav.QueryInfoImpl;
import org.apache.jackrabbit.spi2dav.SessionInfoImpl;
import org.apache.jackrabbit.spi2dav.URIResolverImpl;
import org.apache.jackrabbit.webdav.DavConstants;
import org.apache.jackrabbit.webdav.DavException;
import org.apache.jackrabbit.webdav.DavMethods;
import org.apache.jackrabbit.webdav.MultiStatus;
import org.apache.jackrabbit.webdav.MultiStatusResponse;
import org.apache.jackrabbit.webdav.client.methods.CheckinMethod;
import org.apache.jackrabbit.webdav.client.methods.CheckoutMethod;
import org.apache.jackrabbit.webdav.client.methods.CopyMethod;
import org.apache.jackrabbit.webdav.client.methods.DavMethod;
import org.apache.jackrabbit.webdav.client.methods.DeleteMethod;
import org.apache.jackrabbit.webdav.client.methods.LabelMethod;
import org.apache.jackrabbit.webdav.client.methods.LockMethod;
import org.apache.jackrabbit.webdav.client.methods.MergeMethod;
import org.apache.jackrabbit.webdav.client.methods.MkColMethod;
import org.apache.jackrabbit.webdav.client.methods.MkWorkspaceMethod;
import org.apache.jackrabbit.webdav.client.methods.MoveMethod;
import org.apache.jackrabbit.webdav.client.methods.OptionsMethod;
import org.apache.jackrabbit.webdav.client.methods.OrderPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PollMethod;
import org.apache.jackrabbit.webdav.client.methods.PropFindMethod;
import org.apache.jackrabbit.webdav.client.methods.PropPatchMethod;
import org.apache.jackrabbit.webdav.client.methods.PutMethod;
import org.apache.jackrabbit.webdav.client.methods.ReportMethod;
import org.apache.jackrabbit.webdav.client.methods.SearchMethod;
import org.apache.jackrabbit.webdav.client.methods.SubscribeMethod;
import org.apache.jackrabbit.webdav.client.methods.UnLockMethod;
import org.apache.jackrabbit.webdav.client.methods.UnSubscribeMethod;
import org.apache.jackrabbit.webdav.client.methods.UpdateMethod;
import org.apache.jackrabbit.webdav.header.CodedUrlHeader;
import org.apache.jackrabbit.webdav.header.IfHeader;
import org.apache.jackrabbit.webdav.lock.ActiveLock;
import org.apache.jackrabbit.webdav.lock.LockDiscovery;
import org.apache.jackrabbit.webdav.lock.Scope;
import org.apache.jackrabbit.webdav.lock.Type;
import org.apache.jackrabbit.webdav.observation.DefaultEventType;
import org.apache.jackrabbit.webdav.observation.EventDiscovery;
import org.apache.jackrabbit.webdav.observation.EventType;
import org.apache.jackrabbit.webdav.observation.ObservationConstants;
import org.apache.jackrabbit.webdav.observation.SubscriptionInfo;
import org.apache.jackrabbit.webdav.property.DavProperty;
import org.apache.jackrabbit.webdav.property.DavPropertyName;
import org.apache.jackrabbit.webdav.property.DavPropertyNameSet;
import org.apache.jackrabbit.webdav.property.DavPropertySet;
import org.apache.jackrabbit.webdav.property.DefaultDavProperty;
import org.apache.jackrabbit.webdav.property.HrefProperty;
import org.apache.jackrabbit.webdav.search.SearchInfo;
import org.apache.jackrabbit.webdav.security.CurrentUserPrivilegeSetProperty;
import org.apache.jackrabbit.webdav.security.Privilege;
import org.apache.jackrabbit.webdav.security.SecurityConstants;
import org.apache.jackrabbit.webdav.transaction.TransactionConstants;
import org.apache.jackrabbit.webdav.transaction.TransactionInfo;
import org.apache.jackrabbit.webdav.version.DeltaVConstants;
import org.apache.jackrabbit.webdav.version.MergeInfo;
import org.apache.jackrabbit.webdav.version.UpdateInfo;
import org.apache.jackrabbit.webdav.version.VersionControlledResource;
import org.apache.jackrabbit.webdav.version.report.ReportInfo;
import org.apache.jackrabbit.webdav.xml.DomUtil;
import org.apache.jackrabbit.webdav.xml.ElementIterator;
import org.apache.jackrabbit.webdav.xml.Namespace;
import org.apache.jackrabbit.webdav.xml.XmlSerializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class RepositoryServiceImpl
implements RepositoryService,
DavConstants {
    private static Logger log = LoggerFactory.getLogger(RepositoryServiceImpl.class);
    private static final SubscriptionInfo S_INFO = new SubscriptionInfo(DefaultEventType.create((String[])EventUtil.EVENT_ALL, (Namespace)ItemResourceConstants.NAMESPACE), true, Integer.MAX_VALUE);
    private static final String CLIENT_KEY = "repoCreation";
    public static final int MAX_CONNECTIONS_DEFAULT = 20;
    private final IdFactory idFactory;
    private final NameFactory nameFactory;
    private final PathFactory pathFactory;
    private final QValueFactory qValueFactory;
    private final ValueFactory valueFactory;
    private final int itemInfoCacheSize;
    private final NamespaceCache nsCache;
    private final URIResolverImpl uriResolver;
    private final HostConfiguration hostConfig;
    private final ConcurrentMap<Object, HttpClient> clients;
    private final HttpConnectionManager connectionManager;
    private final Map<Name, QNodeTypeDefinition> nodeTypeDefinitions = new HashMap<Name, QNodeTypeDefinition>();
    private final Map<String, QValue[]> descriptors = new HashMap<String, QValue[]>();
    private boolean remoteServerProvidesNodeTypes = false;
    private boolean remoteServerProvidesNoLocalFlag = false;
    private Set<String> remoteDavComplianceClasses = null;
    private static final Set<String> readMethods;
    private static final Namespace SV_NAMESPACE;
    private static final String NODE_ELEMENT = "node";
    private static final String PROPERTY_ELEMENT = "property";
    private static final String VALUE_ELEMENT = "value";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String TYPE_ATTRIBUTE = "type";

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory) throws RepositoryException {
        this(uri, idFactory, nameFactory, pathFactory, qValueFactory, 5000);
    }

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory, int itemInfoCacheSize) throws RepositoryException {
        this(uri, idFactory, nameFactory, pathFactory, qValueFactory, itemInfoCacheSize, 20);
    }

    public RepositoryServiceImpl(String uri, IdFactory idFactory, NameFactory nameFactory, PathFactory pathFactory, QValueFactory qValueFactory, int itemInfoCacheSize, int maximumHttpConnections) throws RepositoryException {
        if (uri == null || "".equals(uri)) {
            throw new RepositoryException("Invalid repository uri '" + uri + "'.");
        }
        if (idFactory == null || qValueFactory == null) {
            throw new RepositoryException("IdFactory and QValueFactory may not be null.");
        }
        this.idFactory = idFactory;
        this.nameFactory = nameFactory;
        this.pathFactory = pathFactory;
        this.qValueFactory = qValueFactory;
        this.itemInfoCacheSize = itemInfoCacheSize;
        try {
            URI repositoryUri = RepositoryServiceImpl.computeRepositoryUri(uri);
            this.hostConfig = new HostConfiguration();
            this.hostConfig.setHost(repositoryUri);
            this.nsCache = new NamespaceCache();
            this.uriResolver = new URIResolverImpl(repositoryUri, this, DomUtil.createDocument());
            NamePathResolverImpl resolver = new NamePathResolverImpl((NamespaceResolver)this.nsCache);
            this.valueFactory = new ValueFactoryQImpl(qValueFactory, (NamePathResolver)resolver);
        }
        catch (URIException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        this.connectionManager = new MultiThreadedHttpConnectionManager();
        if (maximumHttpConnections > 0) {
            HttpConnectionManagerParams connectionParams = this.connectionManager.getParams();
            connectionParams.setDefaultMaxConnectionsPerHost(maximumHttpConnections);
            connectionParams.setMaxTotalConnections(maximumHttpConnections);
        }
        int concurrencyLevel = 20;
        int initialCapacity = 20;
        if (maximumHttpConnections > 0) {
            concurrencyLevel = maximumHttpConnections;
            initialCapacity = maximumHttpConnections;
        }
        this.clients = new ConcurrentHashMap<Object, HttpClient>(concurrencyLevel, 0.75f, initialCapacity);
    }

    private static void checkSessionInfo(SessionInfo sessionInfo) throws RepositoryException {
        if (!(sessionInfo instanceof SessionInfoImpl)) {
            throw new RepositoryException("Unknown SessionInfo implementation.");
        }
    }

    private static String resolve(String baseUri, String relUri) throws RepositoryException {
        try {
            java.net.URI base = new java.net.URI(baseUri);
            java.net.URI rel = new java.net.URI(relUri);
            return base.resolve(rel).toString();
        }
        catch (URISyntaxException ex) {
            throw new RepositoryException((Throwable)ex);
        }
    }

    private static void checkSubscription(Subscription subscription) throws RepositoryException {
        if (!(subscription instanceof EventSubscriptionImpl)) {
            throw new RepositoryException("Unknown Subscription implementation.");
        }
    }

    private static boolean isUnLockMethod(DavMethod method) {
        int code = DavMethods.getMethodCode((String)method.getName());
        return 13 == code;
    }

    protected static void initMethod(HttpMethod method, SessionInfo sessionInfo, boolean addIfHeader) throws RepositoryException {
        if (addIfHeader) {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            Set<String> allLockTokens = ((SessionInfoImpl)sessionInfo).getAllLockTokens();
            if (!allLockTokens.isEmpty()) {
                String[] locktokens = allLockTokens.toArray(new String[allLockTokens.size()]);
                IfHeader ifH = new IfHeader(locktokens);
                method.setRequestHeader(ifH.getHeaderName(), ifH.getHeaderValue());
            }
        }
        RepositoryServiceImpl.initMethod(method, sessionInfo);
    }

    protected static void initMethod(HttpMethod method, SessionInfo sessionInfo) throws RepositoryException {
        boolean needsSessionId;
        boolean isReadAccess = readMethods.contains(method.getName());
        boolean bl = needsSessionId = !isReadAccess || "POLL".equals(method.getName());
        if (sessionInfo instanceof SessionInfoImpl && needsSessionId) {
            StringBuilder linkHeaderField = new StringBuilder();
            String sessionIdentifier = ((SessionInfoImpl)sessionInfo).getSessionIdentifier();
            linkHeaderField.append("<" + sessionIdentifier + ">; rel=\"" + "http://www.day.com/jcr/webdav/1.0/session-id" + "\"");
            String userdata = ((SessionInfoImpl)sessionInfo).getUserData();
            if (userdata != null && !isReadAccess) {
                String escaped = org.apache.jackrabbit.util.Text.escape((String)userdata);
                linkHeaderField.append(", <data:," + escaped + ">; rel=\"" + "http://www.day.com/jcr/webdav/1.0/user-data" + "\"");
            }
            method.addRequestHeader("Link", linkHeaderField.toString());
        }
    }

    private static void initMethod(DavMethod method, BatchImpl batchImpl, boolean addIfHeader) throws RepositoryException {
        RepositoryServiceImpl.initMethod((HttpMethod)method, batchImpl.sessionInfo, addIfHeader);
        CodedUrlHeader ch = new CodedUrlHeader("TransactionId", batchImpl.batchId);
        method.setRequestHeader(ch.getHeaderName(), ch.getHeaderValue());
    }

    private static boolean isSameResource(String requestURI, MultiStatusResponse response) {
        try {
            String href = RepositoryServiceImpl.resolve(requestURI, response.getHref());
            if (href.endsWith("/") && !requestURI.endsWith("/")) {
                href = href.substring(0, href.length() - 1);
            }
            return requestURI.equals(href);
        }
        catch (RepositoryException e) {
            return false;
        }
    }

    private String saveGetIdString(ItemId id, SessionInfo sessionInfo) {
        NamePathResolver resolver = null;
        try {
            resolver = this.getNamePathResolver(sessionInfo);
        }
        catch (RepositoryException e) {
            // empty catch block
        }
        return this.saveGetIdString(id, resolver);
    }

    private String saveGetIdString(ItemId id, NamePathResolver resolver) {
        Path p;
        StringBuffer bf = new StringBuffer();
        String uid = id.getUniqueID();
        if (uid != null) {
            bf.append(uid);
        }
        if ((p = id.getPath()) != null) {
            if (resolver == null) {
                bf.append(p.toString());
            } else {
                try {
                    bf.append(resolver.getJCRPath(p));
                }
                catch (NamespaceException e) {
                    bf.append(p.toString());
                }
            }
        }
        return bf.toString();
    }

    protected NamePathResolver getNamePathResolver(SessionInfo sessionInfo) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return this.getNamePathResolver((SessionInfoImpl)sessionInfo);
    }

    private NamePathResolver getNamePathResolver(SessionInfoImpl sessionInfo) {
        NamePathResolver resolver = sessionInfo.getNamePathResolver();
        if (resolver == null) {
            resolver = new NamePathResolverImpl((SessionInfo)sessionInfo);
            sessionInfo.setNamePathResolver(resolver);
        }
        return resolver;
    }

    private static Object getClientKey(SessionInfo sessionInfo) {
        return sessionInfo == null ? CLIENT_KEY : sessionInfo;
    }

    protected HttpClient getClient(SessionInfo sessionInfo) throws RepositoryException {
        Object clientKey = RepositoryServiceImpl.getClientKey(sessionInfo);
        HttpClient client = (HttpClient)this.clients.get(clientKey);
        if (client == null) {
            client = new HttpClient(this.connectionManager);
            client.setHostConfiguration(this.hostConfig);
            org.apache.commons.httpclient.Credentials creds = null;
            if (sessionInfo != null) {
                RepositoryServiceImpl.checkSessionInfo(sessionInfo);
                creds = ((SessionInfoImpl)sessionInfo).getCredentials().getCredentials();
                client.getParams().setAuthenticationPreemptive(true);
            }
            client.getState().setCredentials(AuthScope.ANY, creds);
            this.clients.put(clientKey, client);
            log.debug("Created Client " + client + " for SessionInfo " + sessionInfo);
        }
        return client;
    }

    private void removeClient(SessionInfo sessionInfo) {
        HttpClient cl = (HttpClient)this.clients.remove(RepositoryServiceImpl.getClientKey(sessionInfo));
        log.debug("Removed Client " + cl + " for SessionInfo " + sessionInfo);
    }

    protected String getItemUri(ItemId itemId, SessionInfo sessionInfo) throws RepositoryException {
        return this.getItemUri(itemId, sessionInfo, sessionInfo.getWorkspaceName());
    }

    protected String getItemUri(ItemId itemId, SessionInfo sessionInfo, String workspaceName) throws RepositoryException {
        return this.uriResolver.getItemUri(itemId, workspaceName, sessionInfo);
    }

    protected void clearItemUriCache(SessionInfo sessionInfo) {
        this.uriResolver.clearCacheEntries(sessionInfo);
    }

    private String getItemUri(NodeId parentId, Name childName, SessionInfo sessionInfo) throws RepositoryException {
        String parentUri = this.uriResolver.getItemUri((ItemId)parentId, sessionInfo.getWorkspaceName(), sessionInfo);
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        if (!parentUri.endsWith("/")) {
            parentUri = parentUri + "/";
        }
        return parentUri + org.apache.jackrabbit.util.Text.escape((String)resolver.getJCRName(childName));
    }

    private NodeId getParentId(String baseUri, DavPropertySet propSet, SessionInfo sessionInfo) throws RepositoryException {
        HrefProperty parentProp;
        String parentHref;
        NodeId parentId = null;
        DavProperty p = propSet.get("parent", ItemResourceConstants.NAMESPACE);
        if (p != null && (parentHref = (String)(parentProp = new HrefProperty(p)).getHrefs().get(0)) != null && parentHref.length() > 0) {
            parentId = this.uriResolver.getNodeId(RepositoryServiceImpl.resolve(baseUri, parentHref), sessionInfo);
        }
        return parentId;
    }

    String getUniqueID(DavPropertySet propSet) {
        DavProperty prop = propSet.get("uuid", ItemResourceConstants.NAMESPACE);
        if (prop != null) {
            return prop.getValue().toString();
        }
        return null;
    }

    Name getQName(DavPropertySet propSet, NamePathResolver resolver) throws RepositoryException {
        DavProperty nameProp = propSet.get(NAME_ATTRIBUTE, ItemResourceConstants.NAMESPACE);
        if (nameProp != null && nameProp.getValue() != null) {
            String jcrName = nameProp.getValue().toString();
            try {
                return resolver.getQName(jcrName);
            }
            catch (NameException e) {
                throw new RepositoryException((Throwable)e);
            }
        }
        return NameConstants.ROOT;
    }

    int getIndex(DavPropertySet propSet) {
        int index = 0;
        DavProperty indexProp = propSet.get("index", ItemResourceConstants.NAMESPACE);
        if (indexProp != null && indexProp.getValue() != null) {
            index = Integer.parseInt(indexProp.getValue().toString());
        }
        return index;
    }

    private void execute(DavMethod method, SessionInfo sessionInfo) throws RepositoryException {
        try {
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, !RepositoryServiceImpl.isUnLockMethod(method));
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, method);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public IdFactory getIdFactory() {
        return this.idFactory;
    }

    public NameFactory getNameFactory() {
        return this.nameFactory;
    }

    public PathFactory getPathFactory() {
        return this.pathFactory;
    }

    public QValueFactory getQValueFactory() {
        return this.qValueFactory;
    }

    public ItemInfoCache getItemInfoCache(SessionInfo sessionInfo) throws RepositoryException {
        return new ItemInfoCacheImpl(this.itemInfoCacheSize);
    }

    public Map<String, QValue[]> getRepositoryDescriptors() throws RepositoryException {
        if (this.descriptors.isEmpty()) {
            ReportInfo info = new ReportInfo("repositorydescriptors", ItemResourceConstants.NAMESPACE);
            ReportMethod method = null;
            try {
                method = new ReportMethod(this.uriResolver.getRepositoryUri(), info);
                int sc = this.getClient(null).executeMethod((HttpMethod)method);
                if (sc == 401 || sc == 407) {
                    log.warn("Authentication required to access repository descriptors");
                    Map<String, QValue[]> map = this.descriptors;
                    return map;
                }
                method.checkSuccess();
                Document doc = method.getResponseBodyAsDocument();
                if (doc != null) {
                    Element rootElement = doc.getDocumentElement();
                    ElementIterator nsElems = DomUtil.getChildren((Element)rootElement, (String)"descriptor", (Namespace)ItemResourceConstants.NAMESPACE);
                    while (nsElems.hasNext()) {
                        Element elem = nsElems.nextElement();
                        String key = DomUtil.getChildText((Element)elem, (String)"descriptorkey", (Namespace)ItemResourceConstants.NAMESPACE);
                        ElementIterator it = DomUtil.getChildren((Element)elem, (String)"descriptorvalue", (Namespace)ItemResourceConstants.NAMESPACE);
                        ArrayList<QValue> vs = new ArrayList<QValue>();
                        while (it.hasNext()) {
                            Element dv = it.nextElement();
                            String descriptor = DomUtil.getText((Element)dv);
                            if (key != null && descriptor != null) {
                                String typeStr = DomUtil.getAttribute((Element)dv, (String)TYPE_ATTRIBUTE, null);
                                int type = typeStr == null ? 1 : PropertyType.valueFromName((String)typeStr);
                                vs.add(this.getQValueFactory().create(descriptor, type));
                                continue;
                            }
                            log.error("Invalid descriptor key / value pair: " + key + " -> " + descriptor);
                        }
                        this.descriptors.put(key, vs.toArray(new QValue[vs.size()]));
                    }
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        return this.descriptors;
    }

    public SessionInfo obtain(Credentials credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        CredentialsWrapper dc = new CredentialsWrapper(credentials);
        return this.obtain(dc, workspaceName);
    }

    public SessionInfo obtain(SessionInfo sessionInfo, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return this.obtain(((SessionInfoImpl)sessionInfo).getCredentials(), workspaceName);
    }

    public SessionInfo impersonate(SessionInfo sessionInfo, Credentials credentials) throws LoginException, RepositoryException {
        throw new UnsupportedOperationException("Not implemented yet.");
    }

    private SessionInfo obtain(CredentialsWrapper credentials, String workspaceName) throws LoginException, NoSuchWorkspaceException, RepositoryException {
        SessionInfoImpl sessionInfo;
        block17: {
            PropFindMethod method = null;
            sessionInfo = new SessionInfoImpl(credentials, workspaceName);
            try {
                DavPropertyNameSet nameSet = new DavPropertyNameSet();
                nameSet.add(DeltaVConstants.WORKSPACE);
                nameSet.add("workspaceName", ItemResourceConstants.NAMESPACE);
                method = new PropFindMethod(this.uriResolver.getWorkspaceUri(workspaceName), nameSet, 0);
                this.getClient((SessionInfo)sessionInfo).executeMethod((HttpMethod)method);
                MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
                if (responses.length != 1) {
                    throw new LoginException("Login failed: Unknown workspace '" + workspaceName + "'.");
                }
                DavPropertySet props = responses[0].getProperties(200);
                DavProperty prop = props.get("workspaceName", ItemResourceConstants.NAMESPACE);
                if (prop != null) {
                    String wspName = prop.getValue().toString();
                    if (workspaceName == null) {
                        sessionInfo = new SessionInfoImpl(credentials, wspName);
                    } else if (!wspName.equals(workspaceName)) {
                        throw new LoginException("Login failed: Invalid workspace name '" + workspaceName + "'.");
                    }
                    break block17;
                }
                if (props.contains(DeltaVConstants.WORKSPACE)) {
                    String wspHref = (String)new HrefProperty(props.get(DeltaVConstants.WORKSPACE)).getHrefs().get(0);
                    String wspName = org.apache.jackrabbit.util.Text.unescape((String)org.apache.jackrabbit.util.Text.getName((String)wspHref, (boolean)true));
                    if (!wspName.equals(workspaceName)) {
                        throw new LoginException("Login failed: Invalid workspace name " + workspaceName);
                    }
                    break block17;
                }
                throw new LoginException("Login failed: Unknown workspace '" + workspaceName + "'.");
            }
            catch (IOException e) {
                throw new RepositoryException(e.getMessage());
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }
        if (this.nsCache.prefixToURI.isEmpty()) {
            try {
                this.getRegisteredNamespaces((SessionInfo)sessionInfo);
            }
            catch (RepositoryException e) {
                // empty catch block
            }
        }
        return sessionInfo;
    }

    public void dispose(SessionInfo sessionInfo) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        this.removeClient(sessionInfo);
    }

    public String[] getWorkspaceNames(SessionInfo sessionInfo) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DeltaVConstants.WORKSPACE);
        PropFindMethod method = null;
        try {
            method = new PropFindMethod(this.uriResolver.getRepositoryUri(), nameSet, 1);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            HashSet<String> wspNames = new HashSet<String>();
            for (MultiStatusResponse response : responses) {
                DavPropertySet props = response.getProperties(200);
                if (!props.contains(DeltaVConstants.WORKSPACE)) continue;
                HrefProperty hp = new HrefProperty(props.get(DeltaVConstants.WORKSPACE));
                String wspHref = (String)hp.getHrefs().get(0);
                String name = org.apache.jackrabbit.util.Text.unescape((String)org.apache.jackrabbit.util.Text.getName((String)wspHref, (boolean)true));
                wspNames.add(name);
            }
            String[] stringArray = wspNames.toArray(new String[wspNames.size()]);
            return stringArray;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public boolean isGranted(SessionInfo sessionInfo, ItemId itemId, String[] actions) throws RepositoryException {
        ReportMethod method = null;
        try {
            String uri = RepositoryServiceImpl.obtainAbsolutePathFromUri(this.getItemUri(itemId, sessionInfo));
            ReportInfo reportInfo = new ReportInfo("privileges", ItemResourceConstants.NAMESPACE);
            reportInfo.setContentElement(DomUtil.hrefToXml((String)uri, (Document)DomUtil.createDocument()));
            method = new ReportMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()), reportInfo);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve permissions for item " + this.saveGetIdString(itemId, sessionInfo));
            }
            DavProperty p = responses[0].getProperties(200).get(SecurityConstants.CURRENT_USER_PRIVILEGE_SET);
            if (p == null) {
                boolean bl = false;
                return bl;
            }
            HashSet<Privilege> requiredPrivileges = new HashSet<Privilege>();
            for (String action : actions) {
                requiredPrivileges.add(Privilege.getPrivilege((String)action, (Namespace)ItemResourceConstants.NAMESPACE));
            }
            CurrentUserPrivilegeSetProperty privSet = new CurrentUserPrivilegeSetProperty(p);
            Collection privileges = privSet.getValue();
            boolean bl = privileges.containsAll(requiredPrivileges);
            return bl;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public QNodeDefinition getNodeDefinition(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        return (QNodeDefinition)this.getItemDefinition(sessionInfo, (ItemId)nodeId);
    }

    public QPropertyDefinition getPropertyDefinition(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        return (QPropertyDefinition)this.getItemDefinition(sessionInfo, (ItemId)propertyId);
    }

    private QItemDefinition getItemDefinition(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("definition", ItemResourceConstants.NAMESPACE);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        PropFindMethod method = null;
        try {
            Object value;
            String uri = this.getItemUri(itemId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 0);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the item definition for " + this.saveGetIdString(itemId, sessionInfo));
            }
            if (responses.length > 1) {
                throw new RepositoryException("Internal error: ambigous item definition found '" + this.saveGetIdString(itemId, sessionInfo) + "'.");
            }
            DavPropertySet propertySet = responses[0].getProperties(200);
            DavProperty rType = propertySet.get(DavPropertyName.RESOURCETYPE);
            if (rType.getValue() == null && itemId.denotesNode()) {
                throw new RepositoryException("Internal error: requested node definition and got property definition.");
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            Object definition = null;
            DavProperty prop = propertySet.get("definition", ItemResourceConstants.NAMESPACE);
            if (prop != null && (value = prop.getValue()) != null && value instanceof Element) {
                Element idfElem = (Element)value;
                definition = itemId.denotesNode() ? DefinitionUtil.createQNodeDefinition(null, idfElem, resolver) : DefinitionUtil.createQPropertyDefinition(null, idfElem, resolver, this.getQValueFactory());
            }
            if (definition == null) {
                throw new RepositoryException("Unable to retrieve definition for item with id '" + this.saveGetIdString(itemId, resolver) + "'.");
            }
            QNodeDefinition qNodeDefinition = definition;
            return qNodeDefinition;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public NodeInfo getNodeInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add("index", ItemResourceConstants.NAMESPACE);
        nameSet.add("parent", ItemResourceConstants.NAMESPACE);
        nameSet.add(NAME_ATTRIBUTE, ItemResourceConstants.NAMESPACE);
        nameSet.add("primarynodetype", ItemResourceConstants.NAMESPACE);
        nameSet.add("mixinnodetypes", ItemResourceConstants.NAMESPACE);
        nameSet.add("references", ItemResourceConstants.NAMESPACE);
        nameSet.add("uuid", ItemResourceConstants.NAMESPACE);
        nameSet.add("path", ItemResourceConstants.NAMESPACE);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        PropFindMethod method = null;
        try {
            String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 1);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            MultiStatusResponse nodeResponse = null;
            ArrayList<MultiStatusResponse> childResponses = new ArrayList<MultiStatusResponse>();
            for (MultiStatusResponse response : responses) {
                if (RepositoryServiceImpl.isSameResource(uri, response)) {
                    nodeResponse = response;
                    continue;
                }
                childResponses.add(response);
            }
            if (nodeResponse == null) {
                throw new ItemNotFoundException("Unable to retrieve the node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            DavPropertySet propSet = nodeResponse.getProperties(200);
            Object type = propSet.get(DavPropertyName.RESOURCETYPE).getValue();
            if (type == null) {
                throw new ItemNotFoundException("No node for id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            NodeId parentId = this.getParentId(uri, propSet, sessionInfo);
            NodeInfoImpl nInfo = this.buildNodeInfo(uri, nodeResponse, parentId, propSet, sessionInfo, resolver);
            for (MultiStatusResponse resp : childResponses) {
                DavPropertySet childProps = resp.getProperties(200);
                if (childProps.contains(DavPropertyName.RESOURCETYPE) && childProps.get(DavPropertyName.RESOURCETYPE).getValue() != null) {
                    nInfo.addChildInfo(this.buildChildInfo(childProps, sessionInfo));
                    continue;
                }
                PropertyId childId = this.uriResolver.buildPropertyId(nInfo.getId(), resp, sessionInfo.getWorkspaceName(), this.getNamePathResolver(sessionInfo));
                nInfo.addPropertyId(childId);
            }
            NodeInfoImpl nodeInfoImpl = nInfo;
            return nodeInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public Iterator<? extends ItemInfo> getItemInfos(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        if (itemId.denotesNode()) {
            ArrayList<Object> l = new ArrayList<Object>();
            NodeInfo nInfo = this.getNodeInfo(sessionInfo, (NodeId)itemId);
            l.add(nInfo);
            l.addAll(this.buildPropertyInfos(nInfo));
            return l.iterator();
        }
        PropertyInfo pInfo = this.getPropertyInfo(sessionInfo, (PropertyId)itemId);
        return Iterators.singleton((Object)pInfo);
    }

    private NodeInfoImpl buildNodeInfo(String baseUri, MultiStatusResponse nodeResponse, NodeId parentId, DavPropertySet propSet, SessionInfo sessionInfo, NamePathResolver resolver) throws NameException, RepositoryException {
        NodeId id = this.uriResolver.buildNodeId(parentId, baseUri, nodeResponse, sessionInfo.getWorkspaceName(), this.getNamePathResolver(sessionInfo));
        NodeInfoImpl nInfo = new NodeInfoImpl(id, propSet, resolver);
        DavProperty p = propSet.get("references", ItemResourceConstants.NAMESPACE);
        if (p != null) {
            HrefProperty refProp = new HrefProperty(p);
            for (String propertyHref : refProp.getHrefs()) {
                PropertyId propertyId = this.uriResolver.getPropertyId(propertyHref, sessionInfo);
                nInfo.addReference(propertyId);
            }
        }
        return nInfo;
    }

    private List<PropertyInfo> buildPropertyInfos(NodeInfo nInfo) throws RepositoryException {
        QValue[] vs;
        ArrayList<PropertyInfo> l = new ArrayList<PropertyInfo>(3);
        NodeId nid = nInfo.getId();
        Path nPath = nInfo.getPath();
        if (nid.getPath() == null) {
            PropertyId id = this.getIdFactory().createPropertyId(nid, NameConstants.JCR_UUID);
            vs = new QValue[]{this.getQValueFactory().create(nid.getUniqueID(), 1)};
            Path p = this.getPathFactory().create(nPath, NameConstants.JCR_UUID, true);
            PropertyInfoImpl pi = new PropertyInfoImpl(id, p, 1, false, vs);
            l.add(pi);
        }
        Name pName = NameConstants.JCR_PRIMARYTYPE;
        vs = new QValue[]{this.getQValueFactory().create(nInfo.getNodetype())};
        PropertyInfoImpl pi = new PropertyInfoImpl(this.getIdFactory().createPropertyId(nid, pName), this.getPathFactory().create(nPath, pName, true), 7, false, vs);
        l.add(pi);
        Name[] mixins = nInfo.getMixins();
        if (mixins.length > 0) {
            pName = NameConstants.JCR_MIXINTYPES;
            vs = new QValue[mixins.length];
            for (int i = 0; i < mixins.length; ++i) {
                vs[i] = this.getQValueFactory().create(mixins[i]);
            }
            pi = new PropertyInfoImpl(this.getIdFactory().createPropertyId(nid, pName), this.getPathFactory().create(nPath, pName, true), 7, true, vs);
            l.add(pi);
        }
        return l;
    }

    public Iterator<ChildInfo> getChildInfos(SessionInfo sessionInfo, NodeId parentId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(NAME_ATTRIBUTE, ItemResourceConstants.NAMESPACE);
        nameSet.add("index", ItemResourceConstants.NAMESPACE);
        nameSet.add("parent", ItemResourceConstants.NAMESPACE);
        nameSet.add("uuid", ItemResourceConstants.NAMESPACE);
        nameSet.add(DavPropertyName.RESOURCETYPE);
        PropFindMethod method = null;
        try {
            String uri = this.getItemUri((ItemId)parentId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 1);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)parentId, sessionInfo));
            }
            if (responses.length == 1) {
                List childEntries = Collections.emptyList();
                Iterator<ChildInfo> iterator = childEntries.iterator();
                return iterator;
            }
            ArrayList<ChildInfo> childEntries = new ArrayList<ChildInfo>();
            for (MultiStatusResponse resp : responses) {
                DavPropertySet childProps;
                if (RepositoryServiceImpl.isSameResource(uri, resp) || !(childProps = resp.getProperties(200)).contains(DavPropertyName.RESOURCETYPE) || childProps.get(DavPropertyName.RESOURCETYPE).getValue() == null) continue;
                childEntries.add(this.buildChildInfo(childProps, sessionInfo));
            }
            Iterator<ChildInfo> iterator = childEntries.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private ChildInfo buildChildInfo(DavPropertySet properties, SessionInfo sessionInfo) throws RepositoryException {
        Name qName = this.getQName(properties, this.getNamePathResolver(sessionInfo));
        int index = this.getIndex(properties);
        String uuid = this.getUniqueID(properties);
        return new ChildInfoImpl(qName, uuid, index);
    }

    public Iterator<PropertyId> getReferences(SessionInfo sessionInfo, NodeId nodeId, Name propertyName, boolean weakReferences) throws ItemNotFoundException, RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        String refType = weakReferences ? "weakreferences" : "references";
        nameSet.add(refType, ItemResourceConstants.NAMESPACE);
        PropFindMethod method = null;
        try {
            String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 0);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length < 1) {
                throw new ItemNotFoundException("Unable to retrieve the node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            List refIds = Collections.emptyList();
            for (MultiStatusResponse resp : responses) {
                DavPropertySet props;
                DavProperty p;
                if (!RepositoryServiceImpl.isSameResource(uri, resp) || (p = (props = resp.getProperties(200)).get(refType, ItemResourceConstants.NAMESPACE)) == null) continue;
                refIds = new ArrayList();
                HrefProperty hp = new HrefProperty(p);
                for (String propHref : hp.getHrefs()) {
                    PropertyId propId = this.uriResolver.getPropertyId(RepositoryServiceImpl.resolve(uri, propHref), sessionInfo);
                    if (propertyName != null && !propertyName.equals(propId.getName())) continue;
                    refIds.add(propId);
                }
            }
            Iterator<PropertyId> iterator = refIds.iterator();
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public PropertyInfo getPropertyInfo(SessionInfo sessionInfo, PropertyId propertyId) throws RepositoryException {
        GetMethod method = null;
        try {
            boolean isMultiValued;
            QValue[] values;
            int type;
            String uri = this.getItemUri((ItemId)propertyId, sessionInfo);
            method = new GetMethod(uri);
            HttpClient client = this.getClient(sessionInfo);
            client.executeMethod((HttpMethod)method);
            int status = method.getStatusCode();
            if (status != 200) {
                throw ExceptionConverter.generate(new DavException(status, method.getStatusText()));
            }
            Path path = this.uriResolver.getQPath(uri, sessionInfo);
            String ct = null;
            Header hd = method.getResponseHeader("Content-Type");
            if (hd != null) {
                ct = hd.getValue();
            }
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            if (ct.startsWith("jcr-value")) {
                QValue v;
                type = JcrValueType.typeFromContentType((String)ct);
                if (type == 2) {
                    v = this.getQValueFactory().create(method.getResponseBodyAsStream());
                } else {
                    int c;
                    InputStreamReader reader = new InputStreamReader(method.getResponseBodyAsStream(), method.getResponseCharSet());
                    StringBuffer sb = new StringBuffer();
                    while ((c = ((Reader)reader).read()) > -1) {
                        sb.append((char)c);
                    }
                    Value jcrValue = this.valueFactory.createValue(sb.toString(), type);
                    v = jcrValue instanceof QValueValue ? ((QValueValue)jcrValue).getQValue() : ValueFormat.getQValue((Value)jcrValue, (NamePathResolver)resolver, (QValueFactory)this.getQValueFactory());
                }
                values = new QValue[]{v};
                isMultiValued = false;
            } else if (ct.startsWith("text/xml")) {
                values = this.getValues(method.getResponseBodyAsStream(), resolver, (ItemId)propertyId);
                type = values.length > 0 ? values[0].getType() : this.loadType(uri, client, propertyId, sessionInfo, resolver);
                isMultiValued = true;
            } else {
                throw new ItemNotFoundException("Unable to retrieve the property with id " + this.saveGetIdString((ItemId)propertyId, resolver));
            }
            PropertyInfoImpl propertyInfoImpl = new PropertyInfoImpl(propertyId, path, type, isMultiValued, values);
            return propertyInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        catch (NameException e) {
            throw new RepositoryException((Throwable)e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private QValue[] getValues(InputStream response, NamePathResolver resolver, ItemId id) throws RepositoryException {
        try {
            Document doc = DomUtil.parseDocument((InputStream)response);
            Element prop = DomUtil.getChildElement((Node)doc, (String)"values", (Namespace)ItemResourceConstants.NAMESPACE);
            if (prop == null) {
                throw new ItemNotFoundException("No property found at " + this.saveGetIdString(id, resolver));
            }
            DefaultDavProperty p = DefaultDavProperty.createFromXml((Element)prop);
            Value[] jcrVs = ValueUtil.valuesFromXml((Object)p.getValue(), (int)1, (ValueFactory)this.valueFactory);
            QValue[] qvs = new QValue[jcrVs.length];
            int type = jcrVs.length > 0 ? jcrVs[0].getType() : 1;
            for (int i = 0; i < jcrVs.length; ++i) {
                qvs[i] = jcrVs[i] instanceof QValueValue ? ((QValueValue)jcrVs[i]).getQValue() : (type == 2 ? this.qValueFactory.create(jcrVs[i].getStream()) : ValueFormat.getQValue((Value)jcrVs[i], (NamePathResolver)resolver, (QValueFactory)this.qValueFactory));
            }
            return qvs;
        }
        catch (SAXException e) {
            log.warn("Internal error: ", (Object)e.getMessage());
            throw new RepositoryException((Throwable)e);
        }
        catch (IOException e) {
            log.warn("Internal error: ", (Object)e.getMessage());
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            log.warn("Internal error: ", (Object)e.getMessage());
            throw new RepositoryException((Throwable)e);
        }
    }

    private int loadType(String propertyURI, HttpClient client, PropertyId propertyId, SessionInfo sessionInfo, NamePathResolver resolver) throws IOException, DavException, RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(TYPE_ATTRIBUTE, ItemResourceConstants.NAMESPACE);
        PropFindMethod method = null;
        try {
            method = new PropFindMethod(propertyURI, nameSet, 0);
            client.executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length == 1) {
                DavPropertySet props = responses[0].getProperties(200);
                DavProperty type = props.get(TYPE_ATTRIBUTE, ItemResourceConstants.NAMESPACE);
                if (type != null) {
                    int n = PropertyType.valueFromName((String)type.getValue().toString());
                    return n;
                }
                throw new RepositoryException("Internal error. Cannot retrieve property type at " + this.saveGetIdString((ItemId)propertyId, resolver));
            }
            throw new ItemNotFoundException("Internal error. Cannot retrieve property type at " + this.saveGetIdString((ItemId)propertyId, resolver));
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public Batch createBatch(SessionInfo sessionInfo, ItemId itemId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        return new BatchImpl(itemId, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void submit(Batch batch) throws RepositoryException {
        if (!(batch instanceof BatchImpl)) {
            throw new RepositoryException("Unknown Batch implementation.");
        }
        BatchImpl batchImpl = (BatchImpl)batch;
        if (batchImpl.isEmpty()) {
            batchImpl.dispose();
            return;
        }
        DavMethod method = null;
        try {
            HttpClient client = batchImpl.start();
            boolean success = false;
            try {
                Iterator it = batchImpl.methods();
                while (it.hasNext()) {
                    method = (DavMethod)it.next();
                    RepositoryServiceImpl.initMethod(method, batchImpl, true);
                    client.executeMethod((HttpMethod)method);
                    method.checkSuccess();
                    method.releaseConnection();
                }
                success = true;
            }
            finally {
                batchImpl.end(client, success);
            }
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e, method);
        }
        finally {
            batchImpl.dispose();
        }
    }

    public void importXml(SessionInfo sessionInfo, NodeId parentId, InputStream xmlStream, int uuidBehaviour) throws RepositoryException {
        Name nodeName = this.getNameFactory().create("", UUID.randomUUID().toString());
        String uri = this.getItemUri(parentId, nodeName, sessionInfo);
        MkColMethod method = new MkColMethod(uri);
        method.addRequestHeader("ImportUUIDBehavior", Integer.toString(uuidBehaviour));
        method.setRequestEntity((RequestEntity)new InputStreamRequestEntity(xmlStream, "text/xml"));
        this.execute((DavMethod)method, sessionInfo);
    }

    public void move(SessionInfo sessionInfo, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        String uri = this.getItemUri((ItemId)srcNodeId, sessionInfo);
        String destUri = this.getItemUri(destParentNodeId, destName, sessionInfo);
        if (this.isDavClass3(sessionInfo)) {
            destUri = RepositoryServiceImpl.obtainAbsolutePathFromUri(destUri);
        }
        MoveMethod method = new MoveMethod(uri, destUri, false);
        this.execute((DavMethod)method, sessionInfo);
        this.clearItemUriCache(sessionInfo);
    }

    public void copy(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
        String uri = this.uriResolver.getItemUri((ItemId)srcNodeId, srcWorkspaceName, sessionInfo);
        String destUri = this.getItemUri(destParentNodeId, destName, sessionInfo);
        if (this.isDavClass3(sessionInfo)) {
            destUri = RepositoryServiceImpl.obtainAbsolutePathFromUri(destUri);
        }
        CopyMethod method = new CopyMethod(uri, destUri, false, false);
        this.execute((DavMethod)method, sessionInfo);
    }

    public void update(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName) throws RepositoryException {
        String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
        String workspUri = this.uriResolver.getWorkspaceUri(srcWorkspaceName);
        this.update(uri, null, new String[]{workspUri}, 2, false, sessionInfo);
    }

    public void clone(SessionInfo sessionInfo, String srcWorkspaceName, NodeId srcNodeId, NodeId destParentNodeId, Name destName, boolean removeExisting) throws RepositoryException {
        throw new UnsupportedOperationException("Missing implementation");
    }

    public LockInfo getLockInfo(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        DavPropertyNameSet nameSet = new DavPropertyNameSet();
        nameSet.add(DavPropertyName.LOCKDISCOVERY);
        nameSet.add("parent", ItemResourceConstants.NAMESPACE);
        PropFindMethod method = null;
        try {
            String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
            method = new PropFindMethod(uri, nameSet, 0);
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, false);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatusResponse[] responses = method.getResponseBodyAsMultiStatus().getResponses();
            if (responses.length != 1) {
                throw new ItemNotFoundException("Unable to retrieve the LockInfo. No such node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            }
            DavPropertySet ps = responses[0].getProperties(200);
            if (ps.contains(DavPropertyName.LOCKDISCOVERY)) {
                DavProperty p = ps.get(DavPropertyName.LOCKDISCOVERY);
                LockDiscovery ld = LockDiscovery.createFromXml((Element)p.toXml(DomUtil.createDocument()));
                NodeId parentId = this.getParentId(uri, ps, sessionInfo);
                LockInfo lockInfo = this.retrieveLockInfo(ld, sessionInfo, nodeId, parentId);
                return lockInfo;
            }
            log.debug("No Lock present on node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            LockInfo lockInfo = null;
            return lockInfo;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped) throws RepositoryException {
        return this.lock(sessionInfo, nodeId, deep, sessionScoped, Long.MAX_VALUE, null);
    }

    public LockInfo lock(SessionInfo sessionInfo, NodeId nodeId, boolean deep, boolean sessionScoped, long timeoutHint, String ownerHint) throws UnsupportedRepositoryOperationException, LockException, AccessDeniedException, RepositoryException {
        try {
            RepositoryServiceImpl.checkSessionInfo(sessionInfo);
            long davTimeout = timeoutHint == Long.MAX_VALUE ? Integer.MAX_VALUE : timeoutHint * 1000L;
            String ownerInfo = ownerHint == null ? sessionInfo.getUserID() : ownerHint;
            String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
            Scope scope = sessionScoped ? ItemResourceConstants.EXCLUSIVE_SESSION : Scope.EXCLUSIVE;
            LockMethod method = new LockMethod(uri, scope, Type.WRITE, ownerInfo, davTimeout, deep);
            this.execute((DavMethod)method, sessionInfo);
            String lockToken = method.getLockToken();
            ((SessionInfoImpl)sessionInfo).addLockToken(lockToken, sessionScoped);
            LockDiscovery disc = method.getResponseAsLockDiscovery();
            return this.retrieveLockInfo(disc, sessionInfo, nodeId, null);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    public void refreshLock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
        Set<String> allLockTokens = ((SessionInfoImpl)sessionInfo).getAllLockTokens();
        String[] locktokens = allLockTokens.toArray(new String[allLockTokens.size()]);
        LockMethod method = new LockMethod(uri, Integer.MAX_VALUE, locktokens);
        this.execute((DavMethod)method, sessionInfo);
    }

    public void unlock(SessionInfo sessionInfo, NodeId nodeId) throws RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
        LockInfoImpl lInfo = (LockInfoImpl)this.getLockInfo(sessionInfo, nodeId);
        if (lInfo == null) {
            throw new LockException("No Lock present on Node with id " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
        }
        String lockToken = lInfo.getActiveLock().getToken();
        boolean isSessionScoped = lInfo.isSessionScoped();
        if (!((SessionInfoImpl)sessionInfo).getAllLockTokens().contains(lockToken)) {
            throw new LockException("Lock " + lockToken + " not owned by this session");
        }
        UnLockMethod method = new UnLockMethod(uri, lockToken);
        this.execute((DavMethod)method, sessionInfo);
        ((SessionInfoImpl)sessionInfo).removeLockToken(lockToken, isSessionScoped);
    }

    private LockInfo retrieveLockInfo(LockDiscovery lockDiscovery, SessionInfo sessionInfo, NodeId nodeId, NodeId parentId) throws RepositoryException {
        LockInfo pLockInfo;
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        List activeLocks = lockDiscovery.getValue();
        ActiveLock activeLock = null;
        for (ActiveLock l : activeLocks) {
            Scope sc = l.getScope();
            if (l.getType() != Type.WRITE || !Scope.EXCLUSIVE.equals((Object)sc) && sc != ItemResourceConstants.EXCLUSIVE_SESSION) continue;
            if (activeLock != null) {
                throw new RepositoryException("Node " + this.saveGetIdString((ItemId)nodeId, sessionInfo) + " contains multiple exclusive write locks.");
            }
            activeLock = l;
        }
        if (activeLock == null) {
            log.debug("No lock present on node " + this.saveGetIdString((ItemId)nodeId, sessionInfo));
            return null;
        }
        NodeId holder = null;
        String lockroot = activeLock.getLockroot();
        if (activeLock.getLockroot() != null) {
            holder = this.uriResolver.getNodeId(lockroot, sessionInfo);
        }
        if (activeLock.isDeep() && holder == null && parentId != null && (pLockInfo = this.getLockInfo(sessionInfo, parentId)) != null) {
            return pLockInfo;
        }
        return new LockInfoImpl(activeLock, holder == null ? nodeId : holder, ((SessionInfoImpl)sessionInfo).getAllLockTokens());
    }

    public NodeId checkin(SessionInfo sessionInfo, NodeId nodeId) throws VersionException, UnsupportedRepositoryOperationException, InvalidItemStateException, LockException, RepositoryException {
        String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
        CheckinMethod method = new CheckinMethod(uri);
        this.execute((DavMethod)method, sessionInfo);
        Header rh = method.getResponseHeader("Location");
        return this.uriResolver.getNodeId(RepositoryServiceImpl.resolve(uri, rh.getValue()), sessionInfo);
    }

    public void checkout(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
        CheckoutMethod method = new CheckoutMethod(uri);
        this.execute((DavMethod)method, sessionInfo);
    }

    public void checkout(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws UnsupportedRepositoryOperationException, LockException, RepositoryException {
        if (activityId != null) {
            throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
        }
        this.checkout(sessionInfo, nodeId);
    }

    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, RepositoryException {
        NodeId vID = this.checkin(sessionInfo, nodeId);
        this.checkout(sessionInfo, nodeId);
        return vID;
    }

    public NodeId checkpoint(SessionInfo sessionInfo, NodeId nodeId, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        if (activityId == null) {
            return this.checkpoint(sessionInfo, nodeId);
        }
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    public void removeVersion(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId) throws RepositoryException {
        String uri = this.getItemUri((ItemId)versionId, sessionInfo);
        DeleteMethod method = new DeleteMethod(uri);
        this.execute((DavMethod)method, sessionInfo);
    }

    public void restore(SessionInfo sessionInfo, NodeId nodeId, NodeId versionId, boolean removeExisting) throws RepositoryException {
        String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
        String vUri = this.getItemUri((ItemId)versionId, sessionInfo);
        Path relPath = null;
        if (!this.exists(sessionInfo, uri)) {
            Path path = nodeId.getPath();
            if (nodeId.getUniqueID() != null) {
                uri = this.getItemUri((ItemId)this.idFactory.createNodeId(nodeId.getUniqueID(), null), sessionInfo);
                relPath = path.isAbsolute() ? this.getPathFactory().getRootPath().computeRelativePath(path) : path;
            } else {
                for (int degree = 0; degree < path.getLength(); ++degree) {
                    Path ancestorPath = path.getAncestor(degree);
                    NodeId parentId = this.idFactory.createNodeId(nodeId.getUniqueID(), ancestorPath);
                    if (!this.exists(sessionInfo, this.getItemUri((ItemId)parentId, sessionInfo))) continue;
                    uri = this.getItemUri((ItemId)parentId, sessionInfo);
                    relPath = ancestorPath.computeRelativePath(path);
                    break;
                }
            }
        }
        this.update(uri, relPath, new String[]{vUri}, 0, removeExisting, sessionInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean exists(SessionInfo sInfo, String uri) {
        HeadMethod method = new HeadMethod(uri);
        try {
            int statusCode = this.getClient(sInfo).executeMethod((HttpMethod)method);
            if (statusCode == 200) {
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            log.error("Unexpected error while testing existence of item.", (Throwable)e);
        }
        catch (RepositoryException e) {
            log.error(e.getMessage());
        }
        finally {
            method.releaseConnection();
        }
        return false;
    }

    public void restore(SessionInfo sessionInfo, NodeId[] versionIds, boolean removeExisting) throws RepositoryException {
        String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
        String[] vUris = new String[versionIds.length];
        for (int i = 0; i < versionIds.length; ++i) {
            vUris[i] = this.getItemUri((ItemId)versionIds[i], sessionInfo);
        }
        this.update(uri, null, vUris, 0, removeExisting, sessionInfo);
    }

    private void update(String uri, Path relPath, String[] updateSource, int updateType, boolean removeExisting, SessionInfo sessionInfo) throws RepositoryException {
        try {
            UpdateInfo uInfo;
            String[] tmpUpdateSource = RepositoryServiceImpl.obtainAbsolutePathsFromUris(updateSource);
            if (removeExisting || relPath != null) {
                Element uElem = UpdateInfo.createUpdateElement((String[])tmpUpdateSource, (int)updateType, (Document)DomUtil.createDocument());
                if (removeExisting) {
                    DomUtil.addChildElement((Element)uElem, (String)"removeexisting", (Namespace)ItemResourceConstants.NAMESPACE);
                }
                if (relPath != null) {
                    DomUtil.addChildElement((Element)uElem, (String)"relpath", (Namespace)ItemResourceConstants.NAMESPACE, (String)this.getNamePathResolver(sessionInfo).getJCRPath(relPath));
                }
                uInfo = new UpdateInfo(uElem);
            } else {
                uInfo = new UpdateInfo(tmpUpdateSource, updateType, new DavPropertyNameSet());
            }
            UpdateMethod method = new UpdateMethod(uri, uInfo);
            this.execute((DavMethod)method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        return this.merge(sessionInfo, nodeId, srcWorkspaceName, bestEffort, false);
    }

    public Iterator<NodeId> merge(SessionInfo sessionInfo, NodeId nodeId, String srcWorkspaceName, boolean bestEffort, boolean isShallow) throws NoSuchWorkspaceException, AccessDeniedException, MergeException, LockException, InvalidItemStateException, RepositoryException {
        try {
            Document doc = DomUtil.createDocument();
            String wspHref = RepositoryServiceImpl.obtainAbsolutePathFromUri(this.uriResolver.getWorkspaceUri(srcWorkspaceName));
            Element mElem = MergeInfo.createMergeElement((String[])new String[]{wspHref}, (!bestEffort ? 1 : 0) != 0, (boolean)false, (Document)doc);
            if (isShallow) {
                mElem.appendChild(DomUtil.depthToXml((boolean)false, (Document)doc));
            }
            MergeInfo mInfo = new MergeInfo(mElem);
            String uri = this.getItemUri((ItemId)nodeId, sessionInfo);
            MergeMethod method = new MergeMethod(uri, mInfo);
            this.execute((DavMethod)method, sessionInfo);
            MultiStatusResponse[] resps = method.getResponseBodyAsMultiStatus().getResponses();
            ArrayList<NodeId> failedIds = new ArrayList<NodeId>(resps.length);
            for (MultiStatusResponse resp : resps) {
                String href = RepositoryServiceImpl.resolve(uri, resp.getHref());
                failedIds.add(this.uriResolver.getNodeId(href, sessionInfo));
            }
            return failedIds.iterator();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
    }

    public void resolveMergeConflict(SessionInfo sessionInfo, NodeId nodeId, NodeId[] mergeFailedIds, NodeId[] predecessorIds) throws VersionException, InvalidItemStateException, UnsupportedRepositoryOperationException, RepositoryException {
        try {
            ArrayList<HrefProperty> changeList = new ArrayList<HrefProperty>();
            String[] mergeFailedHref = new String[mergeFailedIds.length];
            for (int i = 0; i < mergeFailedIds.length; ++i) {
                mergeFailedHref[i] = this.getItemUri((ItemId)mergeFailedIds[i], sessionInfo);
            }
            changeList.add(new HrefProperty(VersionControlledResource.AUTO_MERGE_SET, mergeFailedHref, false));
            if (predecessorIds != null && predecessorIds.length > 0) {
                String[] pdcHrefs = new String[predecessorIds.length];
                for (int i = 0; i < predecessorIds.length; ++i) {
                    pdcHrefs[i] = this.getItemUri((ItemId)predecessorIds[i], sessionInfo);
                }
                changeList.add(new HrefProperty(VersionControlledResource.PREDECESSOR_SET, pdcHrefs, false));
            }
            PropPatchMethod method = new PropPatchMethod(this.getItemUri((ItemId)nodeId, sessionInfo), changeList);
            this.execute((DavMethod)method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void addVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label, boolean moveLabel) throws VersionException, RepositoryException {
        try {
            String uri = this.getItemUri((ItemId)versionId, sessionInfo);
            String strLabel = this.getNamePathResolver(sessionInfo).getJCRName(label);
            LabelMethod method = new LabelMethod(uri, strLabel, moveLabel ? 0 : 2);
            this.execute((DavMethod)method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public void removeVersionLabel(SessionInfo sessionInfo, NodeId versionHistoryId, NodeId versionId, Name label) throws VersionException, RepositoryException {
        try {
            String uri = this.getItemUri((ItemId)versionId, sessionInfo);
            String strLabel = this.getNamePathResolver(sessionInfo).getJCRName(label);
            LabelMethod method = new LabelMethod(uri, strLabel, 1);
            this.execute((DavMethod)method, sessionInfo);
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public NodeId createActivity(SessionInfo sessionInfo, String title) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    public void removeActivity(SessionInfo sessionInfo, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    public Iterator<NodeId> mergeActivity(SessionInfo sessionInfo, NodeId activityId) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    public NodeId createConfiguration(SessionInfo sessionInfo, NodeId nodeId) throws UnsupportedRepositoryOperationException, RepositoryException {
        throw new UnsupportedOperationException("JCR-2104: JSR 283 Versioning. Implementation missing");
    }

    public String[] getSupportedQueryLanguages(SessionInfo sessionInfo) throws RepositoryException {
        OptionsMethod method = new OptionsMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()));
        try {
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            Header daslHeader = method.getResponseHeader("DASL");
            CodedUrlHeader h = new CodedUrlHeader(daslHeader.getName(), daslHeader.getValue());
            String[] stringArray = h.getCodedUrls();
            return stringArray;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            method.releaseConnection();
        }
    }

    public String[] checkQueryStatement(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces) throws InvalidQueryException, RepositoryException {
        return new String[0];
    }

    public QueryInfo executeQuery(SessionInfo sessionInfo, String statement, String language, Map<String, String> namespaces, long limit, long offset, Map<String, QValue> values) throws RepositoryException {
        SearchMethod method = null;
        try {
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            SearchInfo sInfo = new SearchInfo(language, ItemResourceConstants.NAMESPACE, statement, namespaces);
            if (limit != -1L) {
                sInfo.setNumberResults(limit);
            }
            if (offset != -1L) {
                sInfo.setOffset(offset);
            }
            if (values != null && !values.isEmpty()) {
                throw new UnsupportedOperationException("Implementation missing:  JCR-2107");
            }
            method = new SearchMethod(uri, sInfo);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            MultiStatus ms = method.getResponseBodyAsMultiStatus();
            NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
            QueryInfoImpl queryInfoImpl = new QueryInfoImpl(ms, this.idFactory, resolver, this.valueFactory, this.getQValueFactory());
            return queryInfoImpl;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventFilter createEventFilter(SessionInfo sessionInfo, int eventTypes, Path absPath, boolean isDeep, String[] uuids, Name[] nodeTypeNames, boolean noLocal) throws UnsupportedRepositoryOperationException, RepositoryException {
        HashSet<Name> resolvedTypeNames = null;
        if (nodeTypeNames != null) {
            resolvedTypeNames = new HashSet<Name>();
            if (this.nodeTypeDefinitions.size() == 0) {
                this.getQNodeTypeDefinitions(sessionInfo);
            }
            Map<Name, QNodeTypeDefinition> map = this.nodeTypeDefinitions;
            synchronized (map) {
                for (Name nodeTypeName : nodeTypeNames) {
                    this.resolveNodeType(resolvedTypeNames, nodeTypeName);
                }
            }
        }
        return new EventFilterImpl(eventTypes, absPath, isDeep, uuids, resolvedTypeNames, noLocal);
    }

    public EventBundle[] getEvents(Subscription subscription, long timeout) throws RepositoryException, UnsupportedRepositoryOperationException {
        RepositoryServiceImpl.checkSubscription(subscription);
        EventSubscriptionImpl subscr = (EventSubscriptionImpl)subscription;
        String rootUri = this.uriResolver.getRootItemUri(subscr.getSessionInfo().getWorkspaceName());
        return this.poll(rootUri, subscr.getId(), timeout, subscr.getSessionInfo());
    }

    public EventBundle getEvents(SessionInfo sessionInfo, EventFilter filter, long after) throws RepositoryException, UnsupportedRepositoryOperationException {
        GetMethod method = null;
        String rootUri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
        rootUri = rootUri + "?type=journal";
        try {
            method = new GetMethod(rootUri);
            method.addRequestHeader("If-None-Match", "\"" + Long.toHexString(after) + "\"");
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            assert (method.getStatusCode() == 200);
            InputStream in = method.getResponseBodyAsStream();
            Document doc = null;
            if (in != null) {
                try {
                    doc = DomUtil.parseDocument((InputStream)in);
                }
                catch (ParserConfigurationException e) {
                    IOException exception = new IOException("XML parser configuration error");
                    exception.initCause(e);
                    throw exception;
                }
                catch (SAXException e) {
                    IOException exception = new IOException("XML parsing error");
                    exception.initCause(e);
                    throw exception;
                }
                finally {
                    in.close();
                }
            }
            ArrayList<Event> events = new ArrayList<Event>();
            ElementIterator entries = DomUtil.getChildren((Element)doc.getDocumentElement(), (QName)AtomFeedConstants.N_ENTRY);
            while (entries.hasNext()) {
                Element entryElem = entries.next();
                Element contentElem = DomUtil.getChildElement((Node)entryElem, (QName)AtomFeedConstants.N_CONTENT);
                if (contentElem == null || !"application/vnd.apache.jackrabbit.event+xml".equals(contentElem.getAttribute(TYPE_ATTRIBUTE))) continue;
                List<Event> el = this.buildEventList(contentElem, (SessionInfoImpl)sessionInfo, rootUri);
                for (Event e : el) {
                    if (e.getDate() <= after || filter != null && !filter.accept(e, false)) continue;
                    events.add(e);
                }
            }
            return new EventBundleImpl(events, false);
        }
        catch (Exception ex) {
            log.error("extracting events from journal feed", (Throwable)ex);
            throw new RepositoryException((Throwable)ex);
        }
    }

    public Subscription createSubscription(SessionInfo sessionInfo, EventFilter[] filters) throws UnsupportedRepositoryOperationException, RepositoryException {
        RepositoryServiceImpl.checkSessionInfo(sessionInfo);
        String rootUri = this.uriResolver.getRootItemUri(sessionInfo.getWorkspaceName());
        String subscriptionId = this.subscribe(rootUri, S_INFO, null, sessionInfo, null);
        log.debug("Subscribed on server for session info " + sessionInfo);
        try {
            this.checkEventFilterSupport(filters);
        }
        catch (UnsupportedRepositoryOperationException ex) {
            this.unsubscribe(rootUri, subscriptionId, sessionInfo);
            throw ex;
        }
        return new EventSubscriptionImpl(subscriptionId, (SessionInfoImpl)sessionInfo);
    }

    public void updateEventFilters(Subscription subscription, EventFilter[] filters) throws RepositoryException {
        this.checkEventFilterSupport(filters);
    }

    private void checkEventFilterSupport(EventFilter[] filters) throws UnsupportedRepositoryOperationException {
        for (EventFilter ef : filters) {
            if (!(ef instanceof EventFilterImpl)) continue;
            EventFilterImpl efi = (EventFilterImpl)ef;
            if (efi.getNodeTypeNames() != null && !this.remoteServerProvidesNodeTypes) {
                throw new UnsupportedRepositoryOperationException("Remote server does not provide node type information in events");
            }
            if (!efi.getNoLocal() || this.remoteServerProvidesNoLocalFlag) continue;
            throw new UnsupportedRepositoryOperationException("Remote server does not provide local flag in events");
        }
    }

    public void dispose(Subscription subscription) throws RepositoryException {
        RepositoryServiceImpl.checkSubscription(subscription);
        EventSubscriptionImpl subscr = (EventSubscriptionImpl)subscription;
        String rootUri = this.uriResolver.getRootItemUri(subscr.getSessionInfo().getWorkspaceName());
        this.unsubscribe(rootUri, subscr.getId(), (SessionInfo)subscr.getSessionInfo());
    }

    private String subscribe(String uri, SubscriptionInfo subscriptionInfo, String subscriptionId, SessionInfo sessionInfo, String batchId) throws RepositoryException {
        SubscribeMethod method = null;
        try {
            method = subscriptionId != null ? new SubscribeMethod(uri, subscriptionInfo, subscriptionId) : new SubscribeMethod(uri, subscriptionInfo);
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo);
            if (batchId != null) {
                CodedUrlHeader ch = new CodedUrlHeader("TransactionId", batchId);
                method.setRequestHeader(ch.getHeaderName(), ch.getHeaderValue());
            }
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            org.apache.jackrabbit.webdav.observation.Subscription[] subs = method.getResponseAsSubscriptionDiscovery().getValue();
            if (subs.length == 1) {
                this.remoteServerProvidesNodeTypes = subs[0].eventsProvideNodeTypeInformation();
                this.remoteServerProvidesNoLocalFlag = subs[0].eventsProvideNoLocalFlag();
            }
            String string = method.getSubscriptionId();
            return string;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void unsubscribe(String uri, String subscriptionId, SessionInfo sessionInfo) throws RepositoryException {
        UnSubscribeMethod method = null;
        try {
            method = new UnSubscribeMethod(uri, subscriptionId);
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private void resolveNodeType(Set<Name> resolved, Name ntName) {
        if (!resolved.add(ntName)) {
            return;
        }
        QNodeTypeDefinition def = this.nodeTypeDefinitions.get(ntName);
        if (def != null) {
            for (Name supertype : def.getSupertypes()) {
                this.resolveNodeType(resolved, supertype);
            }
        }
    }

    private EventBundle[] poll(String uri, String subscriptionId, long timeout, SessionInfoImpl sessionInfo) throws RepositoryException {
        PollMethod method = null;
        try {
            EventBundle[] events;
            method = new PollMethod(uri, subscriptionId, timeout);
            this.getClient((SessionInfo)sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            EventDiscovery disc = method.getResponseAsEventDiscovery();
            if (disc.isEmpty()) {
                events = new EventBundle[]{};
            } else {
                Element discEl = disc.toXml(DomUtil.createDocument());
                ElementIterator it = DomUtil.getChildren((Element)discEl, (QName)ObservationConstants.N_EVENTBUNDLE);
                ArrayList<EventBundleImpl> bundles = new ArrayList<EventBundleImpl>();
                while (it.hasNext()) {
                    Element bundleElement = it.nextElement();
                    String value = DomUtil.getAttribute((Element)bundleElement, (String)"local", null);
                    boolean isLocal = false;
                    if (value != null) {
                        isLocal = Boolean.parseBoolean(value);
                    }
                    bundles.add(new EventBundleImpl(this.buildEventList(bundleElement, sessionInfo, uri), isLocal));
                }
                events = bundles.toArray(new EventBundle[bundles.size()]);
            }
            EventBundle[] eventBundleArray = events;
            return eventBundleArray;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    private List<Event> buildEventList(Element bundleElement, SessionInfoImpl sessionInfo, String baseUri) throws IllegalNameException, NamespaceException, RepositoryException {
        ArrayList<Event> events = new ArrayList<Event>();
        ElementIterator eventElementIterator = DomUtil.getChildren((Element)bundleElement, (QName)ObservationConstants.N_EVENT);
        String userId = null;
        if (DomUtil.matches((Node)bundleElement, (QName)AtomFeedConstants.N_ENTRY)) {
            Element nameEl;
            Element authorEl = DomUtil.getChildElement((Node)bundleElement, (QName)AtomFeedConstants.N_AUTHOR);
            Element element = nameEl = authorEl != null ? DomUtil.getChildElement((Node)authorEl, (QName)AtomFeedConstants.N_NAME) : null;
            if (nameEl != null) {
                userId = DomUtil.getTextTrim((Element)nameEl);
            }
        }
        while (eventElementIterator.hasNext()) {
            Element evElem = eventElementIterator.nextElement();
            Element typeEl = DomUtil.getChildElement((Node)evElem, (QName)ObservationConstants.N_EVENTTYPE);
            EventType[] et = DefaultEventType.createFromXml((Element)typeEl);
            if (et.length == 0 || et.length > 1) {
                log.error("Ambiguous event type definition: expected one single event type.");
                continue;
            }
            String href = DomUtil.getChildTextTrim((Element)evElem, (String)"href", (Namespace)NAMESPACE);
            int type = EventUtil.getJcrEventType((String)et[0].getName());
            Path eventPath = null;
            Object eventId = null;
            NodeId parentId = null;
            if (href != null) {
                href = RepositoryServiceImpl.resolve(baseUri, href);
                try {
                    eventPath = this.uriResolver.getQPath(href, (SessionInfo)sessionInfo);
                }
                catch (RepositoryException e) {
                    log.error("Internal error while building Event", (Object)e.getMessage());
                    continue;
                }
                boolean isForNode = type == 1 || type == 2 || type == 32;
                try {
                    eventId = isForNode ? this.uriResolver.getNodeIdAfterEvent(href, (SessionInfo)sessionInfo, type == 2) : this.uriResolver.getPropertyId(href, (SessionInfo)sessionInfo);
                }
                catch (RepositoryException e) {
                    if (isForNode) {
                        eventId = this.idFactory.createNodeId((String)null, eventPath);
                    }
                    try {
                        eventId = this.idFactory.createPropertyId(this.idFactory.createNodeId((String)null, eventPath.getAncestor(1)), eventPath.getName());
                    }
                    catch (RepositoryException e1) {
                        log.warn("Unable to build event itemId: ", (Object)e.getMessage());
                    }
                }
                String parentHref = org.apache.jackrabbit.util.Text.getRelativeParent((String)href, (int)1, (boolean)true);
                try {
                    parentId = this.uriResolver.getNodeId(parentHref, (SessionInfo)sessionInfo);
                }
                catch (RepositoryException e) {
                    log.warn("Unable to build event parentId: ", (Object)e.getMessage());
                }
            }
            if (userId == null) {
                userId = DomUtil.getChildTextTrim((Element)evElem, (QName)ObservationConstants.N_EVENTUSERID);
            }
            events.add((Event)new EventImpl((ItemId)eventId, eventPath, parentId, type, userId, evElem, this.getNamePathResolver(sessionInfo), this.getQValueFactory()));
        }
        return events;
    }

    public Map<String, String> getRegisteredNamespaces(SessionInfo sessionInfo) throws RepositoryException {
        ReportInfo info = new ReportInfo("registerednamespaces", ItemResourceConstants.NAMESPACE);
        ReportMethod method = null;
        try {
            method = new ReportMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()), info);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            Document doc = method.getResponseBodyAsDocument();
            HashMap<String, String> namespaces = new HashMap<String, String>();
            if (doc != null) {
                Element rootElement = doc.getDocumentElement();
                ElementIterator nsElems = DomUtil.getChildren((Element)rootElement, (String)"namespace", (Namespace)ItemResourceConstants.NAMESPACE);
                while (nsElems.hasNext()) {
                    Element elem = nsElems.nextElement();
                    String prefix = DomUtil.getChildText((Element)elem, (String)"prefix", (Namespace)ItemResourceConstants.NAMESPACE);
                    String uri = DomUtil.getChildText((Element)elem, (String)"uri", (Namespace)ItemResourceConstants.NAMESPACE);
                    if (prefix == null && uri == null) {
                        uri = "";
                        prefix = "";
                    }
                    if (uri != null) {
                        namespaces.put(prefix, uri);
                        this.nsCache.add(prefix, uri);
                        continue;
                    }
                    log.error("Invalid prefix / uri pair: " + prefix + " -> " + uri);
                }
            }
            HashMap<String, String> hashMap = namespaces;
            return hashMap;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public String getNamespaceURI(SessionInfo sessionInfo, String prefix) throws NamespaceException, RepositoryException {
        try {
            return this.nsCache.getURI(prefix);
        }
        catch (NamespaceException e) {
            this.getRegisteredNamespaces(sessionInfo);
            return this.nsCache.getURI(prefix);
        }
    }

    public String getNamespacePrefix(SessionInfo sessionInfo, String uri) throws NamespaceException, RepositoryException {
        try {
            return this.nsCache.getPrefix(uri);
        }
        catch (NamespaceException e) {
            this.getRegisteredNamespaces(sessionInfo);
            return this.nsCache.getPrefix(uri);
        }
    }

    public void registerNamespace(SessionInfo sessionInfo, String prefix, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.getRegisteredNamespaces(sessionInfo);
        HashMap<String, String> namespaces = new HashMap<String, String>(this.nsCache.getNamespaces());
        namespaces.put(prefix, uri);
        this.internalSetNamespaces(sessionInfo, namespaces);
        this.nsCache.add(prefix, uri);
    }

    public void unregisterNamespace(SessionInfo sessionInfo, String uri) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        this.getRegisteredNamespaces(sessionInfo);
        String prefix = this.nsCache.getPrefix(uri);
        HashMap<String, String> namespaces = new HashMap<String, String>(this.nsCache.getNamespaces());
        namespaces.remove(prefix);
        this.internalSetNamespaces(sessionInfo, namespaces);
        this.nsCache.remove(prefix, uri);
    }

    private void internalSetNamespaces(SessionInfo sessionInfo, Map<String, String> namespaces) throws NamespaceException, UnsupportedRepositoryOperationException, AccessDeniedException, RepositoryException {
        DavPropertySet setProperties = new DavPropertySet();
        setProperties.add(RepositoryServiceImpl.createNamespaceProperty(namespaces));
        PropPatchMethod method = null;
        try {
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo) throws RepositoryException {
        ReportMethod method = null;
        try {
            ReportInfo info = new ReportInfo("nodetypes", ItemResourceConstants.NAMESPACE);
            info.setContentElement(DomUtil.createElement((Document)DomUtil.createDocument(), (String)"all-nodetypes", (Namespace)ItemResourceConstants.NAMESPACE));
            String workspaceUri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            method = new ReportMethod(workspaceUri, info);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
            Document reportDoc = method.getResponseBodyAsDocument();
            Iterator<QNodeTypeDefinition> iterator = this.retrieveQNodeTypeDefinitions(sessionInfo, reportDoc);
            return iterator;
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (ParserConfigurationException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public Iterator<QNodeTypeDefinition> getQNodeTypeDefinitions(SessionInfo sessionInfo, Name[] nodetypeNames) throws RepositoryException {
        return this.getQNodeTypeDefinitions(sessionInfo);
    }

    public void registerNodeTypes(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, boolean allowUpdate) throws InvalidNodeTypeDefinitionException, NodeTypeExistsException, UnsupportedRepositoryOperationException, RepositoryException {
        PropPatchMethod method = null;
        try {
            DavPropertySet setProperties = new DavPropertySet();
            setProperties.add(this.createRegisterNodeTypesProperty(sessionInfo, nodeTypeDefinitions, allowUpdate));
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void unregisterNodeTypes(SessionInfo sessionInfo, Name[] nodeTypeNames) throws UnsupportedRepositoryOperationException, NoSuchNodeTypeException, RepositoryException {
        PropPatchMethod method = null;
        try {
            DavPropertySet setProperties = new DavPropertySet();
            setProperties.add(this.createUnRegisterNodeTypesProperty(sessionInfo, nodeTypeNames));
            String uri = this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName());
            method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void createWorkspace(SessionInfo sessionInfo, String name, String srcWorkspaceName) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        if (srcWorkspaceName != null) {
            throw new UnsupportedOperationException("JCR-2003. Implementation missing");
        }
        MkWorkspaceMethod method = null;
        try {
            method = new MkWorkspaceMethod(this.uriResolver.getWorkspaceUri(name));
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public void deleteWorkspace(SessionInfo sessionInfo, String name) throws AccessDeniedException, UnsupportedRepositoryOperationException, NoSuchWorkspaceException, RepositoryException {
        DeleteMethod method = null;
        try {
            method = new DeleteMethod(this.uriResolver.getWorkspaceUri(name));
            RepositoryServiceImpl.initMethod((HttpMethod)method, sessionInfo, true);
            this.getClient(sessionInfo).executeMethod((HttpMethod)method);
            method.checkSuccess();
        }
        catch (IOException e) {
            throw new RepositoryException((Throwable)e);
        }
        catch (DavException e) {
            throw ExceptionConverter.generate(e);
        }
        finally {
            if (method != null) {
                method.releaseConnection();
            }
        }
    }

    public static URI computeRepositoryUri(String uri) throws URIException {
        boolean useDefaultPort;
        URI repositoryUri = new URI(uri.endsWith("/") ? uri : uri + "/", true);
        boolean bl = useDefaultPort = "http".equalsIgnoreCase(repositoryUri.getScheme()) && repositoryUri.getPort() == 80 || "https".equalsIgnoreCase(repositoryUri.getScheme()) && repositoryUri.getPort() == 443;
        if (useDefaultPort) {
            repositoryUri = new URI(repositoryUri.getScheme(), repositoryUri.getUserinfo(), repositoryUri.getHost(), -1, repositoryUri.getPath(), repositoryUri.getQuery(), repositoryUri.getFragment());
        }
        return repositoryUri;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<QNodeTypeDefinition> retrieveQNodeTypeDefinitions(SessionInfo sessionInfo, Document reportDoc) throws RepositoryException {
        ElementIterator it = DomUtil.getChildren((Element)reportDoc.getDocumentElement(), (String)"nodeType", null);
        ArrayList<QNodeTypeDefinition> ntDefs = new ArrayList<QNodeTypeDefinition>();
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        while (it.hasNext()) {
            ntDefs.add(DefinitionUtil.createQNodeTypeDefinition(it.nextElement(), resolver, this.getQValueFactory()));
        }
        Map<Name, QNodeTypeDefinition> map = this.nodeTypeDefinitions;
        synchronized (map) {
            this.nodeTypeDefinitions.clear();
            for (Object e : ntDefs) {
                QNodeTypeDefinition def = (QNodeTypeDefinition)e;
                this.nodeTypeDefinitions.put(def.getName(), def);
            }
        }
        return ntDefs.iterator();
    }

    private DavProperty<List<XmlSerializable>> createRegisterNodeTypesProperty(SessionInfo sessionInfo, QNodeTypeDefinition[] nodeTypeDefinitions, final boolean allowUpdate) throws IOException {
        ArrayList<Object> val = new ArrayList<Object>();
        StringWriter sw = new StringWriter();
        CompactNodeTypeDefWriter writer = new CompactNodeTypeDefWriter((Writer)sw, (NamespaceResolver)new NamespaceResolverImpl(sessionInfo), true);
        writer.write(Arrays.asList(nodeTypeDefinitions));
        writer.close();
        final String cnd = sw.toString();
        val.add(new XmlSerializable(){

            public Element toXml(Document document) {
                Element cndElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:cnd");
                DomUtil.setText((Element)cndElem, (String)cnd);
                return cndElem;
            }
        });
        val.add(new XmlSerializable(){

            public Element toXml(Document document) {
                Element allowElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:allowupdate");
                DomUtil.setText((Element)allowElem, (String)Boolean.toString(allowUpdate));
                return allowElem;
            }
        });
        return new DefaultDavProperty("nodetypes-cnd", val, ItemResourceConstants.NAMESPACE, false);
    }

    private DavProperty<List<XmlSerializable>> createUnRegisterNodeTypesProperty(SessionInfo sessionInfo, Name[] nodeTypeNames) throws IOException, RepositoryException {
        NamePathResolver resolver = this.getNamePathResolver(sessionInfo);
        ArrayList<3> val = new ArrayList<3>();
        for (Name ntName : nodeTypeNames) {
            final String jcrName = resolver.getJCRName(ntName);
            val.add(new XmlSerializable(){

                public Element toXml(Document document) {
                    Element ntNameElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:nodetypename");
                    Text txt = document.createTextNode(jcrName);
                    ntNameElem.appendChild(txt);
                    return ntNameElem;
                }
            });
        }
        return new DefaultDavProperty("nodetypes-cnd", val, ItemResourceConstants.NAMESPACE, false);
    }

    private static DavProperty<List<XmlSerializable>> createValuesProperty(Value[] jcrValues) {
        ArrayList<4> val = new ArrayList<4>();
        for (final Value jcrValue : jcrValues) {
            val.add(new XmlSerializable(){

                public Element toXml(Document document) {
                    try {
                        return ValueUtil.valueToXml((Value)jcrValue, (Document)document);
                    }
                    catch (RepositoryException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        return new DefaultDavProperty("values", val, ItemResourceConstants.NAMESPACE, false);
    }

    private static DavProperty<List<XmlSerializable>> createNamespaceProperty(final Map<String, String> namespaces) {
        ArrayList<5> val = new ArrayList<5>();
        for (final String prefix : namespaces.keySet()) {
            val.add(new XmlSerializable(){

                public Element toXml(Document document) {
                    Element nsElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:namespace");
                    Element prefixElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:prefix");
                    Text txt = document.createTextNode(prefix);
                    prefixElem.appendChild(txt);
                    String uri = (String)namespaces.get(prefix);
                    Element uriElem = document.createElementNS("http://www.day.com/jcr/webdav/1.0", "dcr:uri");
                    Text txt2 = document.createTextNode(uri);
                    uriElem.appendChild(txt2);
                    nsElem.appendChild(prefixElem);
                    nsElem.appendChild(uriElem);
                    return nsElem;
                }
            });
        }
        return new DefaultDavProperty("namespaces", val, ItemResourceConstants.NAMESPACE, false);
    }

    private static DavProperty<List<XmlSerializable>> createNodeTypeProperty(String localName, String[] ntNames) {
        ArrayList<6> val = new ArrayList<6>();
        for (final String ntName : ntNames) {
            val.add(new XmlSerializable(){

                public Element toXml(Document document) {
                    return NodeTypeUtil.ntNameToXml((String)ntName, (Document)document);
                }
            });
        }
        return new DefaultDavProperty(localName, val, ItemResourceConstants.NAMESPACE, false);
    }

    private Set<String> getDavComplianceClasses(SessionInfo sessionInfo) throws RepositoryException {
        if (this.remoteDavComplianceClasses == null) {
            OptionsMethod method = new OptionsMethod(this.uriResolver.getWorkspaceUri(sessionInfo.getWorkspaceName()));
            try {
                this.getClient(sessionInfo).executeMethod((HttpMethod)method);
                method.checkSuccess();
                Header davHeader = method.getResponseHeader("DAV");
                if (davHeader != null) {
                    String[] classes = davHeader.getValue().split(",");
                    this.remoteDavComplianceClasses = new HashSet<String>();
                    for (String c : classes) {
                        this.remoteDavComplianceClasses.add(c.trim());
                    }
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                method.releaseConnection();
            }
        }
        return this.remoteDavComplianceClasses;
    }

    private boolean isDavClass3(SessionInfo sessionInfo) {
        try {
            return this.getDavComplianceClasses(sessionInfo).contains("3");
        }
        catch (RepositoryException ex) {
            log.warn("failure to obtain OPTIONS response", (Throwable)ex);
            return false;
        }
    }

    private static String obtainAbsolutePathFromUri(String uri) {
        try {
            java.net.URI u = new java.net.URI(uri);
            StringBuilder sb = new StringBuilder();
            sb.append(u.getRawPath());
            if (u.getRawQuery() != null) {
                sb.append("?" + u.getRawQuery());
            }
            return sb.toString();
        }
        catch (URISyntaxException ex) {
            log.warn("parsing " + uri, (Throwable)ex);
            return uri;
        }
    }

    private static String[] obtainAbsolutePathsFromUris(String[] uris) {
        if (uris == null) {
            return null;
        }
        String[] result = new String[uris.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = RepositoryServiceImpl.obtainAbsolutePathFromUri(uris[i]);
        }
        return result;
    }

    static {
        HashSet<String> tmp = new HashSet<String>();
        tmp.add("GET");
        tmp.add("HEAD");
        tmp.add("PROPFIND");
        tmp.add("POLL");
        tmp.add("REPORT");
        tmp.add("SEARCH");
        readMethods = Collections.unmodifiableSet(tmp);
        SV_NAMESPACE = Namespace.getNamespace((String)"sv", (String)"http://www.jcp.org/jcr/sv/1.0");
    }

    private static class NamespaceCache
    extends AbstractNamespaceResolver {
        private final HashMap<String, String> prefixToURI = new HashMap();
        private final HashMap<String, String> uriToPrefix = new HashMap();

        private NamespaceCache() {
        }

        public Map<String, String> getNamespaces() {
            return new HashMap<String, String>(this.prefixToURI);
        }

        public void add(String prefix, String uri) {
            this.prefixToURI.put(prefix, uri);
            this.uriToPrefix.put(uri, prefix);
        }

        public void remove(String prefix, String uri) {
            this.prefixToURI.remove(prefix);
            this.uriToPrefix.remove(uri);
        }

        public String getURI(String prefix) throws NamespaceException {
            String uri = this.prefixToURI.get(prefix);
            if (uri != null) {
                return uri;
            }
            throw new NamespaceException(prefix + ": is not a registered namespace prefix.");
        }

        public String getPrefix(String uri) throws NamespaceException {
            String prefix = this.uriToPrefix.get(uri);
            if (prefix != null) {
                return prefix;
            }
            throw new NamespaceException(uri + ": is not a registered namespace uri.");
        }
    }

    private class NamePathResolverImpl
    implements NamePathResolver {
        private final NameResolver nResolver;
        private final PathResolver pResolver;

        private NamePathResolverImpl(SessionInfo sessionInfo) {
            NamespaceResolverImpl nsResolver = new NamespaceResolverImpl(sessionInfo);
            this.nResolver = new ParsingNameResolver(RepositoryServiceImpl.this.getNameFactory(), (NamespaceResolver)nsResolver);
            IdentifierResolverImpl idResolver = new IdentifierResolverImpl(sessionInfo);
            this.pResolver = new ParsingPathResolver(RepositoryServiceImpl.this.getPathFactory(), this.nResolver, (IdentifierResolver)idResolver);
        }

        private NamePathResolverImpl(NamespaceResolver nsResolver) {
            this.nResolver = new ParsingNameResolver(RepositoryServiceImpl.this.getNameFactory(), nsResolver);
            this.pResolver = new ParsingPathResolver(RepositoryServiceImpl.this.getPathFactory(), this.nResolver);
        }

        public Name getQName(String jcrName) throws IllegalNameException, NamespaceException {
            return this.nResolver.getQName(jcrName);
        }

        public String getJCRName(Name qName) throws NamespaceException {
            return this.nResolver.getJCRName(qName);
        }

        public Path getQPath(String path) throws MalformedPathException, IllegalNameException, NamespaceException {
            return this.pResolver.getQPath(path);
        }

        public Path getQPath(String path, boolean normalizeIdentifier) throws MalformedPathException, IllegalNameException, NamespaceException {
            return this.pResolver.getQPath(path, normalizeIdentifier);
        }

        public String getJCRPath(Path path) throws NamespaceException {
            return this.pResolver.getJCRPath(path);
        }
    }

    private class IdentifierResolverImpl
    implements IdentifierResolver {
        private final SessionInfo sessionInfo;

        private IdentifierResolverImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        private Path buildPath(String uniqueID) throws RepositoryException {
            String uri = RepositoryServiceImpl.this.uriResolver.getItemUri((ItemId)RepositoryServiceImpl.this.getIdFactory().createNodeId(uniqueID), this.sessionInfo.getWorkspaceName(), this.sessionInfo);
            return RepositoryServiceImpl.this.uriResolver.getQPath(uri, this.sessionInfo);
        }

        private Path resolvePath(String jcrPath) throws RepositoryException {
            return ((SessionInfoImpl)this.sessionInfo).getNamePathResolver().getQPath(jcrPath);
        }

        public Path getPath(String identifier) throws MalformedPathException {
            try {
                int pos = identifier.indexOf(47);
                if (pos == -1) {
                    return this.buildPath(identifier);
                }
                if (pos == 0) {
                    return this.resolvePath(identifier);
                }
                Path p1 = this.buildPath(identifier.substring(0, pos));
                Path p2 = this.resolvePath(identifier.substring(pos));
                return RepositoryServiceImpl.this.getPathFactory().create(p1, p2, true);
            }
            catch (RepositoryException e) {
                throw new MalformedPathException(identifier);
            }
        }

        public void checkFormat(String identifier) throws MalformedPathException {
        }
    }

    private class NamespaceResolverImpl
    implements NamespaceResolver {
        private final SessionInfo sessionInfo;

        private NamespaceResolverImpl(SessionInfo sessionInfo) {
            this.sessionInfo = sessionInfo;
        }

        public String getURI(String prefix) throws NamespaceException {
            try {
                return RepositoryServiceImpl.this.getNamespaceURI(this.sessionInfo, prefix);
            }
            catch (RepositoryException e) {
                String msg = "Error retrieving namespace uri";
                throw new NamespaceException(msg, (Throwable)e);
            }
        }

        public String getPrefix(String uri) throws NamespaceException {
            try {
                return RepositoryServiceImpl.this.getNamespacePrefix(this.sessionInfo, uri);
            }
            catch (RepositoryException e) {
                String msg = "Error retrieving namespace prefix";
                throw new NamespaceException(msg, (Throwable)e);
            }
        }
    }

    private class BatchImpl
    implements Batch {
        private final SessionInfo sessionInfo;
        private final ItemId targetId;
        private final List<DavMethod> methods = new ArrayList<DavMethod>();
        private final NamePathResolver resolver;
        private String batchId;
        private boolean isConsumed = false;
        private boolean clear = false;

        private BatchImpl(ItemId targetId, SessionInfo sessionInfo) throws RepositoryException {
            this.targetId = targetId;
            this.sessionInfo = sessionInfo;
            this.resolver = RepositoryServiceImpl.this.getNamePathResolver(sessionInfo);
        }

        private HttpClient start() throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(this.targetId, this.sessionInfo);
            try {
                LockMethod method = new LockMethod(uri, TransactionConstants.LOCAL, TransactionConstants.TRANSACTION, null, Integer.MAX_VALUE, true);
                RepositoryServiceImpl.initMethod((HttpMethod)method, this.sessionInfo, true);
                HttpClient client = RepositoryServiceImpl.this.getClient(this.sessionInfo);
                client.executeMethod((HttpMethod)method);
                if (method.getStatusCode() == 412) {
                    throw new InvalidItemStateException("Unable to persist transient changes.");
                }
                method.checkSuccess();
                this.batchId = method.getLockToken();
                return client;
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
        }

        private void end(HttpClient client, boolean commit) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(this.targetId, this.sessionInfo);
            UnLockMethod method = null;
            try {
                method = new UnLockMethod(uri, this.batchId);
                RepositoryServiceImpl.initMethod((HttpMethod)method, this.sessionInfo, true);
                method.setRequestBody((XmlSerializable)new TransactionInfo(commit));
                client.executeMethod((HttpMethod)method);
                method.checkSuccess();
                if (this.sessionInfo instanceof SessionInfoImpl) {
                    ((SessionInfoImpl)this.sessionInfo).setLastBatchId(this.batchId);
                }
                if (this.clear) {
                    RepositoryServiceImpl.this.clearItemUriCache(this.sessionInfo);
                }
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (DavException e) {
                throw ExceptionConverter.generate(e);
            }
            finally {
                if (method != null) {
                    method.releaseConnection();
                }
            }
        }

        private void dispose() {
            this.methods.clear();
            this.isConsumed = true;
        }

        private void checkConsumed() {
            if (this.isConsumed) {
                throw new IllegalStateException("Batch has already been consumed.");
            }
        }

        private boolean isEmpty() {
            return this.methods.isEmpty();
        }

        private Iterator<DavMethod> methods() {
            return this.methods.iterator();
        }

        public void addNode(NodeId parentId, Name nodeName, Name nodetypeName, String uuid) throws RepositoryException {
            this.checkConsumed();
            try {
                Name fakeName = RepositoryServiceImpl.this.getNameFactory().create("", UUID.randomUUID().toString());
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, fakeName, this.sessionInfo);
                MkColMethod method = new MkColMethod(uri);
                Document body = DomUtil.createDocument();
                Element nodeElement = DomUtil.addChildElement((Node)body, (String)RepositoryServiceImpl.NODE_ELEMENT, (Namespace)SV_NAMESPACE);
                String nameAttr = this.resolver.getJCRName(nodeName);
                DomUtil.setAttribute((Element)nodeElement, (String)RepositoryServiceImpl.NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)nameAttr);
                Element propElement = DomUtil.addChildElement((Element)nodeElement, (String)RepositoryServiceImpl.PROPERTY_ELEMENT, (Namespace)SV_NAMESPACE);
                String name = this.resolver.getJCRName(NameConstants.JCR_PRIMARYTYPE);
                DomUtil.setAttribute((Element)propElement, (String)RepositoryServiceImpl.NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)name);
                DomUtil.setAttribute((Element)propElement, (String)RepositoryServiceImpl.TYPE_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)PropertyType.nameFromValue((int)7));
                name = this.resolver.getJCRName(nodetypeName);
                DomUtil.addChildElement((Element)propElement, (String)RepositoryServiceImpl.VALUE_ELEMENT, (Namespace)SV_NAMESPACE, (String)name);
                if (uuid != null) {
                    propElement = DomUtil.addChildElement((Element)nodeElement, (String)RepositoryServiceImpl.PROPERTY_ELEMENT, (Namespace)SV_NAMESPACE);
                    name = this.resolver.getJCRName(NameConstants.JCR_UUID);
                    DomUtil.setAttribute((Element)propElement, (String)RepositoryServiceImpl.NAME_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)name);
                    DomUtil.setAttribute((Element)propElement, (String)RepositoryServiceImpl.TYPE_ATTRIBUTE, (Namespace)SV_NAMESPACE, (String)PropertyType.nameFromValue((int)1));
                    DomUtil.addChildElement((Element)propElement, (String)RepositoryServiceImpl.VALUE_ELEMENT, (Namespace)SV_NAMESPACE, (String)uuid);
                }
                method.setRequestBody(body);
                this.methods.add((DavMethod)method);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
            catch (ParserConfigurationException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue value) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(parentId, propertyName, this.sessionInfo);
            PutMethod method = new PutMethod(uri);
            method.setRequestHeader("Content-Type", JcrValueType.contentTypeFromType((int)value.getType()));
            method.setRequestEntity(this.getEntity(value));
            this.methods.add((DavMethod)method);
        }

        public void addProperty(NodeId parentId, Name propertyName, QValue[] values) throws RepositoryException {
            this.checkConsumed();
            try {
                String uri = RepositoryServiceImpl.this.getItemUri(parentId, propertyName, this.sessionInfo);
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = ValueFormat.getJCRValue((QValue)values[i], (NamePathResolver)this.resolver, (ValueFactory)RepositoryServiceImpl.this.valueFactory);
                }
                DavProperty vp = RepositoryServiceImpl.createValuesProperty(jcrValues);
                PutMethod method = new PutMethod(uri);
                method.setRequestBody((XmlSerializable)vp);
                this.methods.add((DavMethod)method);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        public void setValue(PropertyId propertyId, QValue value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.checkConsumed();
            if (value == null) {
                this.remove((ItemId)propertyId);
            } else {
                RequestEntity ent = this.getEntity(value);
                String uri = RepositoryServiceImpl.this.getItemUri((ItemId)propertyId, this.sessionInfo);
                PutMethod method = new PutMethod(uri);
                method.setRequestHeader("Content-Type", JcrValueType.contentTypeFromType((int)value.getType()));
                method.setRequestEntity(ent);
                this.methods.add((DavMethod)method);
            }
        }

        public void setValue(PropertyId propertyId, QValue[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.checkConsumed();
            if (values == null) {
                this.remove((ItemId)propertyId);
            } else {
                DavPropertySet setProperties = new DavPropertySet();
                Value[] jcrValues = new Value[values.length];
                for (int i = 0; i < values.length; ++i) {
                    jcrValues[i] = ValueFormat.getJCRValue((QValue)values[i], (NamePathResolver)this.resolver, (ValueFactory)RepositoryServiceImpl.this.valueFactory);
                }
                setProperties.add(RepositoryServiceImpl.createValuesProperty(jcrValues));
                try {
                    String uri = RepositoryServiceImpl.this.getItemUri((ItemId)propertyId, this.sessionInfo);
                    PropPatchMethod method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
                    this.methods.add((DavMethod)method);
                }
                catch (IOException e) {
                    throw new RepositoryException((Throwable)e);
                }
            }
        }

        private RequestEntity getEntity(QValue value) throws RepositoryException {
            InputStreamRequestEntity ent;
            int type = value.getType();
            String contentType = JcrValueType.contentTypeFromType((int)type);
            try {
                switch (type) {
                    case 7: 
                    case 8: {
                        String str = ValueFormat.getJCRString((QValue)value, (NamePathResolver)this.resolver);
                        ent = new StringRequestEntity(str, contentType, "UTF-8");
                        break;
                    }
                    case 2: {
                        InputStream in = value.getStream();
                        ent = new InputStreamRequestEntity(in, contentType);
                        break;
                    }
                    default: {
                        String str = value.getString();
                        ent = new StringRequestEntity(str, contentType, "UTF-8");
                        break;
                    }
                }
            }
            catch (UnsupportedEncodingException e) {
                throw new RepositoryException(e.getMessage());
            }
            return ent;
        }

        public void remove(ItemId itemId) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri(itemId, this.sessionInfo);
            DeleteMethod method = new DeleteMethod(uri);
            this.methods.add((DavMethod)method);
            if (itemId.getPath() == null) {
                this.clear = true;
            }
        }

        public void reorderNodes(NodeId parentId, NodeId srcNodeId, NodeId beforeNodeId) throws RepositoryException {
            this.checkConsumed();
            try {
                OrderPatchMethod method;
                String uri = RepositoryServiceImpl.this.getItemUri((ItemId)parentId, this.sessionInfo);
                String srcUri = RepositoryServiceImpl.this.getItemUri((ItemId)srcNodeId, this.sessionInfo);
                String srcSegment = org.apache.jackrabbit.util.Text.getName((String)srcUri, (boolean)true);
                if (beforeNodeId == null) {
                    method = new OrderPatchMethod(uri, "DAV:custom", srcSegment, false);
                } else {
                    String beforeUri = RepositoryServiceImpl.this.getItemUri((ItemId)beforeNodeId, this.sessionInfo);
                    String targetSegment = org.apache.jackrabbit.util.Text.getName((String)beforeUri, (boolean)true);
                    method = new OrderPatchMethod(uri, "DAV:custom", srcSegment, targetSegment, true);
                }
                this.methods.add((DavMethod)method);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        public void setMixins(NodeId nodeId, Name[] mixinNodeTypeIds) throws NoSuchNodeTypeException, VersionException, ConstraintViolationException, LockException, AccessDeniedException, UnsupportedRepositoryOperationException, RepositoryException {
            this.checkConsumed();
            try {
                DavPropertyNameSet removeProperties;
                DavPropertySet setProperties;
                if (mixinNodeTypeIds == null || mixinNodeTypeIds.length == 0) {
                    setProperties = new DavPropertySet();
                    removeProperties = new DavPropertyNameSet();
                    removeProperties.add("mixinnodetypes", ItemResourceConstants.NAMESPACE);
                } else {
                    String[] ntNames = new String[mixinNodeTypeIds.length];
                    for (int i = 0; i < mixinNodeTypeIds.length; ++i) {
                        ntNames[i] = this.resolver.getJCRName(mixinNodeTypeIds[i]);
                    }
                    setProperties = new DavPropertySet();
                    setProperties.add(RepositoryServiceImpl.createNodeTypeProperty("mixinnodetypes", ntNames));
                    removeProperties = new DavPropertyNameSet();
                }
                String uri = RepositoryServiceImpl.this.getItemUri((ItemId)nodeId, this.sessionInfo);
                PropPatchMethod method = new PropPatchMethod(uri, setProperties, removeProperties);
                this.methods.add((DavMethod)method);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        public void setPrimaryType(NodeId nodeId, Name primaryNodeTypeName) throws RepositoryException {
            this.checkConsumed();
            try {
                DavPropertySet setProperties = new DavPropertySet();
                setProperties.add(RepositoryServiceImpl.createNodeTypeProperty("primarynodetype", new String[]{this.resolver.getJCRName(primaryNodeTypeName)}));
                String uri = RepositoryServiceImpl.this.getItemUri((ItemId)nodeId, this.sessionInfo);
                PropPatchMethod method = new PropPatchMethod(uri, setProperties, new DavPropertyNameSet());
                this.methods.add((DavMethod)method);
            }
            catch (IOException e) {
                throw new RepositoryException((Throwable)e);
            }
        }

        public void move(NodeId srcNodeId, NodeId destParentNodeId, Name destName) throws RepositoryException {
            this.checkConsumed();
            String uri = RepositoryServiceImpl.this.getItemUri((ItemId)srcNodeId, this.sessionInfo);
            String destUri = RepositoryServiceImpl.this.getItemUri(destParentNodeId, destName, this.sessionInfo);
            if (RepositoryServiceImpl.this.isDavClass3(this.sessionInfo)) {
                destUri = RepositoryServiceImpl.obtainAbsolutePathFromUri(destUri);
            }
            MoveMethod method = new MoveMethod(uri, destUri, false);
            this.methods.add((DavMethod)method);
            this.clear = true;
        }
    }
}

