/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.jcr.NamespaceException;
import javax.jcr.Node;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.UnsupportedRepositoryOperationException;
import javax.jcr.nodetype.NodeType;
import javax.jcr.observation.EventIterator;
import javax.jcr.observation.EventListener;
import javax.jcr.observation.ObservationManager;
import org.apache.jackrabbit.spi.Event;
import org.apache.jackrabbit.spi.EventBundle;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.ItemId;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.EventBundleImpl;
import org.apache.jackrabbit.spi.commons.EventFilterImpl;
import org.apache.jackrabbit.spi.commons.EventImpl;
import org.apache.jackrabbit.spi.commons.conversion.NameException;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi2jcr.SessionInfoImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class EventSubscription
implements Subscription,
EventListener {
    private static final Logger log;
    static final int ALL_EVENTS = 31;
    private final List eventBundles = new ArrayList();
    private final IdFactory idFactory;
    private final SessionInfoImpl sessionInfo;
    private volatile List filters;
    private final NamePathResolver resolver;
    private volatile boolean disposed = false;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.apache.jackrabbit.spi2jcr.EventSubscription");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LoggerFactory.getLogger((Class)clazz);
    }

    EventSubscription(IdFactory idFactory, SessionInfoImpl sessionInfo, EventFilter[] filters) throws RepositoryException {
        this.idFactory = idFactory;
        this.sessionInfo = sessionInfo;
        this.resolver = sessionInfo.getNamePathResolver();
        this.setFilters(filters);
        ObservationManager obsMgr = sessionInfo.getSession().getWorkspace().getObservationManager();
        obsMgr.addEventListener((EventListener)this, 31, "/", true, null, null, true);
    }

    SessionInfoImpl getSessionInfo() {
        return this.sessionInfo;
    }

    void setFilters(EventFilter[] filters) throws RepositoryException {
        int i = 0;
        while (i < filters.length) {
            if (!(filters[i] instanceof EventFilterImpl)) {
                throw new RepositoryException("Unknown filter implementation");
            }
            ++i;
        }
        ArrayList<EventFilter> tmp = new ArrayList<EventFilter>(Arrays.asList(filters));
        this.filters = Collections.unmodifiableList(tmp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void dispose() throws RepositoryException {
        this.sessionInfo.removeSubscription(this);
        this.sessionInfo.getSession().getWorkspace().getObservationManager().removeEventListener((EventListener)this);
        this.disposed = true;
        List list = this.eventBundles;
        synchronized (list) {
            this.eventBundles.notify();
        }
    }

    public void onEvent(EventIterator events) {
        this.createEventBundle(events, false);
    }

    EventListener getLocalEventListener() {
        return new EventListener(){

            public void onEvent(EventIterator events) {
                EventSubscription.this.createEventBundle(events, true);
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EventBundle[] getEventBundles(long timeout) {
        EventBundle[] bundles;
        List list = this.eventBundles;
        synchronized (list) {
            if (this.eventBundles.isEmpty()) {
                try {
                    this.eventBundles.wait(timeout);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            bundles = this.eventBundles.toArray(new EventBundle[this.eventBundles.size()]);
            this.eventBundles.clear();
        }
        EventFilter[] eventFilters = this.filters.toArray(new EventFilter[this.filters.size()]);
        int i = 0;
        while (i < bundles.length) {
            ArrayList<Event> filteredEvents = new ArrayList<Event>();
            Iterator it = bundles[i].getEvents();
            block6: while (it.hasNext()) {
                Event e = (Event)it.next();
                if (eventFilters == null || eventFilters.length == 0) {
                    filteredEvents.add(e);
                    continue;
                }
                int j = 0;
                while (j < eventFilters.length) {
                    if (eventFilters[j].accept(e, bundles[i].isLocal())) {
                        filteredEvents.add(e);
                        continue block6;
                    }
                    ++j;
                }
            }
            bundles[i] = new EventBundleImpl(filteredEvents, bundles[i].isLocal());
            ++i;
        }
        return bundles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createEventBundle(EventIterator events, boolean isLocal) {
        if (this.disposed) {
            return;
        }
        ArrayList<EventImpl> spiEvents = new ArrayList<EventImpl>();
        while (events.hasNext()) {
            try {
                Session session = this.sessionInfo.getSession();
                javax.jcr.observation.Event e = events.nextEvent();
                Path p = this.resolver.getQPath(e.getPath());
                Path parent = p.getAncestor(1);
                NodeId parentId = this.idFactory.createNodeId(null, parent);
                NodeId itemId = null;
                Node node = null;
                switch (e.getType()) {
                    case 1: {
                        node = session.getItem(e.getPath()).getParent();
                    }
                    case 2: {
                        itemId = this.idFactory.createNodeId(null, p);
                        break;
                    }
                    case 4: 
                    case 16: {
                        node = session.getItem(e.getPath()).getParent();
                    }
                    case 8: {
                        itemId = this.idFactory.createPropertyId(parentId, p.getNameElement().getName());
                    }
                }
                Name nodeTypeName = null;
                Name[] mixinTypes = new Name[]{};
                if (node != null) {
                    try {
                        parentId = this.idFactory.createNodeId(node.getUUID(), null);
                    }
                    catch (UnsupportedRepositoryOperationException unsupportedRepositoryOperationException) {
                        // empty catch block
                    }
                    nodeTypeName = this.resolver.getQName(node.getPrimaryNodeType().getName());
                    mixinTypes = EventSubscription.getNodeTypeNames(node.getMixinNodeTypes(), (NameResolver)this.resolver);
                }
                EventImpl spiEvent = new EventImpl(e.getType(), p, (ItemId)itemId, parentId, nodeTypeName, mixinTypes, e.getUserID());
                spiEvents.add(spiEvent);
            }
            catch (Exception ex) {
                log.warn("Unable to create SPI Event: " + ex);
            }
        }
        EventBundleImpl bundle = new EventBundleImpl(spiEvents, isLocal);
        List list = this.eventBundles;
        synchronized (list) {
            this.eventBundles.add(bundle);
            this.eventBundles.notify();
        }
    }

    private static Name[] getNodeTypeNames(NodeType[] nt, NameResolver resolver) throws NameException, NamespaceException {
        Name[] names = new Name[nt.length];
        int i = 0;
        while (i < nt.length) {
            Name ntName;
            names[i] = ntName = resolver.getQName(nt[i].getName());
            ++i;
        }
        return names;
    }
}

