/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.jcr.Credentials;
import javax.jcr.NamespaceException;
import javax.jcr.NamespaceRegistry;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.spi.EventFilter;
import org.apache.jackrabbit.spi.IdFactory;
import org.apache.jackrabbit.spi.NameFactory;
import org.apache.jackrabbit.spi.PathFactory;
import org.apache.jackrabbit.spi.SessionInfo;
import org.apache.jackrabbit.spi.Subscription;
import org.apache.jackrabbit.spi.commons.conversion.DefaultNamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.conversion.NameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingNameResolver;
import org.apache.jackrabbit.spi.commons.conversion.ParsingPathResolver;
import org.apache.jackrabbit.spi.commons.conversion.PathResolver;
import org.apache.jackrabbit.spi.commons.namespace.NamespaceResolver;
import org.apache.jackrabbit.spi2jcr.EventSubscription;

class SessionInfoImpl
implements SessionInfo {
    private final Session session;
    private final NamePathResolver resolver;
    private Credentials credentials;
    private List subscriptions = Collections.EMPTY_LIST;
    private Object subscriptionChange = new Object();

    SessionInfoImpl(Session session, Credentials credentials, NameFactory nameFactory, PathFactory pathFactory) throws RepositoryException {
        this.session = session;
        this.credentials = credentials;
        final NamespaceRegistry nsReg = session.getWorkspace().getNamespaceRegistry();
        NamespaceResolver nsResolver = new NamespaceResolver(){

            public String getPrefix(String uri) throws NamespaceException {
                try {
                    return nsReg.getPrefix(uri);
                }
                catch (RepositoryException e) {
                    throw new NamespaceException("internal error: failed to resolve namespace uri", (Throwable)e);
                }
            }

            public String getURI(String prefix) throws NamespaceException {
                try {
                    return nsReg.getURI(prefix);
                }
                catch (RepositoryException e) {
                    throw new NamespaceException("internal error: failed to resolve namespace prefix", (Throwable)e);
                }
            }
        };
        ParsingNameResolver nResolver = new ParsingNameResolver(nameFactory, nsResolver);
        ParsingPathResolver pResolver = new ParsingPathResolver(pathFactory, (NameResolver)nResolver);
        this.resolver = new DefaultNamePathResolver((NameResolver)nResolver, (PathResolver)pResolver);
    }

    Session getSession() {
        return this.session;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    Credentials getCredentials() throws RepositoryException {
        return SessionInfoImpl.duplicateCredentials(this.credentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Collection getSubscriptions() {
        Object object = this.subscriptionChange;
        synchronized (object) {
            return this.subscriptions;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Subscription createSubscription(IdFactory idFactory, EventFilter[] filters) throws RepositoryException {
        Object object = this.subscriptionChange;
        synchronized (object) {
            ArrayList<EventSubscription> tmp = new ArrayList<EventSubscription>(this.subscriptions);
            EventSubscription s = new EventSubscription(idFactory, this, filters);
            tmp.add(s);
            this.subscriptions = Collections.unmodifiableList(tmp);
            return s;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSubscription(Subscription subscription) {
        Object object = this.subscriptionChange;
        synchronized (object) {
            ArrayList tmp = new ArrayList(this.subscriptions);
            tmp.remove(subscription);
            this.subscriptions = Collections.unmodifiableList(tmp);
        }
    }

    public static Credentials duplicateCredentials(Credentials credentials) throws RepositoryException {
        if (credentials == null) {
            return null;
        }
        try {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            ObjectOutputStream oOut = new ObjectOutputStream(out);
            oOut.writeObject(credentials);
            oOut.close();
            ByteArrayInputStream in = new ByteArrayInputStream(out.toByteArray());
            ObjectInputStream oIn = new ObjectInputStream(in);
            return (Credentials)oIn.readObject();
        }
        catch (Exception e) {
            throw new RepositoryException((Throwable)e);
        }
    }

    public String getUserID() {
        return this.session.getUserID();
    }

    public String getWorkspaceName() {
        return this.session.getWorkspace().getName();
    }

    public String[] getLockTokens() {
        return this.session.getLockTokens();
    }

    public void addLockToken(String lockToken) {
        this.session.addLockToken(lockToken);
    }

    public void removeLockToken(String lockToken) {
        this.session.removeLockToken(lockToken);
    }
}

