/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.spi2jcr;

import javax.jcr.PropertyType;
import javax.jcr.RepositoryException;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.NodeId;
import org.apache.jackrabbit.spi.QValue;
import org.apache.jackrabbit.spi.Tree;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.spi.commons.tree.AbstractTree;

class XmlTree
extends AbstractTree {
    private final StringBuilder properties = new StringBuilder();

    protected XmlTree(Name nodeName, Name ntName, String uniqueId, NamePathResolver resolver) {
        super(nodeName, ntName, uniqueId, resolver);
    }

    protected Tree createChild(Name name, Name primaryTypeName, String uniqueId) {
        return new XmlTree(name, primaryTypeName, uniqueId, this.getResolver());
    }

    public void addProperty(NodeId parentId, Name propertyName, int propertyType, QValue value) throws RepositoryException {
        this.addProperty(parentId, propertyName, propertyType, new QValue[]{value});
    }

    public void addProperty(NodeId parentId, Name propertyName, int propertyType, QValue[] values) throws RepositoryException {
        this.properties.append("<sv:property sv:name=\"").append(this.getResolver().getJCRName(propertyName)).append("\"");
        this.properties.append(" sv:type=\"").append(PropertyType.nameFromValue((int)propertyType) + "\">");
        for (QValue value : values) {
            this.properties.append("<sv:value>").append(value.getString()).append("</sv:value>");
        }
        this.properties.append("</sv:property>");
    }

    String toXML() throws RepositoryException {
        StringBuilder xml = new StringBuilder("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
        XmlTree.createXMLNodeFragment(xml, this, this.getResolver(), true);
        return xml.toString();
    }

    private static void createXMLNodeFragment(StringBuilder xml, XmlTree tree, NamePathResolver resolver, boolean includeNsInfo) throws RepositoryException {
        xml.append("<sv:node ");
        if (includeNsInfo) {
            xml.append("xmlns:jcr=\"http://www.jcp.org/jcr/1.0\" xmlns:sv=\"http://www.jcp.org/jcr/sv/1.0\" ");
        }
        xml.append("sv:name=\"").append(resolver.getJCRName(tree.getName())).append("\">");
        xml.append("<sv:property sv:name=\"jcr:primaryType\" sv:type=\"Name\">");
        xml.append("<sv:value>").append(resolver.getJCRName(tree.getPrimaryTypeName())).append("</sv:value>");
        xml.append("</sv:property>");
        String uniqueId = tree.getUniqueId();
        if (uniqueId != null) {
            xml.append("<sv:property sv:name=\"jcr:uuid\" sv:type=\"String\">");
            xml.append("<sv:value>").append(uniqueId).append("</sv:value>");
            xml.append("</sv:property>");
        }
        xml.append((CharSequence)tree.properties);
        for (Tree child : tree.getChildren()) {
            XmlTree.createXMLNodeFragment(xml, (XmlTree)child, resolver, false);
        }
        xml.append("</sv:node>");
    }
}

