/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.util.Iterator;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.IndexFormatVersion;
import org.apache.jackrabbit.core.query.lucene.LazyTextExtractorField;
import org.apache.jackrabbit.core.query.lucene.MatchAllQuery;
import org.apache.jackrabbit.core.query.lucene.ReleaseableIndexReader;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Util {
    private static final Logger log = LoggerFactory.getLogger(Util.class);

    public static void disposeDocument(Document old) {
        Iterator it = old.getFields().iterator();
        while (it.hasNext()) {
            Fieldable f = (Fieldable)it.next();
            try {
                if (f.readerValue() != null) {
                    f.readerValue().close();
                    continue;
                }
                if (!(f instanceof LazyTextExtractorField)) continue;
                LazyTextExtractorField field = (LazyTextExtractorField)f;
                field.dispose();
            }
            catch (IOException ex) {
                log.warn("Exception while disposing index document: " + ex);
            }
        }
    }

    public static boolean isDocumentReady(Document doc) {
        Iterator it = doc.getFields().iterator();
        while (it.hasNext()) {
            LazyTextExtractorField field;
            Fieldable f = (Fieldable)it.next();
            if (!(f instanceof LazyTextExtractorField) || (field = (LazyTextExtractorField)f).isExtractorFinished()) continue;
            return false;
        }
        return true;
    }

    public static Query createMatchAllQuery(String name, IndexFormatVersion version) {
        if (version.getVersion() >= IndexFormatVersion.V2.getVersion()) {
            return new TermQuery(new Term(FieldNames.PROPERTIES_SET, name));
        }
        return new MatchAllQuery(name);
    }

    public static IOException createIOException(Throwable t) {
        IOException ex = new IOException(t.getMessage());
        ex.initCause(t);
        return ex;
    }

    public static void closeOrRelease(IndexReader reader) throws IOException {
        if (reader instanceof ReleaseableIndexReader) {
            ((ReleaseableIndexReader)((Object)reader)).release();
        } else {
            reader.close();
        }
    }
}

