/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import EDU.oswego.cs.dl.util.concurrent.ReentrantWriterPreferenceReadWriteLock;
import EDU.oswego.cs.dl.util.concurrent.Sync;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;

public class DefaultISMLocking
implements ISMLocking {
    private final RWLock rwLock = new RWLock();

    public ISMLocking.ReadLock acquireReadLock(ItemId id) throws InterruptedException {
        return new ReadLockImpl(this.rwLock.readLock());
    }

    public ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws InterruptedException {
        return new ISMLocking.WriteLock(){
            {
                DefaultISMLocking.this.rwLock.writeLock().acquire();
            }

            public void release() {
                DefaultISMLocking.this.rwLock.writeLock().release();
            }

            public ISMLocking.ReadLock downgrade() throws InterruptedException {
                ReadLockImpl rLock = new ReadLockImpl(DefaultISMLocking.this.rwLock.readLock());
                this.release();
                return rLock;
            }
        };
    }

    private static final class RWLock
    extends ReentrantWriterPreferenceReadWriteLock {
        private RWLock() {
        }

        protected boolean allowReader() {
            return this.activeWriter_ == null || this.activeWriter_ == Thread.currentThread();
        }
    }

    private static final class ReadLockImpl
    implements ISMLocking.ReadLock {
        private final Sync readLock;

        private ReadLockImpl(Sync readLock) throws InterruptedException {
            this.readLock = readLock;
            this.readLock.acquire();
        }

        public void release() {
            this.readLock.release();
        }
    }
}

