/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.server.io;

import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.apache.jackrabbit.util.Text;

public class MimeResolver {
    private Properties mimeTypes = new Properties();
    private String defaultMimeType = "application/octet-stream";

    public MimeResolver() {
        try {
            this.mimeTypes.load(this.getClass().getResourceAsStream("mimetypes.properties"));
        }
        catch (IOException e) {
            throw new InternalError("Unable to load mimetypes: " + e.toString());
        }
    }

    public MimeResolver(Properties additionalProperties, String defaultMimeType) {
        this();
        if (additionalProperties != null && !additionalProperties.isEmpty()) {
            this.mimeTypes.putAll((Map<?, ?>)additionalProperties);
        }
        if (defaultMimeType != null && defaultMimeType.length() > 0) {
            this.defaultMimeType = defaultMimeType;
        }
    }

    public String getDefaultMimeType() {
        return this.defaultMimeType;
    }

    public void setDefaultMimeType(String defaultMimeType) {
        this.defaultMimeType = defaultMimeType;
    }

    public String getMimeType(String filename) {
        String ext = Text.getName(filename, '.');
        if (ext.equals("")) {
            ext = filename;
        }
        return this.mimeTypes.getProperty(ext.toLowerCase(), this.defaultMimeType);
    }
}

