/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.user;

import java.util.Collections;
import java.util.Set;
import javax.jcr.Node;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.jackrabbit.core.security.user.UserConstants;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class NodeResolver {
    private static final Logger log = LoggerFactory.getLogger(NodeResolver.class);
    private final Session session;
    private final NamePathResolver resolver;

    NodeResolver(Session session, NamePathResolver resolver) throws RepositoryException {
        this.session = session;
        this.resolver = resolver;
    }

    public abstract Node findNode(Name var1, Name var2) throws RepositoryException;

    public abstract Node findNode(Name var1, String var2, Name var3) throws RepositoryException;

    public NodeIterator findNodes(Name propertyName, String value, Name ntName, boolean exact) throws RepositoryException {
        return this.findNodes(Collections.singleton(propertyName), value, ntName, exact, Long.MAX_VALUE);
    }

    public abstract NodeIterator findNodes(Set var1, String var2, Name var3, boolean var4, long var5) throws RepositoryException;

    Session getSession() {
        return this.session;
    }

    NamePathResolver getNamePathResolver() {
        return this.resolver;
    }

    String getSearchRoot(Name ntName) {
        String searchRoot = UserConstants.NT_REP_USER.equals(ntName) ? "/rep:security/rep:authorizables/rep:users" : (UserConstants.NT_REP_GROUP.equals(ntName) ? "/rep:security/rep:authorizables/rep:groups" : "/rep:security/rep:authorizables");
        return searchRoot;
    }
}

