/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.apache.poi.hsmf.MAPIMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsOutlookTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger(MsOutlookTextExtractor.class);

    public MsOutlookTextExtractor() {
        super(new String[]{"application/vnd.ms-outlook"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            MAPIMessage message = new MAPIMessage(stream);
            StringBuffer buffer = new StringBuffer();
            buffer.append(message.getDisplayFrom()).append('\n');
            buffer.append(message.getDisplayTo()).append('\n');
            buffer.append(message.getSubject()).append('\n');
            buffer.append(message.getTextBody());
            StringReader stringReader = new StringReader(buffer.toString());
            return stringReader;
        }
        catch (Exception e) {
            logger.warn("Failed to extract Message content", e);
            StringReader stringReader = new StringReader("");
            return stringReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        MAPIMessage.class.getName();
    }
}

