/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.jcr.Credentials;
import javax.jcr.RepositoryException;
import javax.jcr.Session;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.api.JackrabbitRepository;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.SessionListener;
import org.apache.jackrabbit.core.config.ConfigurationException;
import org.apache.jackrabbit.core.config.RepositoryConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransientRepository
implements JackrabbitRepository,
SessionListener {
    private static final Logger logger;
    private static final String DEFAULT_REPOSITORY_XML = "repository.xml";
    private static final String CONF_PROPERTY = "org.apache.jackrabbit.repository.conf";
    private static final String CONF_DEFAULT = "repository.xml";
    private static final String HOME_PROPERTY = "org.apache.jackrabbit.repository.home";
    private static final String HOME_DEFAULT = "repository";
    private final RepositoryFactory factory;
    private RepositoryImpl repository;
    private final Map sessions = new ReferenceMap(2, 2);
    private final Properties descriptors;
    static final /* synthetic */ boolean $assertionsDisabled;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransientRepository(RepositoryFactory factory) throws IOException {
        this.factory = factory;
        this.repository = null;
        this.descriptors = new Properties();
        InputStream in = RepositoryImpl.class.getResourceAsStream("repository.properties");
        try {
            this.descriptors.load(in);
        }
        finally {
            in.close();
        }
    }

    public TransientRepository() throws IOException {
        this(System.getProperty(CONF_PROPERTY, "repository.xml"), System.getProperty(HOME_PROPERTY, HOME_DEFAULT));
    }

    public TransientRepository(final RepositoryConfig config) throws IOException {
        this(new RepositoryFactory(){

            public RepositoryImpl getRepository() throws RepositoryException {
                return RepositoryImpl.create(config);
            }
        });
    }

    public TransientRepository(final String config, final String home) throws IOException {
        this(new RepositoryFactory(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public RepositoryImpl getRepository() throws RepositoryException {
                try {
                    File homeDir;
                    File configFile = new File(config);
                    if (!configFile.exists()) {
                        logger.info("Copying default configuration to " + config);
                        FileOutputStream output = new FileOutputStream(configFile);
                        try {
                            InputStream input = (class$org$apache$jackrabbit$core$TransientRepository == null ? (class$org$apache$jackrabbit$core$TransientRepository = TransientRepository.class$("org.apache.jackrabbit.core.TransientRepository")) : class$org$apache$jackrabbit$core$TransientRepository).getResourceAsStream("repository.xml");
                            try {
                                IOUtils.copy(input, (OutputStream)output);
                            }
                            finally {
                                input.close();
                            }
                        }
                        finally {
                            ((OutputStream)output).close();
                        }
                    }
                    if (!(homeDir = new File(home)).exists()) {
                        logger.info("Creating repository home directory " + home);
                        homeDir.mkdirs();
                    }
                    RepositoryConfig rc = RepositoryConfig.create(config, home);
                    return RepositoryImpl.create(rc);
                }
                catch (IOException e) {
                    throw new RepositoryException("Automatic repository configuration failed", e);
                }
                catch (ConfigurationException e) {
                    throw new RepositoryException("Invalid repository configuration: " + config, e);
                }
            }
        });
    }

    private synchronized void startRepository() throws RepositoryException {
        if (!($assertionsDisabled || this.repository == null && this.sessions.isEmpty())) {
            throw new AssertionError();
        }
        logger.debug("Initializing transient repository");
        this.repository = this.factory.getRepository();
        logger.info("Transient repository initialized");
    }

    private synchronized void stopRepository() {
        if (!($assertionsDisabled || this.repository != null && this.sessions.isEmpty())) {
            throw new AssertionError();
        }
        logger.debug("Shutting down transient repository");
        this.repository.shutdown();
        logger.info("Transient repository shut down");
        this.repository = null;
    }

    public synchronized String[] getDescriptorKeys() {
        if (this.repository != null) {
            return this.repository.getDescriptorKeys();
        }
        ArrayList<?> keys = Collections.list(this.descriptors.propertyNames());
        Collections.sort(keys);
        return keys.toArray(new String[keys.size()]);
    }

    public synchronized String getDescriptor(String key) {
        if (this.repository != null) {
            return this.repository.getDescriptor(key);
        }
        return this.descriptors.getProperty(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized Session login(Credentials credentials, String workspaceName) throws RepositoryException {
        if (this.sessions.isEmpty()) {
            this.startRepository();
        }
        try {
            logger.debug("Opening a new session");
            SessionImpl session = (SessionImpl)this.repository.login(credentials, workspaceName);
            this.sessions.put(session, session);
            session.addListener(this);
            logger.info("Session opened");
            SessionImpl sessionImpl = session;
            return sessionImpl;
        }
        finally {
            if (this.sessions.isEmpty()) {
                this.stopRepository();
            }
        }
    }

    public Session login(Credentials credentials) throws RepositoryException {
        return this.login(credentials, null);
    }

    public Session login(String workspaceName) throws RepositoryException {
        return this.login(null, workspaceName);
    }

    public Session login() throws RepositoryException {
        return this.login(null, null);
    }

    public synchronized void shutdown() {
        Iterator iterator = new HashSet(this.sessions.keySet()).iterator();
        while (iterator.hasNext()) {
            Session session = (Session)iterator.next();
            session.logout();
        }
    }

    public synchronized void loggedOut(SessionImpl session) {
        if (!$assertionsDisabled && !this.sessions.containsKey(session)) {
            throw new AssertionError();
        }
        this.sessions.remove(session);
        logger.info("Session closed");
        if (this.sessions.isEmpty()) {
            this.repository.loggedOut(session);
            this.stopRepository();
        }
    }

    public void loggingOut(SessionImpl session) {
    }

    static {
        $assertionsDisabled = !TransientRepository.class.desiredAssertionStatus();
        logger = LoggerFactory.getLogger(TransientRepository.class);
    }

    public static interface RepositoryFactory {
        public RepositoryImpl getRepository() throws RepositoryException;
    }
}

