/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.security.authorization.principalbased;

import java.security.Principal;
import java.security.acl.Group;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.jcr.Item;
import javax.jcr.NamespaceException;
import javax.jcr.NodeIterator;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import org.apache.jackrabbit.api.jsr283.security.AccessControlEntry;
import org.apache.jackrabbit.api.jsr283.security.AccessControlException;
import org.apache.jackrabbit.api.jsr283.security.AccessControlManager;
import org.apache.jackrabbit.api.jsr283.security.Privilege;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyImpl;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.security.authorization.AccessControlConstants;
import org.apache.jackrabbit.core.security.authorization.AccessControlEntryImpl;
import org.apache.jackrabbit.core.security.authorization.JackrabbitAccessControlList;
import org.apache.jackrabbit.core.security.authorization.principalbased.GlobPattern;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.conversion.NamePathResolver;
import org.apache.jackrabbit.value.ValueFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ACLTemplate
implements JackrabbitAccessControlList,
AccessControlConstants {
    private static Logger log = LoggerFactory.getLogger(ACLTemplate.class);
    private static final ValueFactory V_FACTORY = ValueFactoryImpl.getInstance();
    static final Name P_NODE_PATH = NF.create("internal", "nodePath");
    static final Name P_GLOB = NF.create("internal", "glob");
    private final Principal principal;
    private final String path;
    private final List entries = new ArrayList();
    private final String jcrNodePathName;
    private final String jcrGlobName;

    ACLTemplate(Principal principal, String path, NamePathResolver resolver) throws RepositoryException {
        this(principal, path, null, resolver);
    }

    ACLTemplate(Principal principal, NodeImpl acNode) throws RepositoryException {
        this(principal, acNode.getPath(), acNode, (SessionImpl)acNode.getSession());
    }

    private ACLTemplate(Principal principal, String path, NodeImpl acNode, NamePathResolver resolver) throws RepositoryException {
        this.principal = principal;
        this.path = path;
        this.jcrNodePathName = resolver.getJCRName(P_NODE_PATH);
        this.jcrGlobName = resolver.getJCRName(P_GLOB);
        if (acNode != null && acNode.hasNode(N_POLICY)) {
            NodeImpl aclNode = acNode.getNode(N_POLICY);
            AccessControlManager acMgr = ((SessionImpl)aclNode.getSession()).getAccessControlManager();
            NodeIterator aceNodes = aclNode.getNodes();
            while (aceNodes.hasNext()) {
                NodeImpl aceNode = (NodeImpl)aceNodes.nextNode();
                if (aceNode.isNodeType(NT_REP_ACE)) {
                    boolean isAllow = aceNode.isNodeType(NT_REP_GRANT_ACE);
                    Value[] pValues = aceNode.getProperty(P_PRIVILEGES).getValues();
                    Privilege[] privileges = new Privilege[pValues.length];
                    for (int i = 0; i < pValues.length; ++i) {
                        privileges[i] = acMgr.privilegeFromName(pValues[i].getString());
                    }
                    HashMap<String, Value> restrictions = new HashMap<String, Value>(2);
                    PropertyImpl prop = aceNode.getProperty(P_NODE_PATH);
                    restrictions.put(prop.getName(), prop.getValue());
                    if (aceNode.hasProperty(P_GLOB)) {
                        prop = aceNode.getProperty(P_GLOB);
                        restrictions.put(prop.getName(), prop.getValue());
                    }
                    Entry entry = new Entry(principal, privileges, isAllow, restrictions);
                    this.entries.add(entry);
                    continue;
                }
                log.warn("ACE must be of nodetype rep:ACE -> ignored child-node " + aceNode.getPath());
            }
        }
    }

    public String getPath() {
        return this.path;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public int size() {
        return this.entries.size();
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, isAllow, null);
    }

    public boolean addEntry(Principal principal, Privilege[] privileges, boolean isAllow, Map restrictions) throws AccessControlException, RepositoryException {
        Entry entry;
        if (restrictions == null || restrictions.isEmpty()) {
            log.debug("Restrictions missing. Using default: rep:nodePath = " + this.getPath() + "; rep:glob = null.");
            restrictions = Collections.singletonMap(this.jcrNodePathName, V_FACTORY.createValue(this.getPath(), 8));
        }
        if (this.entries.contains(entry = new Entry(principal, privileges, isAllow, restrictions))) {
            log.debug("Entry is already contained in policy -> no modification.");
            return false;
        }
        this.entries.add(0, entry);
        return true;
    }

    public AccessControlEntry[] getAccessControlEntries() throws RepositoryException {
        return this.entries.toArray(new Entry[this.entries.size()]);
    }

    public boolean addAccessControlEntry(Principal principal, Privilege[] privileges) throws AccessControlException, RepositoryException {
        return this.addEntry(principal, privileges, true, Collections.EMPTY_MAP);
    }

    public void removeAccessControlEntry(AccessControlEntry ace) throws AccessControlException, RepositoryException {
        if (!(ace instanceof Entry)) {
            throw new AccessControlException("Invalid AccessControlEntry implementation " + ace.getClass().getName() + ".");
        }
        if (!this.entries.remove(ace)) {
            throw new AccessControlException("Cannot remove AccessControlEntry " + ace);
        }
    }

    public int hashCode() {
        return 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ACLTemplate) {
            ACLTemplate acl = (ACLTemplate)obj;
            return ((Object)this.principal).equals(acl.principal) && this.path.equals(acl.path) && ((Object)this.entries).equals(acl.entries);
        }
        return false;
    }

    class Entry
    extends AccessControlEntryImpl {
        private final String nodePath;
        private final GlobPattern pattern;

        Entry(Principal principal, Privilege[] privileges, boolean allow, Map restrictions) throws AccessControlException, RepositoryException {
            super(principal, privileges, allow, restrictions);
            this.checkValidEntry();
            this.nodePath = this.getRestriction(ACLTemplate.this.jcrNodePathName).getString();
            Value glob = this.getRestriction(ACLTemplate.this.jcrGlobName);
            if (glob != null) {
                StringBuffer b = new StringBuffer(this.nodePath);
                b.append(glob.getString());
                this.pattern = GlobPattern.create(b.toString());
            } else {
                this.pattern = GlobPattern.create(this.nodePath);
            }
        }

        private void checkValidEntry() throws AccessControlException, NamespaceException {
            if (!((Object)ACLTemplate.this.principal).equals(this.getPrincipal())) {
                throw new AccessControlException("Invalid principal. Expected: " + ACLTemplate.this.principal);
            }
            if (!this.isAllow() && this.getPrincipal() instanceof Group) {
                throw new AccessControlException("For group principals permissions can only be added but not denied.");
            }
            String[] rNames = this.getRestrictionNames();
            if (!Arrays.asList(rNames).contains(ACLTemplate.this.jcrNodePathName)) {
                throw new AccessControlException("Missing mandatory restriction: " + ACLTemplate.this.jcrNodePathName);
            }
        }

        boolean matches(String jcrPath) throws RepositoryException {
            return this.pattern.matches(jcrPath);
        }

        boolean matches(Item item) throws RepositoryException {
            return this.pattern.matches(item);
        }

        boolean matchesNodePath(String jcrPath) {
            return this.nodePath.equals(jcrPath);
        }
    }
}

