/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.state;

import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.jcr.ReferentialIntegrityException;
import javax.jcr.RepositoryException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.NoSuchNodeTypeException;
import org.apache.jackrabbit.core.ItemId;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.RepositoryImpl;
import org.apache.jackrabbit.core.cluster.UpdateEventChannel;
import org.apache.jackrabbit.core.nodetype.EffectiveNodeType;
import org.apache.jackrabbit.core.nodetype.NodeDef;
import org.apache.jackrabbit.core.nodetype.NodeDefId;
import org.apache.jackrabbit.core.nodetype.NodeTypeConflictException;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.observation.EventStateCollection;
import org.apache.jackrabbit.core.observation.EventStateCollectionFactory;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.persistence.bundle.CachingPersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateCache;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.ItemStateManager;
import org.apache.jackrabbit.core.state.ItemStateReferenceCache;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.state.NodeStateMerger;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.state.StaleItemStateException;
import org.apache.jackrabbit.core.state.StateChangeDispatcher;
import org.apache.jackrabbit.core.util.Dumpable;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.uuid.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SharedItemStateManager
implements ItemStateManager,
ItemStateListener,
Dumpable {
    private static Logger log = LoggerFactory.getLogger(SharedItemStateManager.class);
    private final ItemStateCache cache;
    private final PersistenceManager persistMgr;
    private final NodeTypeRegistry ntReg;
    private final boolean usesReferences;
    private boolean checkReferences = true;
    private final NodeId rootNodeId;
    private VirtualItemStateProvider[] virtualProviders = new VirtualItemStateProvider[0];
    private final transient StateChangeDispatcher dispatcher = new StateChangeDispatcher();
    private ISMLocking ismLocking;
    private UpdateEventChannel eventChannel;

    public SharedItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, boolean usesReferences, ItemStateCacheFactory cacheFactory, ISMLocking locking) throws ItemStateException {
        this.cache = new ItemStateReferenceCache(cacheFactory);
        this.persistMgr = persistMgr;
        this.ntReg = ntReg;
        this.usesReferences = usesReferences;
        this.rootNodeId = rootNodeId;
        this.ismLocking = locking;
        if (!this.hasNonVirtualItemState(rootNodeId)) {
            this.createRootNodeState(rootNodeId, ntReg);
        }
    }

    public void setCheckReferences(boolean checkReferences) {
        this.checkReferences = checkReferences;
    }

    public void setEventChannel(UpdateEventChannel eventChannel) {
        this.eventChannel = eventChannel;
    }

    public void setISMLocking(ISMLocking ismLocking) {
        if (ismLocking == null) {
            throw new NullPointerException();
        }
        this.ismLocking = ismLocking;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        for (int i = 0; i < this.virtualProviders.length; ++i) {
            if (!this.virtualProviders[i].isVirtualRoot(id)) continue;
            return this.virtualProviders[i].getItemState(id);
        }
        ISMLocking.ReadLock readLock = this.acquireReadLock(id);
        try {
            if (this.hasNonVirtualItemState(id)) {
                ItemState itemState = this.getNonVirtualItemState(id);
                return itemState;
            }
        }
        finally {
            readLock.release();
        }
        for (int i = 0; i < this.virtualProviders.length; ++i) {
            if (!this.virtualProviders[i].hasItemState(id)) continue;
            return this.virtualProviders[i].getItemState(id);
        }
        throw new NoSuchItemStateException(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasItemState(ItemId id) {
        ISMLocking.ReadLock readLock;
        for (int i = 0; i < this.virtualProviders.length; ++i) {
            if (!this.virtualProviders[i].isVirtualRoot(id)) continue;
            return true;
        }
        try {
            readLock = this.acquireReadLock(id);
        }
        catch (ItemStateException e) {
            return false;
        }
        try {
            if (this.cache.isCached(id)) {
                boolean e = true;
                return e;
            }
            if (this.hasNonVirtualItemState(id)) {
                boolean e = true;
                return e;
            }
        }
        finally {
            readLock.release();
        }
        for (int i = 0; i < this.virtualProviders.length; ++i) {
            if (!this.virtualProviders[i].hasItemState(id)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        ISMLocking.ReadLock readLock = this.acquireReadLock(id.getTargetId());
        try {
            NodeReferences nodeReferences = this.persistMgr.load(id);
            return nodeReferences;
        }
        catch (NoSuchItemStateException e) {
        }
        finally {
            readLock.release();
        }
        for (int i = 0; i < this.virtualProviders.length; ++i) {
            try {
                return this.virtualProviders[i].getNodeReferences(id);
            }
            catch (NoSuchItemStateException e) {
                continue;
            }
        }
        throw new NoSuchItemStateException(id.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean hasNodeReferences(NodeReferencesId id) {
        ISMLocking.ReadLock readLock;
        try {
            readLock = this.acquireReadLock(id.getTargetId());
        }
        catch (ItemStateException e) {
            return false;
        }
        try {
            if (this.persistMgr.exists(id)) {
                boolean e = true;
                readLock.release();
                return e;
            }
        }
        catch (ItemStateException e) {
            // empty catch block
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        int i = 0;
        while (i < this.virtualProviders.length) {
            if (this.virtualProviders[i].hasNodeReferences(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void stateCreated(ItemState created) {
        if (created.getContainer() == this) {
            this.cache.cache(created);
        }
        this.dispatcher.notifyStateCreated(created);
    }

    public void stateModified(ItemState modified) {
        this.dispatcher.notifyStateModified(modified);
    }

    public void stateDestroyed(ItemState destroyed) {
        if (destroyed.getContainer() == this) {
            this.cache.evict(destroyed.getId());
        }
        this.dispatcher.notifyStateDestroyed(destroyed);
    }

    public void stateDiscarded(ItemState discarded) {
        if (discarded.getContainer() == this) {
            this.cache.evict(discarded.getId());
        }
        this.dispatcher.notifyStateDiscarded(discarded);
    }

    public void dump(PrintStream ps) {
        ps.println("SharedItemStateManager (" + this + ")");
        if (this.cache instanceof Dumpable) {
            ps.println();
            ps.print("[referenceCache] ");
            ((Dumpable)((Object)this.cache)).dump(ps);
        }
    }

    public void dispose() {
        for (int i = 0; i < this.virtualProviders.length; ++i) {
            this.virtualProviders[i].removeListener(this);
        }
        this.virtualProviders = new VirtualItemStateProvider[0];
        this.cache.evictAll();
    }

    public void addVirtualItemStateProvider(VirtualItemStateProvider prov) {
        VirtualItemStateProvider[] provs = new VirtualItemStateProvider[this.virtualProviders.length + 1];
        System.arraycopy(this.virtualProviders, 0, provs, 0, this.virtualProviders.length);
        provs[this.virtualProviders.length] = prov;
        this.virtualProviders = provs;
        prov.addListener(this);
    }

    public Update beginUpdate(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        Update update = new Update(local, factory, virtualProvider);
        update.begin();
        return update;
    }

    public void update(ChangeLog local, EventStateCollectionFactory factory) throws ReferentialIntegrityException, StaleItemStateException, ItemStateException {
        this.beginUpdate(local, factory, null).end();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void externalUpdate(ChangeLog external, EventStateCollection events) {
        boolean holdingWriteLock = false;
        ISMLocking.WriteLock wLock = null;
        try {
            wLock = this.acquireWriteLock(external);
            holdingWriteLock = true;
            this.doExternalUpdate(external);
        }
        catch (ItemStateException e) {
            String msg = "Unable to acquire write lock.";
            log.error(msg);
        }
        ISMLocking.ReadLock rLock = null;
        try {
            if (wLock != null) {
                rLock = wLock.downgrade();
                holdingWriteLock = false;
                events.dispatch();
            }
        }
        catch (InterruptedException e) {
            String msg = "Unable to downgrade to read lock.";
            log.error(msg);
        }
        finally {
            if (holdingWriteLock) {
                if (wLock != null) {
                    wLock.release();
                }
            } else if (rLock != null) {
                rLock.release();
            }
        }
    }

    protected void doExternalUpdate(ChangeLog external) {
        if (this.persistMgr instanceof CachingPersistenceManager) {
            ((CachingPersistenceManager)((Object)this.persistMgr)).onExternalUpdate(external);
        }
        ChangeLog shared = new ChangeLog();
        Iterator modifiedStates = external.modifiedStates();
        while (modifiedStates.hasNext()) {
            String msg;
            ItemState state = (ItemState)modifiedStates.next();
            if ((state = this.cache.retrieve(state.getId())) == null) continue;
            try {
                ItemState currentState = this.loadItemState(state.getId());
                state.copy(currentState, true);
                shared.modified(state);
            }
            catch (NoSuchItemStateException e) {
                msg = "Unable to retrieve state: " + state.getId() + ", ignored.";
                log.info(msg);
                state.discard();
            }
            catch (ItemStateException e) {
                msg = "Unable to retrieve state: " + state.getId();
                log.warn(msg);
                state.discard();
            }
        }
        Iterator deletedStates = external.deletedStates();
        while (deletedStates.hasNext()) {
            ItemState state = (ItemState)deletedStates.next();
            if ((state = this.cache.retrieve(state.getId())) == null) continue;
            shared.deleted(state);
        }
        shared.persisted();
    }

    public void addListener(ItemStateListener listener) {
        this.dispatcher.addListener(listener);
    }

    public void removeListener(ItemStateListener listener) {
        this.dispatcher.removeListener(listener);
    }

    private NodeState createInstance(NodeId id, Name nodeTypeName, NodeId parentId) {
        NodeState state = this.persistMgr.createNew(id);
        state.setNodeTypeName(nodeTypeName);
        state.setParentId(parentId);
        state.setStatus(4);
        state.setContainer(this);
        return state;
    }

    private NodeState createRootNodeState(NodeId rootNodeId, NodeTypeRegistry ntReg) throws ItemStateException {
        NodeDefId jcrSystemDefId;
        PropDef propDef;
        NodeDefId nodeDefId;
        NodeState rootState = this.createInstance(rootNodeId, NameConstants.REP_ROOT, null);
        NodeState jcrSystemState = this.createInstance(RepositoryImpl.SYSTEM_ROOT_NODE_ID, NameConstants.REP_SYSTEM, rootNodeId);
        try {
            nodeDefId = ntReg.getRootNodeDef().getId();
            EffectiveNodeType ent = ntReg.getEffectiveNodeType(NameConstants.REP_ROOT);
            propDef = ent.getApplicablePropertyDef(NameConstants.JCR_PRIMARYTYPE, 7, false);
            jcrSystemDefId = ent.getApplicableChildNodeDef(NameConstants.JCR_SYSTEM, NameConstants.REP_SYSTEM, ntReg).getId();
        }
        catch (NoSuchNodeTypeException nsnte) {
            String msg = "internal error: failed to create root node";
            log.error(msg, nsnte);
            throw new ItemStateException(msg, nsnte);
        }
        catch (ConstraintViolationException cve) {
            String msg = "internal error: failed to create root node";
            log.error(msg, cve);
            throw new ItemStateException(msg, cve);
        }
        rootState.setDefinitionId(nodeDefId);
        jcrSystemState.setDefinitionId(jcrSystemDefId);
        rootState.addPropertyName(propDef.getName());
        PropertyState prop = this.createInstance(propDef.getName(), rootNodeId);
        prop.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_ROOT)});
        prop.setType(propDef.getRequiredType());
        prop.setMultiValued(propDef.isMultiple());
        prop.setDefinitionId(propDef.getId());
        jcrSystemState.addPropertyName(propDef.getName());
        PropertyState primaryTypeProp = this.createInstance(propDef.getName(), jcrSystemState.getNodeId());
        primaryTypeProp.setValues(new InternalValue[]{InternalValue.create(NameConstants.REP_SYSTEM)});
        primaryTypeProp.setType(propDef.getRequiredType());
        primaryTypeProp.setMultiValued(propDef.isMultiple());
        primaryTypeProp.setDefinitionId(propDef.getId());
        rootState.addChildNodeEntry(NameConstants.JCR_SYSTEM, RepositoryImpl.SYSTEM_ROOT_NODE_ID);
        jcrSystemState.addChildNodeEntry(NameConstants.JCR_VERSIONSTORAGE, RepositoryImpl.VERSION_STORAGE_NODE_ID);
        jcrSystemState.addChildNodeEntry(NameConstants.JCR_NODETYPES, RepositoryImpl.NODETYPES_NODE_ID);
        ChangeLog changeLog = new ChangeLog();
        changeLog.added(rootState);
        changeLog.added(prop);
        changeLog.added(jcrSystemState);
        changeLog.added(primaryTypeProp);
        this.persistMgr.store(changeLog);
        changeLog.persisted();
        return rootState;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ItemState getNonVirtualItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemStateCache itemStateCache = this.cache;
        synchronized (itemStateCache) {
            ItemState state = this.cache.retrieve(id);
            if (state == null) {
                state = this.loadItemState(id);
                state.setStatus(1);
                this.cache.cache(state);
                state.setContainer(this);
            }
            return state;
        }
    }

    protected boolean hasNonVirtualItemState(ItemId id) {
        if (this.cache.isCached(id)) {
            return true;
        }
        try {
            if (id.denotesNode()) {
                return this.persistMgr.exists((NodeId)id);
            }
            return this.persistMgr.exists((PropertyId)id);
        }
        catch (ItemStateException ise) {
            return false;
        }
    }

    private ItemState createInstance(ItemState other) {
        if (other.isNode()) {
            NodeState ns = (NodeState)other;
            return this.createInstance(ns.getNodeId(), ns.getNodeTypeName(), ns.getParentId());
        }
        PropertyState ps = (PropertyState)other;
        return this.createInstance(ps.getName(), ps.getParentId());
    }

    private PropertyState createInstance(Name propName, NodeId parentId) {
        PropertyState state = this.persistMgr.createNew(new PropertyId(parentId, propName));
        state.setStatus(4);
        state.setContainer(this);
        return state;
    }

    private ItemState loadItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState state = id.denotesNode() ? this.persistMgr.load((NodeId)id) : this.persistMgr.load((PropertyId)id);
        return state;
    }

    private ISMLocking.ReadLock acquireReadLock(ItemId id) throws ItemStateException {
        try {
            return this.ismLocking.acquireReadLock(id);
        }
        catch (InterruptedException e) {
            throw new ItemStateException("Interrupted while acquiring read lock");
        }
    }

    private ISMLocking.WriteLock acquireWriteLock(ChangeLog changeLog) throws ItemStateException {
        try {
            return this.ismLocking.acquireWriteLock(changeLog);
        }
        catch (InterruptedException e) {
            throw new ItemStateException("Interrupted while acquiring write lock");
        }
    }

    class Update
    implements org.apache.jackrabbit.core.cluster.Update {
        private final ChangeLog local;
        private final EventStateCollectionFactory factory;
        private final VirtualItemStateProvider virtualProvider;
        private ChangeLog shared;
        private ChangeLog[] virtualNodeReferences;
        private EventStateCollection events;
        private ISMLocking.WriteLock writeLock;
        private HashMap attributes;

        public Update(ChangeLog local, EventStateCollectionFactory factory, VirtualItemStateProvider virtualProvider) {
            this.local = local;
            this.factory = factory;
            this.virtualProvider = virtualProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void begin() throws ItemStateException, ReferentialIntegrityException {
            this.shared = new ChangeLog();
            this.virtualNodeReferences = new ChangeLog[SharedItemStateManager.this.virtualProviders.length];
            if (SharedItemStateManager.this.eventChannel != null) {
                SharedItemStateManager.this.eventChannel.updateCreated(this);
            }
            try {
                this.writeLock = SharedItemStateManager.this.acquireWriteLock(this.local);
            }
            finally {
                if (this.writeLock == null && SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updateCancelled(this);
                }
            }
            boolean succeeded = false;
            try {
                ItemState state;
                if (SharedItemStateManager.this.usesReferences) {
                    this.updateReferences();
                }
                if (SharedItemStateManager.this.checkReferences) {
                    this.checkReferentialIntegrity();
                }
                try {
                    this.events = this.factory.createEventStateCollection();
                }
                catch (RepositoryException e) {
                    String msg = "Unable to create event state collection.";
                    log.error(msg);
                    throw new ItemStateException(msg, e);
                }
                Iterator iter = this.local.modifiedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.connect(SharedItemStateManager.this.getItemState(state.getId()));
                    if (state.isStale()) {
                        boolean merged = false;
                        if (state.isNode()) {
                            NodeStateMerger.MergeContext context = new NodeStateMerger.MergeContext(){

                                public boolean isAdded(ItemId id) {
                                    try {
                                        ItemState is = Update.this.local.get(id);
                                        return is != null && is.getStatus() == 4;
                                    }
                                    catch (NoSuchItemStateException e) {
                                        return false;
                                    }
                                }

                                public boolean isDeleted(ItemId id) {
                                    return Update.this.local.deleted(id);
                                }

                                public boolean allowsSameNameSiblings(NodeId id) {
                                    NodeState ns;
                                    try {
                                        ns = Update.this.local.has(id) ? (NodeState)Update.this.local.get(id) : (NodeState)SharedItemStateManager.this.getItemState(id);
                                    }
                                    catch (ItemStateException e) {
                                        return false;
                                    }
                                    NodeDef def = SharedItemStateManager.this.ntReg.getNodeDef(ns.getDefinitionId());
                                    return def != null ? def.allowsSameNameSiblings() : false;
                                }
                            };
                            merged = NodeStateMerger.merge((NodeState)state, context);
                        }
                        if (!merged) {
                            String msg = state.getId() + " has been modified externally";
                            log.debug(msg);
                            throw new StaleItemStateException(msg);
                        }
                    }
                    state.getOverlayedState().touch();
                    this.shared.modified(state.getOverlayedState());
                }
                iter = this.local.deletedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.connect(SharedItemStateManager.this.getItemState(state.getId()));
                    if (state.isStale()) {
                        String msg = state.getId() + " has been modified externally";
                        log.debug(msg);
                        throw new StaleItemStateException(msg);
                    }
                    this.shared.deleted(state.getOverlayedState());
                }
                iter = this.local.addedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.connect(SharedItemStateManager.this.createInstance(state));
                    this.shared.added(state.getOverlayedState());
                }
                iter = this.local.modifiedRefs();
                while (iter.hasNext()) {
                    NodeReferences refs = (NodeReferences)iter.next();
                    boolean virtual = false;
                    NodeId id = refs.getId().getTargetId();
                    for (int i = 0; i < SharedItemStateManager.this.virtualProviders.length; ++i) {
                        if (!SharedItemStateManager.this.virtualProviders[i].hasItemState(id)) continue;
                        ChangeLog virtualRefs = this.virtualNodeReferences[i];
                        if (virtualRefs == null) {
                            this.virtualNodeReferences[i] = virtualRefs = new ChangeLog();
                        }
                        virtualRefs.modified(refs);
                        virtual = true;
                        break;
                    }
                    if (virtual) continue;
                    this.shared.modified(refs);
                }
                this.events.createEventStates(SharedItemStateManager.this.rootNodeId, this.local, SharedItemStateManager.this);
                if (SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updatePrepared(this);
                }
                this.local.push();
                succeeded = true;
            }
            finally {
                if (!succeeded) {
                    this.cancel();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void end() throws ItemStateException {
            boolean succeeded = false;
            try {
                long t0 = System.currentTimeMillis();
                SharedItemStateManager.this.persistMgr.store(this.shared);
                succeeded = true;
                long t1 = System.currentTimeMillis();
                if (log.isDebugEnabled()) {
                    log.debug("persisting change log " + this.shared + " took " + (t1 - t0) + "ms");
                }
            }
            finally {
                if (!succeeded) {
                    this.cancel();
                }
            }
            ISMLocking.ReadLock readLock = null;
            try {
                this.shared.persisted();
                readLock = this.writeLock.downgrade();
                this.writeLock = null;
                for (int i = 0; i < this.virtualNodeReferences.length; ++i) {
                    ChangeLog virtualRefs = this.virtualNodeReferences[i];
                    if (virtualRefs == null) continue;
                    SharedItemStateManager.this.virtualProviders[i].setNodeReferences(virtualRefs);
                }
                this.events.dispatch();
                if (SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updateCommitted(this);
                }
            }
            catch (InterruptedException e) {
                throw new ItemStateException("Interrupted while downgrading to read lock");
            }
            finally {
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                } else if (readLock != null) {
                    readLock.release();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cancel() {
            try {
                ItemState state;
                if (SharedItemStateManager.this.eventChannel != null) {
                    SharedItemStateManager.this.eventChannel.updateCancelled(this);
                }
                this.local.disconnect();
                Iterator iter = this.shared.modifiedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    try {
                        state.copy(SharedItemStateManager.this.loadItemState(state.getId()), false);
                    }
                    catch (ItemStateException e) {
                        state.discard();
                    }
                }
                iter = this.shared.deletedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    try {
                        state.copy(SharedItemStateManager.this.loadItemState(state.getId()), false);
                    }
                    catch (ItemStateException e) {
                        state.discard();
                    }
                }
                iter = this.shared.addedStates();
                while (iter.hasNext()) {
                    state = (ItemState)iter.next();
                    state.discard();
                }
            }
            finally {
                if (this.writeLock != null) {
                    this.writeLock.release();
                    this.writeLock = null;
                }
            }
        }

        public void setAttribute(String name, Object value) {
            if (this.attributes == null) {
                this.attributes = new HashMap();
            }
            this.attributes.put(name, value);
        }

        public Object getAttribute(String name) {
            if (this.attributes != null) {
                return this.attributes.get(name);
            }
            return null;
        }

        public ChangeLog getChanges() {
            return this.local;
        }

        public List getEvents() {
            return this.events.getEvents();
        }

        private void updateReferences() throws ItemStateException {
            Iterator i = this.local.addedStates();
            while (i.hasNext()) {
                this.addReferences((ItemState)i.next());
            }
            i = this.local.modifiedStates();
            while (i.hasNext()) {
                ItemState state = (ItemState)i.next();
                if (state.isNode()) continue;
                this.removeReferences(SharedItemStateManager.this.getItemState(state.getId()));
                this.addReferences(state);
            }
            i = this.local.deletedStates();
            while (i.hasNext()) {
                this.removeReferences((ItemState)i.next());
            }
        }

        private void addReferences(ItemState state) throws NoSuchItemStateException, ItemStateException {
            PropertyState property;
            if (!state.isNode() && (property = (PropertyState)state).getType() == 9) {
                InternalValue[] values = property.getValues();
                for (int i = 0; values != null && i < values.length; ++i) {
                    this.addReference(property.getPropertyId(), values[i].getUUID());
                }
            }
        }

        private void addReference(PropertyId id, UUID uuid) throws ItemStateException {
            NodeReferencesId refsId = new NodeReferencesId(uuid);
            if (this.virtualProvider == null || !this.virtualProvider.hasNodeReferences(refsId)) {
                NodeReferences refs = this.local.get(refsId);
                if (refs == null) {
                    refs = SharedItemStateManager.this.hasNodeReferences(refsId) ? SharedItemStateManager.this.getNodeReferences(refsId) : new NodeReferences(refsId);
                }
                refs.addReference(id);
                this.local.modified(refs);
            }
        }

        private void removeReferences(ItemState state) throws NoSuchItemStateException, ItemStateException {
            PropertyState property;
            if (!state.isNode() && (property = (PropertyState)state).getType() == 9) {
                InternalValue[] values = property.getValues();
                for (int i = 0; values != null && i < values.length; ++i) {
                    this.removeReference(property.getPropertyId(), values[i].getUUID());
                }
            }
        }

        private void removeReference(PropertyId id, UUID uuid) throws ItemStateException {
            NodeReferencesId refsId = new NodeReferencesId(uuid);
            if (this.virtualProvider == null || !this.virtualProvider.hasNodeReferences(refsId)) {
                NodeReferences refs = this.local.get(refsId);
                if (refs == null && SharedItemStateManager.this.hasNodeReferences(refsId)) {
                    refs = SharedItemStateManager.this.getNodeReferences(refsId);
                }
                if (refs != null) {
                    refs.removeReference(id);
                    this.local.modified(refs);
                }
            }
        }

        private void checkReferentialIntegrity() throws ReferentialIntegrityException, ItemStateException {
            Iterator iter = this.local.deletedStates();
            while (iter.hasNext()) {
                NodeState node;
                ItemState state = (ItemState)iter.next();
                if (!state.isNode() || !this.isReferenceable(node = (NodeState)state)) continue;
                NodeReferencesId refsId = new NodeReferencesId(node.getNodeId());
                NodeReferences refs = this.local.get(refsId);
                if (refs == null) {
                    if (!SharedItemStateManager.this.hasNodeReferences(refsId)) continue;
                    refs = SharedItemStateManager.this.getNodeReferences(refsId);
                }
                if (!refs.hasReferences() || this.local.has(node.getNodeId())) continue;
                String msg = node.getNodeId() + ": the node cannot be removed because it is still being referenced.";
                log.debug(msg);
                throw new ReferentialIntegrityException(msg);
            }
            iter = this.local.modifiedRefs();
            while (iter.hasNext()) {
                NodeReferences refs = (NodeReferences)iter.next();
                NodeId id = refs.getTargetId();
                if (!refs.hasReferences() || this.local.has(id) || SharedItemStateManager.this.hasItemState(id)) continue;
                String msg = "Target node " + id + " of REFERENCE property does not exist";
                log.debug(msg);
                throw new ReferentialIntegrityException(msg);
            }
        }

        private boolean isReferenceable(NodeState state) throws ItemStateException {
            Name primary = state.getNodeTypeName();
            Set mixins = state.getMixinTypeNames();
            if (mixins.contains(NameConstants.MIX_REFERENCEABLE) || mixins.contains(NameConstants.MIX_VERSIONABLE) || primary.equals(NameConstants.NT_RESOURCE)) {
                return true;
            }
            try {
                EffectiveNodeType type = SharedItemStateManager.this.ntReg.getEffectiveNodeType(primary, mixins);
                return type.includesNodeType(NameConstants.MIX_REFERENCEABLE);
            }
            catch (NodeTypeConflictException ntce) {
                String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
                log.debug(msg);
                throw new ItemStateException(msg, ntce);
            }
            catch (NoSuchNodeTypeException nsnte) {
                String msg = "internal error: failed to build effective node type for node " + state.getNodeId();
                log.debug(msg);
                throw new ItemStateException(msg, nsnte);
            }
        }
    }
}

