/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.RepositoryException;
import javax.jcr.Session;
import javax.jcr.Value;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.state.DefaultISMLocking;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.LocalItemStateManager;
import org.apache.jackrabbit.core.state.NodeState;
import org.apache.jackrabbit.core.version.InternalFrozenNodeImpl;
import org.apache.jackrabbit.core.version.InternalFrozenVHImpl;
import org.apache.jackrabbit.core.version.InternalVersion;
import org.apache.jackrabbit.core.version.InternalVersionHistory;
import org.apache.jackrabbit.core.version.InternalVersionHistoryImpl;
import org.apache.jackrabbit.core.version.InternalVersionImpl;
import org.apache.jackrabbit.core.version.InternalVersionItem;
import org.apache.jackrabbit.core.version.NodeStateEx;
import org.apache.jackrabbit.core.version.VersionHistoryInfo;
import org.apache.jackrabbit.core.version.VersionManager;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.spi.commons.name.NameFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractVersionManager
implements VersionManager {
    private static Logger log = LoggerFactory.getLogger(AbstractVersionManager.class);
    protected LocalItemStateManager stateMgr;
    protected final NodeTypeRegistry ntReg;
    protected NodeStateEx historyRoot;
    private final DefaultISMLocking rwLock = new DefaultISMLocking();

    public AbstractVersionManager(NodeTypeRegistry ntReg) {
        this.ntReg = ntReg;
    }

    public InternalVersion getVersion(NodeId id) throws RepositoryException {
        InternalVersion v = (InternalVersion)this.getItem(id);
        if (v == null) {
            log.warn("Versioning item not found: " + id);
        }
        return v;
    }

    public InternalVersionHistory getVersionHistory(NodeId id) throws RepositoryException {
        return (InternalVersionHistory)this.getItem(id);
    }

    protected ISMLocking.WriteLock acquireWriteLock() {
        while (true) {
            try {
                return this.rwLock.acquireWriteLock(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    protected ISMLocking.ReadLock acquireReadLock() {
        while (true) {
            try {
                return this.rwLock.acquireReadLock(null);
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    private WriteOperation startWriteOperation() throws RepositoryException {
        boolean success = false;
        ISMLocking.WriteLock lock = this.acquireWriteLock();
        try {
            this.stateMgr.edit();
            success = true;
            WriteOperation writeOperation = new WriteOperation(lock);
            return writeOperation;
        }
        catch (IllegalStateException e) {
            throw new RepositoryException("Unable to start edit operation.", e);
        }
        finally {
            if (!success) {
                lock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VersionHistoryInfo getVersionHistory(Session session, NodeState node) throws RepositoryException {
        VersionHistoryInfo info = null;
        ISMLocking.ReadLock lock = this.acquireReadLock();
        try {
            String uuid = node.getNodeId().getUUID().toString();
            Name name = this.getName(uuid);
            NodeStateEx parent = this.getParentNode(uuid, false);
            if (parent != null && parent.hasNode(name)) {
                NodeStateEx history = parent.getNode(name, 1);
                Name root = NameConstants.JCR_ROOTVERSION;
                info = new VersionHistoryInfo(history.getNodeId(), history.getState().getChildNodeEntry(root, 1).getId());
            }
        }
        finally {
            lock.release();
        }
        if (info == null) {
            info = this.createVersionHistory(session, node);
        }
        return info;
    }

    protected abstract VersionHistoryInfo createVersionHistory(Session var1, NodeState var2) throws RepositoryException;

    protected abstract InternalVersionItem getItem(NodeId var1) throws RepositoryException;

    protected abstract boolean hasItem(NodeId var1);

    protected abstract boolean hasItemReferences(InternalVersionItem var1) throws RepositoryException;

    NodeStateEx createVersionHistory(NodeState node) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            String uuid = node.getNodeId().getUUID().toString();
            NodeStateEx parent = this.getParentNode(uuid, true);
            Name name = this.getName(uuid);
            if (parent.hasNode(name)) {
                NodeStateEx nodeStateEx = null;
                return nodeStateEx;
            }
            NodeStateEx history = InternalVersionHistoryImpl.create(this, parent, name, node);
            operation.save();
            log.debug("Created new version history " + history.getNodeId() + " for " + node + ".");
            NodeStateEx nodeStateEx = history;
            return nodeStateEx;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            operation.close();
        }
    }

    private Name getName(String name) {
        return NameFactoryImpl.getInstance().create("", name);
    }

    private NodeStateEx getParentNode(String uuid, boolean create) throws RepositoryException {
        NodeStateEx n = this.historyRoot;
        for (int i = 0; i < 3; ++i) {
            Name name = this.getName(uuid.substring(i * 2, i * 2 + 2));
            if (n.hasNode(name)) {
                n = n.getNode(name, 1);
                continue;
            }
            if (create) {
                n.addNode(name, NameConstants.REP_VERSIONSTORAGE, null, false);
                n.store();
                n = n.getNode(name, 1);
                continue;
            }
            return null;
        }
        return n;
    }

    protected InternalVersion checkin(InternalVersionHistoryImpl history, NodeImpl node) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            String versionName = this.calculateCheckinVersionName(history, node);
            InternalVersionImpl v = history.checkin(NameFactoryImpl.getInstance().create("", versionName), node);
            operation.save();
            InternalVersionImpl internalVersionImpl = v;
            return internalVersionImpl;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
        finally {
            operation.close();
        }
    }

    protected String calculateCheckinVersionName(InternalVersionHistoryImpl history, NodeImpl node) throws RepositoryException {
        Value[] values = node.getProperty(NameConstants.JCR_PREDECESSORS).getValues();
        InternalVersion best = null;
        for (int i = 0; i < values.length; ++i) {
            InternalVersion pred = history.getVersion(NodeId.valueOf(values[i].getString()));
            if (best != null && pred.getName().getLocalName().length() >= best.getName().getLocalName().length()) continue;
            best = pred;
        }
        String versionName = best.getName().getLocalName();
        int pos = versionName.lastIndexOf(46);
        if (pos > 0) {
            String newVersionName = versionName.substring(0, pos + 1) + (Integer.parseInt(versionName.substring(pos + 1)) + 1);
            while (history.hasVersion(NameFactoryImpl.getInstance().create("", newVersionName))) {
                newVersionName = versionName = versionName + ".0";
            }
            return newVersionName;
        }
        return String.valueOf(best.getSuccessors().length + 1) + ".0";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeVersion(InternalVersionHistoryImpl history, Name name) throws VersionException, RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            history.removeVersion(name);
            operation.save();
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
        }
        finally {
            operation.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalVersion setVersionLabel(InternalVersionHistoryImpl history, Name version, Name label, boolean move) throws RepositoryException {
        WriteOperation operation = this.startWriteOperation();
        try {
            InternalVersion v = history.setVersionLabel(version, label, move);
            operation.save();
            InternalVersion internalVersion = v;
            return internalVersion;
        }
        catch (ItemStateException e) {
            log.error("Error while storing: " + e.toString());
            InternalVersion internalVersion = null;
            return internalVersion;
        }
        finally {
            operation.close();
        }
    }

    protected void versionCreated(InternalVersion version) {
    }

    protected void versionDestroyed(InternalVersion version) {
    }

    protected void itemDiscarded(InternalVersionItem item) {
    }

    protected InternalVersionItem createInternalVersionItem(NodeId id) throws RepositoryException {
        try {
            if (this.stateMgr.hasItemState(id)) {
                NodeState state = (NodeState)this.stateMgr.getItemState(id);
                NodeStateEx pNode = new NodeStateEx(this.stateMgr, this.ntReg, state, null);
                NodeId parentId = pNode.getParentId();
                InternalVersionItem parent = this.getItem(parentId);
                Name ntName = state.getNodeTypeName();
                if (ntName.equals(NameConstants.NT_FROZENNODE)) {
                    return new InternalFrozenNodeImpl(this, pNode, parent);
                }
                if (ntName.equals(NameConstants.NT_VERSIONEDCHILD)) {
                    return new InternalFrozenVHImpl(this, pNode, parent);
                }
                if (ntName.equals(NameConstants.NT_VERSION)) {
                    return ((InternalVersionHistory)parent).getVersion(id);
                }
                if (ntName.equals(NameConstants.NT_VERSIONHISTORY)) {
                    return new InternalVersionHistoryImpl(this, pNode);
                }
                return null;
            }
            return null;
        }
        catch (ItemStateException e) {
            throw new RepositoryException(e);
        }
    }

    private class WriteOperation {
        private boolean success = false;
        private final ISMLocking.WriteLock lock;

        public WriteOperation(ISMLocking.WriteLock lock) {
            this.lock = lock;
        }

        public void save() throws ItemStateException, RepositoryException {
            AbstractVersionManager.this.stateMgr.update();
            this.success = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            try {
                if (!this.success) {
                    AbstractVersionManager.this.stateMgr.cancel();
                }
            }
            finally {
                this.lock.release();
            }
        }
    }
}

