/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.model.Workbook;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.util.LittleEndian;

public class IntPtg
extends Ptg {
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private int field_1_value;

    private IntPtg() {
    }

    public IntPtg(RecordInputStream in) {
        this.setValue(in.readUShort());
    }

    public IntPtg(String formulaToken) {
        this.setValue(Integer.parseInt(formulaToken));
    }

    public void setValue(int value) {
        if (value < 0 || value > 65536) {
            throw new IllegalArgumentException("Unsigned short is out of range: " + value);
        }
        this.field_1_value = value;
    }

    public int getValue() {
        return this.field_1_value;
    }

    public int getValueAsInt() {
        if (this.field_1_value < 0) {
            return 65536 + this.field_1_value;
        }
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putUShort(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString(Workbook book) {
        return "" + this.getValue();
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        IntPtg ptg = new IntPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }
}

