/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import java.util.Iterator;
import javax.jcr.ReferentialIntegrityException;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.nodetype.NodeTypeRegistry;
import org.apache.jackrabbit.core.persistence.PersistenceManager;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ISMLocking;
import org.apache.jackrabbit.core.state.ItemStateCacheFactory;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.state.NodeReferencesId;
import org.apache.jackrabbit.core.state.SharedItemStateManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionItemStateManager
extends SharedItemStateManager {
    private static final Logger log = LoggerFactory.getLogger(VersionItemStateManager.class);
    private final PersistenceManager pMgr;

    public VersionItemStateManager(PersistenceManager persistMgr, NodeId rootNodeId, NodeTypeRegistry ntReg, ItemStateCacheFactory cacheFactory, ISMLocking locking) throws ItemStateException {
        super(persistMgr, rootNodeId, ntReg, false, cacheFactory, locking);
        this.pMgr = persistMgr;
    }

    public NodeReferences getNodeReferences(NodeReferencesId id) throws NoSuchItemStateException, ItemStateException {
        try {
            return this.pMgr.load(id);
        }
        catch (NoSuchItemStateException noSuchItemStateException) {
            throw new NoSuchItemStateException(id.toString());
        }
    }

    public boolean hasNodeReferences(NodeReferencesId id) {
        try {
            if (this.pMgr.exists(id)) {
                return true;
            }
        }
        catch (ItemStateException itemStateException) {
            // empty catch block
        }
        return false;
    }

    public boolean setNodeReferences(ChangeLog references) {
        try {
            ChangeLog log = new ChangeLog();
            Iterator iterator = references.modifiedRefs();
            while (iterator.hasNext()) {
                NodeReferences source = (NodeReferences)iterator.next();
                NodeReferences target = new NodeReferences(source.getId());
                Iterator iter = source.getReferences().iterator();
                while (iter.hasNext()) {
                    PropertyId id = (PropertyId)iter.next();
                    if (this.hasNonVirtualItemState(id.getParentId())) continue;
                    target.addReference(id);
                }
                log.modified(target);
            }
            if (log.hasUpdates()) {
                this.pMgr.store(log);
            }
            return true;
        }
        catch (ItemStateException e) {
            log.error("Error while setting references: " + e.toString());
            return false;
        }
    }

    protected void checkReferentialIntegrity(ChangeLog changes) throws ReferentialIntegrityException, ItemStateException {
        Iterator iter = changes.modifiedRefs();
        while (iter.hasNext()) {
            NodeReferences refs = (NodeReferences)iter.next();
            NodeId id = refs.getTargetId();
            if (!refs.hasReferences() || changes.has(id) || this.hasNonVirtualItemState(id)) continue;
            iter.remove();
        }
    }
}

