/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.sql.Timestamp;
import org.apache.derby.catalog.Statistics;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.uuid.UUIDFactory;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.DataDictionary;
import org.apache.derby.iapi.sql.dictionary.StatisticsDescriptor;
import org.apache.derby.iapi.sql.dictionary.SystemColumn;
import org.apache.derby.iapi.sql.dictionary.TupleDescriptor;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.ExecutionFactory;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.DataValueFactory;
import org.apache.derby.iapi.types.SQLTimestamp;
import org.apache.derby.impl.sql.catalog.SystemColumnImpl;

public class SYSSTATISTICSRowFactory
extends CatalogRowFactory {
    static final String TABLENAME_STRING = "SYSSTATISTICS";
    protected static final int SYSSTATISTICS_ID = 1;
    protected static final int SYSSTATISTICS_REFERENCEID = 2;
    protected static final int SYSSTATISTICS_TABLEID = 3;
    protected static final int SYSSTATISTICS_TIMESTAMP = 4;
    protected static final int SYSSTATISTICS_TYPE = 5;
    protected static final int SYSSTATISTICS_VALID = 6;
    protected static final int SYSSTATISTICS_COLCOUNT = 7;
    protected static final int SYSSTATISTICS_STAT = 8;
    protected static final int SYSSTATISTICS_COLUMN_COUNT = 8;
    protected static final int SYSSTATISTICS_INDEX1_ID = 0;
    private static final boolean[] uniqueness = new boolean[]{false};
    private static final int[][] indexColumnPositions = new int[][]{{3, 2}};
    private static final String[] uuids = new String[]{"f81e0010-00e3-6612-5a96-009e3a3b5e00", "08264012-00e3-6612-5a96-009e3a3b5e00", "c013800d-00e3-ffbe-37c6-009e3a3b5e00"};
    private SystemColumn[] columnList;

    public SYSSTATISTICSRowFactory(UUIDFactory uUIDFactory, ExecutionFactory executionFactory, DataValueFactory dataValueFactory, boolean bl) {
        super(uUIDFactory, executionFactory, dataValueFactory, bl);
        this.initInfo(8, TABLENAME_STRING, indexColumnPositions, uniqueness, uuids);
    }

    public ExecRow makeRow(TupleDescriptor tupleDescriptor, TupleDescriptor tupleDescriptor2) throws StandardException {
        String string = null;
        String string2 = null;
        String string3 = null;
        Object var6_6 = null;
        Object var7_7 = null;
        String string4 = null;
        Timestamp timestamp = null;
        int n = 0;
        Statistics statistics = null;
        boolean bl = false;
        ExecRow execRow = this.getExecutionFactory().getValueRow(8);
        if (tupleDescriptor != null) {
            StatisticsDescriptor statisticsDescriptor = (StatisticsDescriptor)tupleDescriptor;
            string = statisticsDescriptor.getUUID().toString();
            string3 = statisticsDescriptor.getTableUUID().toString();
            string2 = statisticsDescriptor.getReferenceID().toString();
            timestamp = statisticsDescriptor.getUpdateTimestamp();
            string4 = statisticsDescriptor.getStatType();
            bl = statisticsDescriptor.isValid();
            statistics = statisticsDescriptor.getStatistic();
            n = statisticsDescriptor.getColumnCount();
        }
        execRow.setColumn(1, this.dvf.getCharDataValue(string));
        execRow.setColumn(2, this.dvf.getCharDataValue(string2));
        execRow.setColumn(3, this.dvf.getCharDataValue(string3));
        execRow.setColumn(4, new SQLTimestamp(timestamp));
        execRow.setColumn(5, this.dvf.getCharDataValue(string4));
        execRow.setColumn(6, this.dvf.getDataValue(bl));
        execRow.setColumn(7, this.dvf.getDataValue(n));
        execRow.setColumn(8, this.dvf.getDataValue(statistics));
        return execRow;
    }

    public TupleDescriptor buildDescriptor(ExecRow execRow, TupleDescriptor tupleDescriptor, DataDictionary dataDictionary) throws StandardException {
        UUIDFactory uUIDFactory = this.getUUIDFactory();
        DataValueDescriptor dataValueDescriptor = execRow.getColumn(1);
        String string = dataValueDescriptor.getString();
        UUID uUID = uUIDFactory.recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(2);
        string = dataValueDescriptor.getString();
        UUID uUID2 = uUIDFactory.recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(3);
        string = dataValueDescriptor.getString();
        UUID uUID3 = uUIDFactory.recreateUUID(string);
        dataValueDescriptor = execRow.getColumn(4);
        Timestamp timestamp = (Timestamp)dataValueDescriptor.getObject();
        dataValueDescriptor = execRow.getColumn(5);
        String string2 = dataValueDescriptor.getString();
        dataValueDescriptor = execRow.getColumn(6);
        boolean bl = dataValueDescriptor.getBoolean();
        dataValueDescriptor = execRow.getColumn(7);
        int n = dataValueDescriptor.getInt();
        dataValueDescriptor = execRow.getColumn(8);
        Statistics statistics = (Statistics)dataValueDescriptor.getObject();
        return new StatisticsDescriptor(dataDictionary, uUID, uUID2, uUID3, string2, statistics, n);
    }

    public SystemColumn[] buildColumnList() {
        if (this.columnList != null) {
            return this.columnList;
        }
        this.columnList = new SystemColumn[8];
        this.columnList[0] = new SystemColumnImpl(this.convertIdCase("STATID"), 1, 0, 0, false, "CHAR", true, 36);
        this.columnList[1] = new SystemColumnImpl(this.convertIdCase("REFERENCEID"), 2, 0, 0, false, "CHAR", true, 36);
        this.columnList[2] = new SystemColumnImpl(this.convertIdCase("TABLEID"), 3, 0, 0, false, "CHAR", true, 36);
        this.columnList[3] = new SystemColumnImpl(this.convertIdCase("CREATIONTIMESTAMP"), 4, 0, 0, false, "TIMESTAMP", true, 26);
        this.columnList[4] = new SystemColumnImpl(this.convertIdCase("TYPE"), 5, 0, 0, false, "CHAR", true, 1);
        this.columnList[5] = new SystemColumnImpl(this.convertIdCase("VALID"), 6, 0, 0, false, "BOOLEAN", true, 1);
        this.columnList[6] = new SystemColumnImpl(this.convertIdCase("COLCOUNT"), 7, 0, 0, false, "INTEGER", true, 4);
        this.columnList[7] = new SystemColumnImpl(this.convertIdCase("STATISTICS"), 8, 0, 0, false, "org.apache.derby.catalog.Statistics", false, 12);
        return this.columnList;
    }
}

