/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene;

import java.io.IOException;
import java.io.StringReader;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeMap;
import org.apache.jackrabbit.core.NodeId;
import org.apache.jackrabbit.core.query.lucene.FieldNames;
import org.apache.jackrabbit.core.query.lucene.HighlightingExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.SearchIndex;
import org.apache.jackrabbit.core.query.lucene.SimpleExcerptProvider;
import org.apache.jackrabbit.core.query.lucene.Util;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.index.TermPositionVector;
import org.apache.lucene.index.TermVectorOffsetInfo;
import org.apache.lucene.search.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractExcerpt
implements HighlightingExcerptProvider {
    private static final Logger log = LoggerFactory.getLogger(AbstractExcerpt.class);
    protected SearchIndex index;
    protected Query query;
    private boolean rewritten = false;

    public void init(Query query, SearchIndex index) throws IOException {
        this.index = index;
        this.query = query;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExcerpt(NodeId id, int maxFragments, int maxFragmentSize) throws IOException {
        IndexReader reader = this.index.getIndexReader();
        try {
            Document doc;
            int docNumber;
            block15: {
                this.checkRewritten(reader);
                Term idTerm = new Term(FieldNames.UUID, id.getUUID().toString());
                TermDocs tDocs = reader.termDocs(idTerm);
                try {
                    if (tDocs.next()) {
                        docNumber = tDocs.doc();
                        doc = reader.document(docNumber);
                        break block15;
                    }
                    String string = null;
                    return string;
                }
                finally {
                    tDocs.close();
                }
            }
            Fieldable[] fields = doc.getFieldables(FieldNames.FULLTEXT);
            if (fields == null) {
                log.debug("Fulltext field not stored, using {}", (Object)SimpleExcerptProvider.class.getName());
                SimpleExcerptProvider exProvider = new SimpleExcerptProvider();
                exProvider.init(this.query, this.index);
                String string = exProvider.getExcerpt(id, maxFragments, maxFragmentSize);
                return string;
            }
            StringBuffer text = new StringBuffer();
            String separator = "";
            for (int i = 0; i < fields.length; ++i) {
                if (fields[i].stringValue().length() == 0) continue;
                text.append(separator);
                text.append(fields[i].stringValue());
                if (i < fields.length - 1) {
                    for (int j = text.length() - 1; j >= 0 && !Character.isLetterOrDigit(text.charAt(j)); --j) {
                        text.deleteCharAt(j);
                    }
                }
                separator = " ";
            }
            TermFreqVector tfv = reader.getTermFreqVector(docNumber, FieldNames.FULLTEXT);
            if (tfv instanceof TermPositionVector) {
                String string = this.createExcerpt((TermPositionVector)tfv, text.toString(), maxFragments, maxFragmentSize);
                return string;
            }
            log.debug("No TermPositionVector on Fulltext field.");
            String string = null;
            return string;
        }
        finally {
            Util.closeOrRelease(reader);
        }
    }

    public String highlight(String text) throws IOException {
        this.checkRewritten(null);
        return this.createExcerpt(this.createTermPositionVector(text), text, 1, (text.length() + 1) * 2);
    }

    protected abstract String createExcerpt(TermPositionVector var1, String var2, int var3, int var4) throws IOException;

    protected final Set getQueryTerms() {
        HashSet extractedTerms = new HashSet();
        HashSet<Term> relevantTerms = new HashSet<Term>();
        this.query.extractTerms(extractedTerms);
        Iterator it = extractedTerms.iterator();
        while (it.hasNext()) {
            Term t = (Term)it.next();
            if (t.field().equals(FieldNames.FULLTEXT)) {
                relevantTerms.add(t);
                continue;
            }
            int idx = t.field().indexOf("FULL:");
            if (idx == -1) continue;
            relevantTerms.add(new Term(FieldNames.FULLTEXT, t.text()));
        }
        return relevantTerms;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRewritten(IndexReader reader) throws IOException {
        if (!this.rewritten) {
            IndexReader r = reader;
            if (r == null) {
                r = this.index.getIndexReader();
            }
            try {
                this.query = this.query.rewrite(r);
            }
            finally {
                if (reader == null) {
                    Util.closeOrRelease(r);
                }
            }
            this.rewritten = true;
        }
    }

    private TermPositionVector createTermPositionVector(String text) {
        final TreeMap<String, TermVectorOffsetInfo[]> termMap = new TreeMap<String, TermVectorOffsetInfo[]>();
        StringReader r = new StringReader(text);
        TokenStream ts = this.index.getTextAnalyzer().tokenStream("", r);
        Token t = new Token();
        try {
            while ((t = ts.next(t)) != null) {
                String termText = t.term();
                TermVectorOffsetInfo[] info = (TermVectorOffsetInfo[])termMap.get(termText);
                if (info == null) {
                    info = new TermVectorOffsetInfo[1];
                } else {
                    TermVectorOffsetInfo[] tmp = info;
                    info = new TermVectorOffsetInfo[tmp.length + 1];
                    System.arraycopy(tmp, 0, info, 0, tmp.length);
                }
                info[info.length - 1] = new TermVectorOffsetInfo(t.startOffset(), t.endOffset());
                termMap.put(termText, info);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        return new TermPositionVector(){
            private String[] terms;
            {
                this.terms = termMap.keySet().toArray(new String[termMap.size()]);
            }

            public int[] getTermPositions(int index) {
                return null;
            }

            public TermVectorOffsetInfo[] getOffsets(int index) {
                TermVectorOffsetInfo[] info = TermVectorOffsetInfo.EMPTY_OFFSET_INFO;
                if (index >= 0 && index < this.terms.length) {
                    info = (TermVectorOffsetInfo[])termMap.get(this.terms[index]);
                }
                return info;
            }

            public String getField() {
                return "";
            }

            public int size() {
                return this.terms.length;
            }

            public String[] getTerms() {
                return this.terms;
            }

            public int[] getTermFrequencies() {
                int[] freqs = new int[this.terms.length];
                for (int i = 0; i < this.terms.length; ++i) {
                    freqs[i] = ((TermVectorOffsetInfo[])termMap.get(this.terms[i])).length;
                }
                return freqs;
            }

            public int indexOf(String term) {
                int res = Arrays.binarySearch(this.terms, term);
                return res >= 0 ? res : -1;
            }

            public int[] indexesOf(String[] terms, int start, int len) {
                int[] res = new int[len];
                for (int i = 0; i < len; ++i) {
                    res[i] = this.indexOf(terms[i]);
                }
                return res;
            }
        };
    }
}

