/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import javax.jcr.InvalidItemStateException;
import javax.jcr.ItemVisitor;
import javax.jcr.Node;
import javax.jcr.Property;
import javax.jcr.RepositoryException;
import javax.jcr.Value;
import javax.jcr.ValueFactory;
import javax.jcr.ValueFormatException;
import javax.jcr.lock.LockException;
import javax.jcr.nodetype.ConstraintViolationException;
import javax.jcr.nodetype.PropertyDefinition;
import javax.jcr.version.VersionException;
import org.apache.jackrabbit.core.ItemImpl;
import org.apache.jackrabbit.core.ItemManager;
import org.apache.jackrabbit.core.NodeImpl;
import org.apache.jackrabbit.core.PropertyData;
import org.apache.jackrabbit.core.PropertyId;
import org.apache.jackrabbit.core.SessionImpl;
import org.apache.jackrabbit.core.nodetype.PropDef;
import org.apache.jackrabbit.core.nodetype.PropertyDefinitionImpl;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.PropertyState;
import org.apache.jackrabbit.core.value.BLOBFileValue;
import org.apache.jackrabbit.core.value.InternalValue;
import org.apache.jackrabbit.spi.Name;
import org.apache.jackrabbit.spi.Path;
import org.apache.jackrabbit.spi.commons.name.NameConstants;
import org.apache.jackrabbit.value.ValueHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyImpl
extends ItemImpl
implements Property {
    private static Logger log = LoggerFactory.getLogger(PropertyImpl.class);
    private final PropertyData data;

    PropertyImpl(ItemManager itemMgr, SessionImpl session, PropertyData data) {
        super(itemMgr, session, data);
        this.data = data;
    }

    private PropertyState getPropertyState() throws RepositoryException {
        ItemState state = this.getItemState();
        this.sanityCheck();
        return (PropertyState)state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized ItemState getOrCreateTransientItemState() throws RepositoryException {
        PropertyData propertyData = this.data;
        synchronized (propertyData) {
            if (!this.isTransient()) {
                try {
                    PropertyState transientState = this.stateMgr.createTransientPropertyState(this.data.getPropertyState(), 2);
                    this.data.setState(transientState);
                }
                catch (ItemStateException ise) {
                    String msg = "failed to create transient state";
                    log.debug(msg);
                    throw new RepositoryException(msg, ise);
                }
            }
            return this.getItemState();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void makePersistent() throws InvalidItemStateException {
        if (!this.isTransient()) {
            log.debug(this + " (" + this.id + "): there's no transient state to persist");
            return;
        }
        PropertyState transientState = this.data.getPropertyState();
        PropertyState persistentState = (PropertyState)transientState.getOverlayedState();
        if (persistentState == null) {
            persistentState = this.stateMgr.createNew(transientState);
        }
        PropertyState propertyState = persistentState;
        synchronized (propertyState) {
            if (transientState.isStale()) {
                String msg = this + ": the property cannot be saved because it has" + " been modified externally.";
                log.debug(msg);
                throw new InvalidItemStateException(msg);
            }
            persistentState.setType(transientState.getType());
            persistentState.setMultiValued(transientState.isMultiValued());
            persistentState.setValues(transientState.getValues());
            this.stateMgr.store(persistentState);
        }
        this.stateMgr.disconnectTransientItemState(transientState);
        this.data.setState(persistentState);
        this.data.setStatus(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restoreTransient(PropertyState transientState) throws RepositoryException {
        PropertyState thisState = null;
        if (!this.isTransient()) {
            thisState = (PropertyState)this.getOrCreateTransientItemState();
            if (transientState.getStatus() == 4 && thisState.getStatus() != 4) {
                thisState.setStatus(4);
                this.stateMgr.disconnectTransientItemState(thisState);
            }
        } else {
            PropertyData propertyData = this.data;
            synchronized (propertyData) {
                try {
                    thisState = this.stateMgr.createTransientPropertyState(transientState.getParentId(), transientState.getName(), 4);
                    this.data.setState(thisState);
                }
                catch (ItemStateException e) {
                    throw new RepositoryException(e);
                }
            }
        }
        thisState.setType(transientState.getType());
        thisState.setMultiValued(transientState.isMultiValued());
        thisState.setValues(transientState.getValues());
    }

    protected void onRedefine(PropDef def) throws RepositoryException {
        PropertyDefinitionImpl newDef = this.session.getNodeTypeManager().getPropertyDefinition(def);
        this.data.setDefinition(newDef);
    }

    protected long getLength(InternalValue value) throws RepositoryException {
        switch (value.getType()) {
            case 1: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: {
                return value.toString().length();
            }
            case 7: {
                Name name = value.getQName();
                return this.session.getJCRName(name).length();
            }
            case 8: {
                Path path = value.getPath();
                return this.session.getJCRPath(path).length();
            }
            case 2: {
                BLOBFileValue blob = value.getBLOBFileValue();
                return blob.getLength();
            }
        }
        return -1L;
    }

    protected void checkSetValue(boolean multipleValues) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        NodeImpl parent = (NodeImpl)this.getParent();
        if (multipleValues != this.isMultiple()) {
            String msg = multipleValues ? "Single-valued property can not be set to an array of values:" : "Multivalued property can not be set to a single value (an array of length one is OK): ";
            throw new ValueFormatException(msg + this);
        }
        int options = 16;
        this.session.getValidator().checkModify(this, options, 0);
        options = 390;
        this.session.getValidator().checkModify(parent, options, 0);
    }

    protected void internalSetValue(InternalValue[] values, int type) throws ConstraintViolationException, RepositoryException {
        if (values == null) {
            ((NodeImpl)this.getParent()).removeChildProperty(((PropertyId)this.id).getName());
            return;
        }
        ArrayList<InternalValue> list = new ArrayList<InternalValue>();
        for (int i = 0; i < values.length; ++i) {
            if (values[i] == null) continue;
            list.add(values[i]);
        }
        values = list.toArray(new InternalValue[list.size()]);
        PropertyState thisState = (PropertyState)this.getOrCreateTransientItemState();
        InternalValue[] oldValues = thisState.getValues();
        if (oldValues != null) {
            for (int i = 0; i < oldValues.length; ++i) {
                InternalValue old = oldValues[i];
                if (old == null || old.getType() != 2) continue;
                old.getBLOBFileValue().discard();
            }
        }
        thisState.setValues(values);
        if (type == 0) {
            type = 1;
        }
        thisState.setType(type);
    }

    public void setValue(Name name) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        InternalValue internalValue;
        this.sanityCheck();
        this.checkSetValue(false);
        PropertyDefinition definition = this.data.getPropertyDefinition();
        int reqType = definition.getRequiredType();
        if (reqType == 0) {
            reqType = 7;
        }
        if (name == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        if (reqType != 7) {
            Value targetValue = ValueHelper.convert(InternalValue.create(name).toJCRValue(this.session), reqType, this.session.getValueFactory());
            internalValue = InternalValue.create(targetValue, this.session, this.rep.getDataStore());
        } else {
            internalValue = InternalValue.create(name);
        }
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(Name[] names) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.sanityCheck();
        this.checkSetValue(true);
        PropertyDefinition definition = this.data.getPropertyDefinition();
        int reqType = definition.getRequiredType();
        if (reqType == 0) {
            reqType = 7;
        }
        InternalValue[] internalValues = null;
        if (names != null) {
            internalValues = new InternalValue[names.length];
            for (int i = 0; i < names.length; ++i) {
                Name name = names[i];
                InternalValue internalValue = null;
                if (name != null) {
                    if (reqType != 7) {
                        Value targetValue = ValueHelper.convert(InternalValue.create(name).toJCRValue(this.session), reqType, this.session.getValueFactory());
                        internalValue = InternalValue.create(targetValue, this.session, this.rep.getDataStore());
                    } else {
                        internalValue = InternalValue.create(name);
                    }
                }
                internalValues[i] = internalValue;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public Name getQName() {
        return ((PropertyId)this.id).getName();
    }

    public InternalValue[] internalGetValues() throws RepositoryException {
        PropertyDefinition definition = this.data.getPropertyDefinition();
        if (this.isMultiple()) {
            return this.getPropertyState().getValues();
        }
        throw new ValueFormatException(this + " is a single-valued property," + " so it's value can not be retrieved as an array");
    }

    public InternalValue internalGetValue() throws RepositoryException {
        PropertyDefinition definition = this.data.getPropertyDefinition();
        if (this.isMultiple()) {
            throw new ValueFormatException(this + " is a multi-valued property," + " so it's values can only be retrieved as an array");
        }
        InternalValue[] values = this.getPropertyState().getValues();
        if (values.length > 0) {
            return values[0];
        }
        throw new RepositoryException(this + ": single-valued property with no value");
    }

    public Value[] getValues() throws RepositoryException {
        InternalValue[] internals = this.internalGetValues();
        Value[] values = new Value[internals.length];
        for (int i = 0; i < internals.length; ++i) {
            values[i] = internals[i].toJCRValue(this.session);
        }
        return values;
    }

    public Value getValue() throws RepositoryException {
        try {
            return this.internalGetValue().toJCRValue(this.session);
        }
        catch (RuntimeException e) {
            String msg = "Internal error while retrieving value of " + this;
            log.error(msg, e);
            throw new RepositoryException(msg, e);
        }
    }

    public String getString() throws RepositoryException {
        return this.getValue().getString();
    }

    public InputStream getStream() throws RepositoryException {
        return this.getValue().getStream();
    }

    public long getLong() throws RepositoryException {
        return this.getValue().getLong();
    }

    public double getDouble() throws RepositoryException {
        return this.getValue().getDouble();
    }

    public Calendar getDate() throws RepositoryException {
        return this.getValue().getDate();
    }

    public boolean getBoolean() throws RepositoryException {
        return this.getValue().getBoolean();
    }

    public Node getNode() throws ValueFormatException, RepositoryException {
        Value value = this.getValue();
        if (value.getType() == 9) {
            return this.session.getNodeByUUID(value.getString());
        }
        throw new ValueFormatException("property must be of type REFERENCE");
    }

    public void setValue(Calendar value) throws RepositoryException {
        if (value != null) {
            try {
                this.setValue(this.session.getValueFactory().createValue(value));
            }
            catch (IllegalArgumentException e) {
                throw new ValueFormatException(e.getMessage());
            }
        } else {
            this.remove();
        }
    }

    public void setValue(double value) throws RepositoryException {
        this.setValue(this.session.getValueFactory().createValue(value));
    }

    public void setValue(InputStream value) throws RepositoryException {
        if (value != null) {
            this.setValue(this.session.getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public void setValue(String value) throws RepositoryException {
        if (value != null) {
            this.setValue(this.session.getValueFactory().createValue(value));
        } else {
            this.remove();
        }
    }

    public void setValue(String[] strings) throws RepositoryException {
        if (strings != null) {
            ValueFactory factory = this.session.getValueFactory();
            Value[] values = new Value[strings.length];
            for (int i = 0; i < strings.length; ++i) {
                if (strings[i] == null) continue;
                values[i] = factory.createValue(strings[i]);
            }
            this.setValue(values);
        } else {
            this.remove();
        }
    }

    public void setValue(boolean value) throws RepositoryException {
        this.setValue(this.session.getValueFactory().createValue(value));
    }

    public void setValue(Node target) throws ValueFormatException, RepositoryException {
        if (target == null) {
            this.remove();
        } else if (((NodeImpl)target).isNodeType(NameConstants.MIX_REFERENCEABLE)) {
            this.setValue(this.session.getValueFactory().createValue(target.getUUID(), 9));
        } else {
            throw new ValueFormatException("target node must be of node type mix:referenceable");
        }
    }

    public void setValue(long value) throws RepositoryException {
        this.setValue(this.session.getValueFactory().createValue(value));
    }

    public synchronized void setValue(Value value) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        InternalValue internalValue;
        this.sanityCheck();
        this.checkSetValue(false);
        PropertyDefinition definition = this.data.getPropertyDefinition();
        int reqType = definition.getRequiredType();
        if (reqType == 0) {
            reqType = value != null ? value.getType() : 1;
        }
        if (value == null) {
            this.internalSetValue(null, reqType);
            return;
        }
        if (reqType != value.getType()) {
            Value targetVal = ValueHelper.convert(value, reqType, this.session.getValueFactory());
            internalValue = InternalValue.create(targetVal, this.session, this.rep.getDataStore());
        } else {
            internalValue = InternalValue.create(value, this.session, this.rep.getDataStore());
        }
        this.internalSetValue(new InternalValue[]{internalValue}, reqType);
    }

    public void setValue(Value[] values) throws ValueFormatException, VersionException, LockException, ConstraintViolationException, RepositoryException {
        this.setValue(values, 0);
    }

    public void setValue(Value[] values, int valueType) throws RepositoryException {
        PropertyDefinition definition;
        int reqType;
        this.sanityCheck();
        this.checkSetValue(true);
        if (values != null) {
            int firstValueType = 0;
            for (int i = 0; i < values.length; ++i) {
                if (values[i] == null) continue;
                if (firstValueType == 0) {
                    firstValueType = values[i].getType();
                    continue;
                }
                if (firstValueType == values[i].getType()) continue;
                throw new ValueFormatException("inhomogeneous type of values");
            }
        }
        if ((reqType = (definition = this.data.getPropertyDefinition()).getRequiredType()) == 0) {
            reqType = valueType;
        }
        InternalValue[] internalValues = null;
        if (values != null) {
            internalValues = new InternalValue[values.length];
            for (int i = 0; i < values.length; ++i) {
                Value value = values[i];
                if (value != null) {
                    if (reqType == 0) {
                        reqType = value.getType();
                    }
                    if (reqType != value.getType()) {
                        value = ValueHelper.convert(value, reqType, this.session.getValueFactory());
                    }
                    internalValues[i] = InternalValue.create(value, this.session, this.rep.getDataStore());
                    continue;
                }
                internalValues[i] = null;
            }
        }
        this.internalSetValue(internalValues, reqType);
    }

    public long getLength() throws RepositoryException {
        return this.getLength(this.internalGetValue());
    }

    public long[] getLengths() throws RepositoryException {
        InternalValue[] values = this.internalGetValues();
        long[] lengths = new long[values.length];
        for (int i = 0; i < values.length; ++i) {
            lengths[i] = this.getLength(values[i]);
        }
        return lengths;
    }

    public PropertyDefinition getDefinition() throws RepositoryException {
        this.sanityCheck();
        return this.data.getPropertyDefinition();
    }

    public int getType() throws RepositoryException {
        return this.getPropertyState().getType();
    }

    public boolean isMultiple() throws RepositoryException {
        this.sanityCheck();
        return this.getPropertyState().isMultiValued();
    }

    public boolean isNode() {
        return false;
    }

    public String getName() throws RepositoryException {
        this.sanityCheck();
        return this.session.getJCRName(((PropertyId)this.id).getName());
    }

    public void accept(ItemVisitor visitor) throws RepositoryException {
        this.sanityCheck();
        visitor.visit(this);
    }

    public Node getParent() throws RepositoryException {
        return (Node)((Object)this.itemMgr.getItem(this.getPropertyState().getParentId()));
    }

    public String toString() {
        return "property " + super.toString();
    }
}

