/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.query.lucene.join;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.jackrabbit.core.query.lucene.HierarchyResolver;
import org.apache.jackrabbit.core.query.lucene.MultiColumnQueryHits;
import org.apache.jackrabbit.core.query.lucene.ScoreNode;
import org.apache.jackrabbit.core.query.lucene.join.AbstractCondition;
import org.apache.jackrabbit.core.query.lucene.join.ScoreNodeMap;
import org.apache.jackrabbit.spi.Name;
import org.apache.lucene.index.IndexReader;

public class DescendantNodeJoin
extends AbstractCondition {
    private final ScoreNodeMap contextIndex = new ScoreNodeMap();
    private final IndexReader reader;
    private final HierarchyResolver resolver;
    private int[] docNums = new int[1];
    private final List ancestors = new ArrayList();
    private final List scoreNodes = new ArrayList();

    public DescendantNodeJoin(MultiColumnQueryHits context, Name contextSelectorName, IndexReader reader, HierarchyResolver resolver) throws IOException {
        super(context);
        ScoreNode[] nodes;
        this.reader = reader;
        this.resolver = resolver;
        int idx = DescendantNodeJoin.getIndex(context, contextSelectorName);
        while ((nodes = context.nextScoreNodes()) != null) {
            Integer docNum = new Integer(nodes[idx].getDoc(reader));
            this.contextIndex.addScoreNodes(docNum, nodes);
        }
    }

    public ScoreNode[][] getMatchingScoreNodes(ScoreNode descendant) throws IOException {
        this.ancestors.clear();
        this.collectAncestors(descendant.getDoc(this.reader));
        this.scoreNodes.clear();
        for (int i = 0; i < this.ancestors.size(); ++i) {
            Integer ancestor = (Integer)this.ancestors.get(i);
            ScoreNode[][] sn = this.contextIndex.getScoreNodes(ancestor);
            if (sn == null) continue;
            for (int j = 0; j < sn.length; ++j) {
                this.scoreNodes.add(sn[j]);
            }
        }
        if (this.scoreNodes.isEmpty()) {
            return null;
        }
        return (ScoreNode[][])this.scoreNodes.toArray((T[])new ScoreNode[this.scoreNodes.size()][]);
    }

    private void collectAncestors(int doc) throws IOException {
        this.docNums = this.resolver.getParents(doc, this.docNums);
        if (this.docNums.length == 1) {
            this.ancestors.add(new Integer(this.docNums[0]));
            this.collectAncestors(this.docNums[0]);
        } else if (this.docNums.length > 1) {
            int[] tmp = (int[])this.docNums.clone();
            for (int i = 0; i < tmp.length; ++i) {
                this.ancestors.add(new Integer(tmp[i]));
                this.collectAncestors(tmp[i]);
            }
        }
    }
}

