/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.util.LittleEndian;

public final class RecordInputStream
extends InputStream {
    public static final short MAX_RECORD_DATA_SIZE = 8224;
    private static final int INVALID_SID_VALUE = -1;
    private InputStream in;
    private short currentSid;
    private short currentLength = (short)-1;
    private short nextSid;
    private final byte[] data = new byte[8224];
    private short recordOffset;
    private long pos;
    private boolean autoContinue = true;

    public RecordInputStream(InputStream in) throws RecordFormatException {
        this.in = in;
        try {
            this.nextSid = LittleEndian.readShort(in);
        }
        catch (IOException ex) {
            throw new RecordFormatException("Error reading bytes", ex);
        }
    }

    public int read() {
        this.checkRecordPosition(1);
        byte result = this.data[this.recordOffset];
        this.recordOffset = (short)(this.recordOffset + 1);
        ++this.pos;
        return result;
    }

    public short getSid() {
        return this.currentSid;
    }

    public short getLength() {
        return this.currentLength;
    }

    public short getRecordOffset() {
        return this.recordOffset;
    }

    public long getPos() {
        return this.pos;
    }

    public boolean hasNextRecord() {
        return this.nextSid != -1;
    }

    public void nextRecord() throws RecordFormatException {
        if (this.currentLength != -1 && this.currentLength != this.recordOffset) {
            System.out.println("WARN. Unread " + this.remaining() + " bytes of record 0x" + Integer.toHexString(this.currentSid));
        }
        this.currentSid = this.nextSid;
        this.pos += 2L;
        this.autoContinue = true;
        try {
            this.recordOffset = 0;
            this.currentLength = LittleEndian.readShort(this.in);
            if (this.currentLength > 8224) {
                throw new RecordFormatException("The content of an excel record cannot exceed 8224 bytes");
            }
            this.pos += 2L;
            this.in.read(this.data, 0, this.currentLength);
            if (this.in.available() < 4) {
                if (this.in.available() > 0) {
                    // empty if block
                }
                this.nextSid = (short)-1;
            } else {
                this.nextSid = LittleEndian.readShort(this.in);
                if (this.nextSid == -1) {
                    throw new RecordFormatException("Found sid " + this.nextSid + " after record with sid 0x" + Integer.toHexString(this.currentSid).toUpperCase());
                }
            }
        }
        catch (IOException ex) {
            throw new RecordFormatException("Error reading bytes", ex);
        }
    }

    public void setAutoContinue(boolean enable) {
        this.autoContinue = enable;
    }

    public boolean getAutoContinue() {
        return this.autoContinue;
    }

    private void checkRecordPosition(int requiredByteCount) {
        if (this.remaining() < requiredByteCount) {
            if (this.isContinueNext() && this.autoContinue) {
                this.nextRecord();
            } else {
                throw new ArrayIndexOutOfBoundsException();
            }
        }
    }

    public byte readByte() {
        this.checkRecordPosition(1);
        byte result = this.data[this.recordOffset];
        this.recordOffset = (short)(this.recordOffset + 1);
        ++this.pos;
        return result;
    }

    public short readShort() {
        this.checkRecordPosition(2);
        short result = LittleEndian.getShort(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 2);
        this.pos += 2L;
        return result;
    }

    public int readInt() {
        this.checkRecordPosition(4);
        int result = LittleEndian.getInt(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 4);
        this.pos += 4L;
        return result;
    }

    public long readLong() {
        this.checkRecordPosition(8);
        long result = LittleEndian.getLong(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 8);
        this.pos += 8L;
        return result;
    }

    public short readUByte() {
        return (short)(this.readByte() & 0xFF);
    }

    public int readUShort() {
        this.checkRecordPosition(2);
        int result = LittleEndian.getUShort(this.data, this.recordOffset);
        this.recordOffset = (short)(this.recordOffset + 2);
        this.pos += 2L;
        return result;
    }

    public double readDouble() {
        this.checkRecordPosition(8);
        long valueLongBits = LittleEndian.getLong(this.data, this.recordOffset);
        double result = Double.longBitsToDouble(valueLongBits);
        if (Double.isNaN(result)) {
            throw new RuntimeException("Did not expect to read NaN");
        }
        this.recordOffset = (short)(this.recordOffset + 8);
        this.pos += 8L;
        return result;
    }

    public String readString() {
        int requestedLength = this.readUShort();
        byte compressFlag = this.readByte();
        return this.readStringCommon(requestedLength, compressFlag == 0);
    }

    public String readUnicodeLEString(int requestedLength) {
        return this.readStringCommon(requestedLength, false);
    }

    public String readCompressedUnicode(int requestedLength) {
        return this.readStringCommon(requestedLength, true);
    }

    private String readStringCommon(int requestedLength, boolean pIsCompressedEncoding) {
        if (requestedLength < 0 || requestedLength > 0x100000) {
            throw new IllegalArgumentException("Bad requested string length (" + requestedLength + ")");
        }
        char[] buf = new char[requestedLength];
        boolean isCompressedEncoding = pIsCompressedEncoding;
        int curLen = 0;
        while (true) {
            char ch;
            int availableChars;
            int n = availableChars = isCompressedEncoding ? this.remaining() : this.remaining() / 2;
            if (requestedLength - curLen <= availableChars) {
                while (curLen < requestedLength) {
                    ch = isCompressedEncoding ? (char)this.readUByte() : (char)this.readShort();
                    buf[curLen] = ch;
                    ++curLen;
                }
                return new String(buf);
            }
            while (availableChars > 0) {
                ch = isCompressedEncoding ? (char)this.readUByte() : (char)this.readShort();
                buf[curLen] = ch;
                ++curLen;
                --availableChars;
            }
            if (!this.isContinueNext()) {
                throw new RecordFormatException("Expected to find a ContinueRecord in order to read remaining " + (requestedLength - curLen) + " of " + requestedLength + " chars");
            }
            if (this.remaining() != 0) {
                throw new RecordFormatException("Odd number of bytes(" + this.remaining() + ") left behind");
            }
            this.nextRecord();
            byte compressFlag = this.readByte();
            isCompressedEncoding = compressFlag == 0;
        }
    }

    public UnicodeString readUnicodeString() {
        return new UnicodeString(this);
    }

    public byte[] readRemainder() {
        int size = this.remaining();
        byte[] result = new byte[size];
        System.arraycopy(this.data, this.recordOffset, result, 0, size);
        this.recordOffset = (short)(this.recordOffset + size);
        this.pos += (long)size;
        return result;
    }

    public byte[] readAllContinuedRemainder() {
        byte[] b;
        ByteArrayOutputStream out = new ByteArrayOutputStream(16448);
        while (this.isContinueNext()) {
            b = this.readRemainder();
            out.write(b, 0, b.length);
            this.nextRecord();
        }
        b = this.readRemainder();
        out.write(b, 0, b.length);
        return out.toByteArray();
    }

    public int remaining() {
        return this.currentLength - this.recordOffset;
    }

    public boolean isContinueNext() {
        return this.nextSid == 60;
    }
}

