/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.types;

import java.text.CollationElementIterator;
import java.text.RuleBasedCollator;
import org.apache.derby.iapi.error.StandardException;

public class Like {
    private static final char anyChar = '_';
    private static final char anyString = '%';
    private static final String SUPER_STRING = "\uffff";

    private Like() {
    }

    public static Boolean like(char[] cArray, int n, char[] cArray2, int n2, char[] cArray3, int n3) throws StandardException {
        return Like.like(cArray, 0, n, cArray2, 0, n2, cArray3, n3);
    }

    public static Boolean like(int[] nArray, int n, int[] nArray2, int n2, int[] nArray3, int n3, RuleBasedCollator ruleBasedCollator) throws StandardException {
        return Like.like(nArray, 0, n, nArray2, 0, n2, nArray3, n3, ruleBasedCollator);
    }

    private static Boolean like(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, char[] cArray3, int n5) throws StandardException {
        int n6;
        char c = ' ';
        boolean bl = true;
        if (cArray == null) {
            return null;
        }
        if (cArray2 == null) {
            return null;
        }
        if (cArray3 == null) {
            bl = false;
        } else {
            c = cArray3[0];
        }
        while (true) {
            Boolean bl2;
            if ((bl2 = Like.checkLengths(n, n2, n3, cArray2, n4)) != null) {
                return bl2;
            }
            while (!(cArray2[n3] == '_' || cArray2[n3] == '%' || bl && cArray2[n3] == c)) {
                if (cArray[n] == cArray2[n3]) {
                    if ((bl2 = Like.checkLengths(++n, n2, ++n3, cArray2, n4)) == null) continue;
                    return bl2;
                }
                return Boolean.FALSE;
            }
            if (bl && cArray2[n3] == c) {
                if (++n3 == n4) {
                    throw StandardException.newException("22025");
                }
                if (cArray2[n3] != c && cArray2[n3] != '_' && cArray2[n3] != '%') {
                    throw StandardException.newException("22025");
                }
                if (cArray[n] == cArray2[n3]) {
                    if ((bl2 = Like.checkLengths(++n, n2, ++n3, cArray2, n4)) == null) continue;
                    return bl2;
                }
                return Boolean.FALSE;
            }
            if (cArray2[n3] == '_') {
                if ((bl2 = Like.checkLengths(++n, n2, ++n3, cArray2, n4)) == null) continue;
                return bl2;
            }
            if (cArray2[n3] == '%') break;
        }
        if (n3 + 1 == n4) {
            return Boolean.TRUE;
        }
        boolean bl3 = true;
        for (n6 = n3 + 1; n6 < n4; ++n6) {
            if (cArray2[n6] == '%') continue;
            bl3 = false;
            break;
        }
        if (bl3) {
            return Boolean.TRUE;
        }
        n6 = n2 - n;
        int n7 = 0;
        int n8 = Like.getMinLen(cArray2, n3 + 1, n4, bl, c);
        for (int i = n6; i >= n8; --i) {
            Boolean bl4 = Like.like(cArray, n + n7, n + n7 + i, cArray2, n3 + 1, n4, cArray3, n5);
            if (bl4.booleanValue()) {
                return bl4;
            }
            ++n7;
        }
        return Boolean.FALSE;
    }

    private static Boolean like(int[] nArray, int n, int n2, int[] nArray2, int n3, int n4, int[] nArray3, int n5, RuleBasedCollator ruleBasedCollator) throws StandardException {
        int n6;
        int n7;
        int[] nArray4;
        int n8;
        int[] nArray5 = null;
        boolean bl = true;
        int[] nArray6 = new int[1];
        int[] nArray7 = new int[1];
        if (nArray == null) {
            return null;
        }
        if (nArray2 == null) {
            return null;
        }
        if (nArray3 == null) {
            bl = false;
        } else {
            nArray5 = nArray3;
        }
        CollationElementIterator collationElementIterator = ruleBasedCollator.getCollationElementIterator("_");
        nArray6[0] = collationElementIterator.next();
        while ((n8 = collationElementIterator.next()) != -1) {
            nArray4 = new int[nArray6.length + 1];
            for (n7 = 0; n7 < nArray6.length; ++n7) {
                nArray4[n7] = nArray6[n7];
            }
            nArray4[nArray6.length] = n8;
            nArray6 = nArray4;
        }
        collationElementIterator = ruleBasedCollator.getCollationElementIterator("%");
        nArray7[0] = collationElementIterator.next();
        while ((n8 = collationElementIterator.next()) != -1) {
            nArray4 = new int[nArray7.length + 1];
            for (n7 = 0; n7 < nArray7.length; ++n7) {
                nArray4[n7] = nArray7[n7];
            }
            nArray4[nArray7.length] = n8;
            nArray7 = nArray4;
        }
        while (true) {
            Boolean bl2;
            if ((bl2 = Like.checkLengths(n, n2, n3, nArray2, n4, nArray7)) != null) {
                return bl2;
            }
            while (!(Like.matchSpecial(nArray2, n3, n4, nArray6) || Like.matchSpecial(nArray2, n3, n4, nArray7) || bl && Like.matchSpecial(nArray2, n3, n4, nArray5))) {
                if (nArray[n] == nArray2[n3]) {
                    if ((bl2 = Like.checkLengths(++n, n2, ++n3, nArray2, n4, nArray7)) == null) continue;
                    return bl2;
                }
                return Boolean.FALSE;
            }
            if (bl && Like.matchSpecial(nArray2, n3, n4, nArray5)) {
                if ((n3 += nArray5.length) == n4) {
                    throw StandardException.newException("22025");
                }
                int[] nArray8 = null;
                if (Like.matchSpecial(nArray2, n3, n4, nArray5)) {
                    nArray8 = nArray5;
                }
                if (Like.matchSpecial(nArray2, n3, n4, nArray6)) {
                    nArray8 = nArray6;
                }
                if (Like.matchSpecial(nArray2, n3, n4, nArray7)) {
                    nArray8 = nArray7;
                }
                if (nArray8 == null) {
                    throw StandardException.newException("22025");
                }
                for (int i = 0; i < nArray8.length; ++i) {
                    if (nArray[n + i] == nArray2[n3 + i]) continue;
                    return Boolean.FALSE;
                }
                bl2 = Like.checkLengths(n += nArray8.length, n2, n3 += nArray8.length, nArray2, n4, nArray7);
                if (bl2 == null) continue;
                return bl2;
            }
            if (Like.matchSpecial(nArray2, n3, n4, nArray6)) {
                bl2 = Like.checkLengths(n += nArray6.length, n2, n3 += nArray6.length, nArray2, n4, nArray7);
                if (bl2 == null) continue;
                return bl2;
            }
            if (Like.matchSpecial(nArray2, n3, n4, nArray7)) break;
        }
        if (n3 + 1 == n4) {
            return Boolean.TRUE;
        }
        if (n == n2) {
            return Boolean.TRUE;
        }
        n8 = 1;
        for (n6 = n3 + 1; n6 < n4; ++n6) {
            if (Like.matchSpecial(nArray2, n6, n4, nArray7)) continue;
            n8 = 0;
            break;
        }
        if (n8 != 0) {
            return Boolean.TRUE;
        }
        n6 = n2 - n;
        n7 = 0;
        int n9 = Like.getMinLen(nArray2, n3 + 1, n4, bl, nArray5, nArray7);
        for (int i = n6; i >= n9; --i) {
            Boolean bl3 = Like.like(nArray, n + n7, n + n7 + i, nArray2, n3 + 1, n4, nArray3, n5, ruleBasedCollator);
            if (bl3.booleanValue()) {
                return bl3;
            }
            ++n7;
        }
        return Boolean.FALSE;
    }

    static int getMinLen(char[] cArray, int n, int n2, boolean bl, char c) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (bl && cArray[n4] == c) {
                n4 += 2;
                ++n3;
                continue;
            }
            if (cArray[n4] == '%') {
                ++n4;
                continue;
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    static int getMinLen(int[] nArray, int n, int n2, boolean bl, int[] nArray2, int[] nArray3) {
        int n3 = 0;
        int n4 = n;
        while (n4 < n2) {
            if (bl && Like.matchSpecial(nArray, n4, n2, nArray2)) {
                n4 += nArray2.length + 1;
                n3 += nArray2.length;
                continue;
            }
            if (Like.matchSpecial(nArray, n4, n2, nArray3)) {
                n4 += nArray3.length;
                continue;
            }
            ++n4;
            ++n3;
        }
        return n3;
    }

    static Boolean checkLengths(int n, int n2, int n3, char[] cArray, int n4) {
        if (n == n2) {
            if (n3 == n4) {
                return Boolean.TRUE;
            }
            for (int i = n3; i < n4; ++i) {
                if (cArray[i] == '%') continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (n3 == n4) {
            return Boolean.FALSE;
        }
        return null;
    }

    static Boolean checkLengths(int n, int n2, int n3, int[] nArray, int n4, int[] nArray2) {
        if (n == n2) {
            if (n3 == n4) {
                return Boolean.TRUE;
            }
            for (int i = n3; i < n4; i += nArray2.length) {
                if (Like.matchSpecial(nArray, i, n4, nArray2)) continue;
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        if (n3 == n4) {
            return Boolean.FALSE;
        }
        return null;
    }

    private static boolean matchSpecial(int[] nArray, int n, int n2, int[] nArray2) {
        if (nArray2.length > n2 - n) {
            return false;
        }
        if (nArray2.length <= n2 - n) {
            for (int i = 0; i < nArray2.length; ++i) {
                if (nArray[n + i] == nArray2[i]) continue;
                return false;
            }
        }
        return true;
    }

    public static Boolean like(char[] cArray, int n, char[] cArray2, int n2) throws StandardException {
        if (cArray == null || cArray2 == null) {
            return null;
        }
        return Like.like(cArray, n, cArray2, n2, null, 0);
    }

    public static Boolean like(int[] nArray, int n, int[] nArray2, int n2, RuleBasedCollator ruleBasedCollator) throws StandardException {
        if (nArray == null || nArray2 == null) {
            return null;
        }
        return Like.like(nArray, n, nArray2, n2, null, 0, ruleBasedCollator);
    }

    public static boolean isOptimizable(String string) {
        if (string == null || string.length() == 0) {
            return false;
        }
        char c = string.charAt(0);
        return c != '_' && c != '%';
    }

    public static String greaterEqualStringFromParameter(String string, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.greaterEqualString(string, null, n);
    }

    public static String greaterEqualStringFromParameterWithEsc(String string, String string2, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.greaterEqualString(string, string2, n);
    }

    public static String greaterEqualString(String string, String string2, int n) throws StandardException {
        char c;
        int n2 = string.indexOf(95);
        int n3 = string.indexOf(37);
        if (string2 != null && string2.length() != 0 && string.indexOf(c = string2.charAt(0)) != -1) {
            return Like.padWithNulls(Like.greaterEqualString(string, c), n);
        }
        if (n2 == -1) {
            if (n3 != -1) {
                string = string.substring(0, n3);
            }
        } else {
            string = n3 == -1 ? string.substring(0, n2) : string.substring(0, n2 > n3 ? n3 : n2);
        }
        return Like.padWithNulls(string, n);
    }

    private static String greaterEqualString(String string, char c) throws StandardException {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        for (int i = 0; i < n && n2 < n; ++i) {
            char c2 = cArray[i];
            if (c2 == c) {
                if (++i >= n) {
                    throw StandardException.newException("22025");
                }
                cArray2[n2++] = cArray[i];
                continue;
            }
            if (c2 == '_' || c2 == '%') {
                return new String(cArray2, 0, n2);
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2, 0, n2);
    }

    public static String stripEscapesNoPatternChars(String string, char c) throws StandardException {
        int n = string.length();
        char[] cArray = new char[n];
        char[] cArray2 = new char[n];
        string.getChars(0, n, cArray, 0);
        int n2 = 0;
        for (int i = 0; i < n && n2 < n; ++i) {
            char c2 = string.charAt(i);
            if (c2 == c) {
                if (++i >= n) {
                    throw StandardException.newException("22025");
                }
                cArray2[n2++] = cArray[i];
                continue;
            }
            if (c2 == '_' || c2 == '%') {
                return null;
            }
            cArray2[n2++] = cArray[i];
        }
        return new String(cArray2, 0, n2);
    }

    public static String lessThanStringFromParameter(String string, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.lessThanString(string, null, n);
    }

    public static String lessThanStringFromParameterWithEsc(String string, String string2, int n) throws StandardException {
        if (string == null) {
            return null;
        }
        return Like.lessThanString(string, string2, n);
    }

    public static String lessThanString(String string, String string2, int n) throws StandardException {
        char c;
        if (string.length() == 0) {
            return null;
        }
        char c2 = string2 != null && string2.length() != 0 ? (char)string2.charAt(0) : (char)'\uffffffff';
        StringBuffer stringBuffer = new StringBuffer(n);
        for (int i = 0; i < string.length(); ++i) {
            char c3 = string.charAt(i);
            if (c3 == c2) {
                if (++i >= string.length()) {
                    throw StandardException.newException("22025");
                }
                c3 = string.charAt(i);
            } else if (c3 == '_' || c3 == '%') break;
            stringBuffer.append(c3);
        }
        if (stringBuffer.length() == 0) {
            return SUPER_STRING;
        }
        int n2 = stringBuffer.length() - 1;
        char c4 = c = stringBuffer.charAt(n2);
        if ((c4 = (char)(c4 + '\u0001')) < c) {
            return SUPER_STRING;
        }
        stringBuffer.setCharAt(n2, c4);
        if (stringBuffer.length() < n) {
            stringBuffer.setLength(n);
        }
        return stringBuffer.toString();
    }

    public static boolean isLikeComparisonNeeded(String string) {
        int n = string.indexOf(95);
        int n2 = string.indexOf(37);
        if (n == -1 && n2 == -1) {
            return false;
        }
        if (n != -1) {
            return true;
        }
        return n2 != string.length() - 1;
    }

    private static String padWithNulls(String string, int n) {
        if (string.length() >= n) {
            return string;
        }
        StringBuffer stringBuffer = new StringBuffer(n).append(string);
        stringBuffer.setLength(n);
        return stringBuffer.toString();
    }
}

