/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.extractor;

import java.io.BufferedInputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.jackrabbit.extractor.AbstractTextExtractor;
import org.pdfbox.pdfparser.PDFParser;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.util.PDFTextStripper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfTextExtractor
extends AbstractTextExtractor {
    private static final Logger logger = LoggerFactory.getLogger(PdfTextExtractor.class);

    public PdfTextExtractor() {
        super(new String[]{"application/pdf"});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reader extractText(InputStream stream, String type, String encoding) throws IOException {
        try {
            CharArrayReader charArrayReader;
            PDFParser parser = new PDFParser(new BufferedInputStream(stream));
            try {
                parser.parse();
                PDDocument document = parser.getPDDocument();
                CharArrayWriter writer = new CharArrayWriter();
                PDFTextStripper stripper = new PDFTextStripper();
                stripper.setLineSeparator("\n");
                stripper.writeText(document, (Writer)writer);
                charArrayReader = new CharArrayReader(writer.toCharArray());
            }
            catch (Throwable throwable) {
                try {
                    try {
                        PDDocument doc = parser.getPDDocument();
                        if (doc == null) throw throwable;
                        doc.close();
                        throw throwable;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    logger.warn("Failed to extract PDF text content", e);
                    StringReader stringReader = new StringReader("");
                    return stringReader;
                }
            }
            try {
                PDDocument doc = parser.getPDDocument();
                if (doc == null) return charArrayReader;
                doc.close();
                return charArrayReader;
            }
            catch (IOException e) {
                // empty catch block
            }
            return charArrayReader;
        }
        finally {
            stream.close();
        }
    }

    static {
        PDFParser.class.getName();
    }
}

