/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public final class RecalcIdRecord
extends Record {
    public static final short sid = 449;
    public short[] field_1_recalcids;
    private boolean isNeeded = true;

    public RecalcIdRecord() {
    }

    public RecalcIdRecord(RecordInputStream in) {
        this.field_1_recalcids = new short[in.remaining() / 2];
        for (int k = 0; k < this.field_1_recalcids.length; ++k) {
            this.field_1_recalcids[k] = in.readShort();
        }
    }

    public void setRecalcIdArray(short[] array) {
        this.field_1_recalcids = array;
    }

    public short[] getRecalcIdArray() {
        return this.field_1_recalcids;
    }

    public void setIsNeeded(boolean isNeeded) {
        this.isNeeded = isNeeded;
    }

    public boolean isNeeded() {
        return this.isNeeded;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[RECALCID]\n");
        buffer.append("    .elements        = ").append(this.field_1_recalcids.length).append("\n");
        for (int k = 0; k < this.field_1_recalcids.length; ++k) {
            buffer.append("    .element_" + k + "       = ").append(this.field_1_recalcids[k]).append("\n");
        }
        buffer.append("[/RECALCID]\n");
        return buffer.toString();
    }

    public int serialize(int offset, byte[] data) {
        short[] tabids = this.getRecalcIdArray();
        short length = (short)(tabids.length * 2);
        int byteoffset = 4;
        LittleEndian.putUShort(data, 0 + offset, 449);
        LittleEndian.putUShort(data, 2 + offset, length);
        for (int k = 0; k < length / 2; ++k) {
            LittleEndian.putShort(data, byteoffset + offset, tabids[k]);
            byteoffset += 2;
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        return 4 + this.getRecalcIdArray().length * 2;
    }

    public short getSid() {
        return 449;
    }
}

